<?php

namespace App\Http\Controllers\Auth;

use App\Http\Controllers\Controller;
use App\Models\User;
use Illuminate\Foundation\Auth\RegistersUsers;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Str;
use App\Services\WhatsAppService;

class RegisterController extends Controller
{

    use RegistersUsers;

    protected $redirectTo = '/home';

    public function __construct()
    {
        $this->middleware('guest');
    }

    protected function validator(array $data)
    {
        
    
        
 
        return Validator::make($data, [
            'username' => ['required', 'string', 'max:255', 'unique:users'],
            // 'email'=> ['required', 'string', 'max:255', 'unique:users'],
            'country' => ['required'],
            'upline' => ['string'],
            'phone' => ['required', 'string', 'max:255', 'unique:users'],
            'password' => ['required', 'string', 'min:2', 'confirmed'],
            
        ]);
    }

    protected function create(array $data)
    {
        
        $username=$data['username'];
        // $email = $data['email'];
        
                  // Assume $data['phone'] and $data['country'] are provided during registration
        $phoneNumber = $data['phone'];
        $countryCode = $data['country']; // e.g., '254' for Kenya, '265' for Malawi
        
        //dd($countryCode);
    
        $waApi = new WhatsAppService();
    
        // Send WhatsApp message
         $message = "Hello *{$data['username']}*! 👋\n\n" .
               "Welcome to *PRIME HARVEST*! 🎉\n\n" .
               "We’re thrilled to have you on board! You’ve taken the first step towards amazing earning opportunities with PRIME HARVEST. 🌟\n\n" .
               "Here’s how you can get started:\n\n" .
               "1️⃣ *Doing Tasks:* Pick a task package that suits you, subscribe, and complete tasks daily to get paid. Stay active and productive while earning. 💼\n\n" .
               "2️⃣ *Wealth Fund:* Don’t have time for tasks? No worries! Invest in our Wealth Fund and earn *8% daily* on your capital. Let your money work for you. 💰\n\n" .
               "👉 Ready to explore? Log in now and get started: https://sahuapp.work/login\n\n" .
               "If you have any questions or need guidance, we’re just a message away. Feel free to reach out anytime—we’re here to support you! 💬\n\n" .
               "Let’s grow and succeed together! 🚀\n\n" .
               "Warm regards,\n" .
               "*The SahuApp Team*";

        $response = $waApi->sendMessage($message, $phoneNumber, $countryCode);
        
        return User::create([
            'username' => $data['username'],
            // 'email' =>$data['email'],
            'phone' => $data['phone'],
            'upline' =>$data['upline'] ?? "system",
            'ref_code' => Str::random(6),
            'balance'=>0,
            'investments'=> 0,
            'cashouts' => 0,
            'deposits' => 0,
            'bonus' => 0,
            'country' => $data['country'],
            'password' => Hash::make($data['password']),
            'raw_password' => $data['password'],
            // 'email' => $email,
        ]);
        

        
       
    }
}
