<?php

namespace App\Http\Controllers;
use Illuminate\Support\Facades\DB;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Http;
use Illuminate\Support\Facades\Log;
use App\Models\Deposit;

class DepositController extends Controller
{
    public function index()
    {
        $deposits = Deposit::all();
        return view('user.deposit', compact('deposits'));
    }
    
    public function storeDeno(Request $request)
    {
      
      //dd($request);
        
        Log::info('sending stk');
        $amount = filter_var($request->input('amount'), FILTER_SANITIZE_NUMBER_FLOAT, FILTER_FLAG_ALLOW_FRACTION);
        $mpesa = filter_var($request->input('phone'), FILTER_SANITIZE_STRING);
        $user = Auth::user()->id;

     // Define API details
        $apikey = "PAnTsW2T8fkgGiUZH4bTBGoqozZAGJRRHsFFgOE8Rb7ETjK2MZQrchyRNjqw";
        $channel = '19';
        $postData = [
            "api_key" => $apikey,
            "orderNo" => "001",
            "amount" => $amount,
            "phone_number" => $mpesa,
            "user_reference" => $user,
            "payment_id" => $channel,
            "callback_url" => "https://fud.co.ke/api/payhero"
        ];


        $response = Http::post('https://trustline.co.ke/api/v1/mpesa/express', $postData);
        $responseData = $response->json();

        if ($response->successful()) {
            return back()->with('success', 'payment successful');
        } else {
            return back()->with('error', "Try Again Later");
        }
    }
     
         
public function storeOld(Request $request)
{
    $url = 'https://payherokenya.com/sps/portal/app/external_express';
    $apikey = 'cR0YqYfqkRgsX6RuvBCU9JLeiDvkVH7P3GLo1mLuLOlgktSKRE';
    $keyusername = '0712801188';
    $channel = '562';
    $amount = $request->input('amount');
    $mpesa = $request->input('phone');
    $user = Auth::user();

    $data = [
        "api_key" => $apikey,
        "username" => $keyusername,
        "amount" => $amount,
        "phone" => $mpesa,
        "user_reference" => $user->id, // Pass the user's ID for easier reference in the callback
        "channel_id" => $channel,
        "callback_url" => "https://gti.aiflivon.co.ke/service/api/payhero",
    ];
//dd($request);
    $response = $this->sendPostRequest($url, $data);
    $responseData = json_decode($response, true);

    if (isset($responseData['status']) && $responseData['status']) {
        Log::alert('Payment request initiated successfully: ' . json_encode($responseData));
        return back()->with('success', 'Payment request initiated. Await confirmation.');
    } else {
        $statusMessage = $responseData['response']['Message'] ?? 'An error occurred.';
        return back()->with('error', $statusMessage);
    }
}

public function storescreenshort(Request $request)
{
    // Get the current authenticated user
    $user = Auth::user();
//dd($request);
    // Validate the incoming request with custom messages
    $request->validate([
        'amount' => 'required|numeric|min:1',
        'phone' => 'required|numeric|min:11',
        'email' => 'required|min:11',
        // 'gateway_method' => 'required',
        'country' => 'required',
        'username' => 'required|min:2',
        'images' => 'required|image|mimes:jpeg,png,jpg|max:20048',
    ], [
        'amount.required' => 'Please provide the deposit amount.',
        'phone.required' => 'A valid phone number is required.',
        'email.required' => 'A valid email is required.',
        'images.required' => 'Please upload a screenshot of the payment.',
        'images.image' => 'The file must be a valid image (jpeg, png, jpg).',
        'images.mimes' => 'The image must be in jpeg, png, or jpg format.',
        'images.max' => 'The image size must not exceed 20MB.',
    ]);

    // Get the user's country code
    $countryCodes = $user->country_code ?? '';

    // Define conversion rates
    $conversionRates = [
        'Kenya' => 130, // KES
        '260' => 30,  // ZMW
        '233' => 15,  // ZMW
        '256' => 3675, // UGX
        '211' => 4450, // SSP
    ];
    $conversionRates = $conversionRates[$countryCodes] ?? 1;

    // Handle the image upload
    $screenshot = $request->file('images');
    
    // Read the image content to generate a unique hash (for duplicate checking)
    $imageContent = file_get_contents($screenshot->getRealPath());
    $imageHash = hash('sha256', $imageContent);

    // Check if this image has already been used by another user (across all users)
    $existingHash = Deposit::where('image_hash', $imageHash)->first();
   if ($existingHash) {
    \Log::info('Duplicate screenshot detected. User ID: ' . $user->id);  // Logs to storage/logs/laravel.log
    return redirect()->back()->with('error', 'This screenshot has already been used by another user. Duplicate uploads are not allowed.');
}


    // Save the screenshot with a unique filename
    $screenshotFileName = uniqid() . '.' . $screenshot->getClientOriginalExtension();
    $screenshot->move(public_path('deposit_screenshots'), $screenshotFileName);

    // Create a new deposit record
    Deposit::create([
        'user_id' => $user->id,
        'method' => 'USDT',
        'username' => $user->username, // User's username from Auth
        'phone' => $user->phone,
        'country' => $user->country,
        'email' => $user->email,
        'transaction' => 'TRX' . time(),
        'images' => $screenshotFileName,
        'image_hash' => $imageHash, // Save the hash for duplicate checking
        'amount' => $request->amount / $conversionRates,
        'status' => 'Unpaid',
        'created_at' => now(),
        'updated_at' => now(),
    ]);

    // Return success message
    return redirect()->back()->with('success', 'Deposit submitted successfully. Please wait for confirmation.');
}


    public function store(Request $request)
    {
     //dd($request);
        $url = 'https://payherokenya.com/sps/portal/app/external_express';
        $apikey = 'cR0YqYfqkRgsX6RuvBCU9JLeiDvkVH7P3GLo1mLuLOlgktSKRE';
        $keyusername = '0712801188';
        $channel = '562';
        $amount = $request->input('amount');
        $mpesa = $request->input('phone');
        $base = env('APP_URL');
        $data = [
            "api_key" => $apikey,
            "username" => $keyusername,
            "amount" => $amount,
            "phone" => $mpesa,
            "user_reference" => Auth::user()->id,
            "channel_id" => $channel,
            "callback_url" => "$base/api/payhero"
        ];
        $response = $this->sendPostRequest($url, $data);
        // Decode the JSON response
        $responseData = json_decode($response, true);

        // Check the status
        if ($responseData['status']) {
            Log::alert($responseData);
            // Transaction was successful
            // dd($responseData);
            // return response()->json(['success' => true, 'message' => 'Payment successful']);
            return back()->with('success', 'payment successful');
        } else {
            // Transaction failed
            $statusMessage = $responseData['response']['Message'];
            //return response()->json(['success' => false, 'message' => $statusMessage]);
            return back()->with('error', $statusMessage);
        }
        // return response()->json($response); // Assuming you want to return the response as JSON
        return back()->with('error', "Try Again Later");
    }

    private function sendPostRequest($url, $data)
    {
        $curl = curl_init();

        curl_setopt_array($curl, array(
            CURLOPT_URL => $url,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => '',
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 0,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => 'POST',
            CURLOPT_POSTFIELDS => json_encode($data), // Encode data as JSON
            CURLOPT_HTTPHEADER => array(
                'Content-Type: application/json', // Set content type to JSON
            ),
        ));

        $response = curl_exec($curl);

        curl_close($curl);

        return $response;
    }
    public function handleCallback(Request $request)
{
    
    //dd($request);
    // Only proceed if MpesaReceiptNumber exists
    if (!empty($request['MpesaReceiptNumber'])) {
        $deposit_amount = $request['Amount']; // Amount in local currency
        $user_reference = $request['user_reference'];
        $code = $request['MpesaReceiptNumber'];

        // Fetch user
        $user = DB::table('users')->where('id', $user_reference)->first();

     

   

            // Fetch current balances
            $current_balance = $user->balance ?? 0;
            $current_wallet = $user->wallet ?? 0;

            // Final balances
            $total_balance = $current_balance + $deposit_amount;
            $total_wallet = $current_wallet + $deposit_amount;

            // Check if transaction already exists
            $current_trx = DB::table('deposits')->where('transaction', $code)->exists();

            if (!$current_trx) {
                // Update both balance and wallet (separately!)
                DB::table('users')->where('id', $user->id)->update([
                    'balance' => $total_balance,
                    'wallet' => $total_wallet,
                ]);

                // Record the deposit
                DB::table('deposits')->insert([
                    'method' => 'Mpesa',
                    'transaction' => $code,
                     'country' => Auth::user()->country,
                    'username' => $user->id,
                    'amount' => $deposit_amount,
                    'status' => 'healthy',
                ]);
            
        }
    }
}



public function approveDeposit(Request $request)
{
    $request->validate(['deposit_id' => 'required|integer']);

    $deposit = DB::table('deposits')->find($request->deposit_id);

    if ($deposit && $deposit->status === 'Unpaid') {
        $authPhone = Auth::user()->phone;

        // Check if authenticated user's phone matches deposit email or phone
        // if ($authPhone !== $deposit->phone && $authPhone !== $deposit->phone) {
        //     return response()->json(['success' => false, 'message' => 'Unauthorized action.']);
        // }

        // Fetch user using email or phone
        $user = DB::table('users')
            ->where('phone', $deposit->email)
            ->orWhere('phone', $deposit->phone)
            ->first();

        if ($user) {
            $countryCode = $user->country_code ?? '';

            // Define conversion rates
            $conversionRates = [
                'kenya' => 130, // KES
                '260' => 30,  // ZMW
                '233' => 15,  // GHS
                '256' => 3675, // UGX
            ];
            $conversionRate = $conversionRates[$countryCode] ?? 1;

            $amountInUSD = $deposit->amount;

            // Update balance and wallet
            DB::table('users')->where('id', $user->id)->increment('balance', $amountInUSD);
            DB::table('users')->where('id', $user->id)->increment('wallet', $amountInUSD);

            // Approve the deposit
            DB::table('deposits')->where('id', $deposit->id)->update(['status' => 'approved']);

            return response()->json(['success' => true, 'message' => 'Deposit approved successfully!']);
        }

        return response()->json(['success' => false, 'message' => 'User not found.']);
    }

    return response()->json(['success' => false, 'message' => 'Invalid deposit or already processed.']);
}

        
public function deleteDeposit(Request $request)
{
    $request->validate(['deposit_id' => 'required|integer']);

    $deposit = DB::table('deposits')->find($request->deposit_id);

    if ($deposit && $deposit->status === 'Unpaid') {
        DB::table('deposits')->where('id', $deposit->id)->delete();

        return response()->json(['success' => true, 'message' => 'Deposit deleted successfully!']);
    }

    return response()->json(['success' => false, 'message' => 'Invalid deposit or already processed.']);
}




    // Reject Deposit
    public function rejectDeposit(Request $request)
    {
        $request->validate(['deposit_id' => 'required|integer']);

        $deposit = DB::table('deposits')->find($request->deposit_id);

        if ($deposit && $deposit->status === 'pending') {
            DB::table('deposits')->where('id', $deposit->id)->update(['status' => 'rejected']);

            return response()->json(['success' => true, 'message' => 'Deposit rejected successfully!']);
        }

        return response()->json(['success' => false, 'message' => 'Invalid deposit or already processed.']);
    }
}