<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Carbon\Carbon;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Auth;
use WisdomDiala\Cryptocap\Facades\Cryptocap;
use Illuminate\Support\Facades\Cache;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Log;
use App\Services\WhatsAppService;
use App\Services\UjumbeSMSService;
use App\Models\User;
class HomeController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    protected $whatsappService;
    protected $smsService;
    
    public function __construct(WhatsAppService $whatsappService, UjumbeSMSService $smsService)
    {
        $this->whatsappService = $whatsappService;
        $this->smsService = $smsService;
        
        $this->middleware('auth');
    }

    /**
     * Show the application dashboard.
     *
     * @return \Illuminate\Contracts\Support\Renderable
     */
     
     public function approveCashouts(Request $req){
         $amount = $req->amount;
         $id = $req->id;
         
       //  dd($id);
        // $phone = $req->phone;
         //update csts status
         $update = DB::table('cashouts')->where('id', $id)->update([
             'status' => "Approved"
             
             ]);
             
             //send mail
             
             //return back the user
             return back()->with('success', 'Approved successfully');
     }
     
    public function index()
    {
        
    DB::table('users')->where('id', Auth::user()->id)->update(['daily_tasks' => '0']);

    // Refresh the authenticated user's instance
    Auth::user()->refresh();
    
    // Check the updated value
   // dd(Auth::user()->daily_tasks);
   
    $this->wealthCreation();

    //import my trades which haven't matured
        $trades = DB::table('invest')->where('status', 1)->where('type', 0)->where('user_id', Auth::user()->id)->get();
        
        
        //we use foreach to get them all
        foreach ($trades as $trade) {
             //dd($trade);
                   //get profit foreach user
                   $profit=$trade->returns;
                   //get trading period
                   $period = $trade->period;
                   //get days paid so far
                   $paid = $trade->days_paid;
                    // $to = Carbon::parse($trade->end_date);
                   $from_yangu = Carbon::parse($trade->end_date);
                   //$to = \Carbon\Carbon::createFromFormat('Y-m-d H:s:i', '2015-5-5 3:30:34');
                   $to = Carbon::now()->addHours(3);
                   //dd($to);
                   //assumed date of start of investing
                   $from_fake = Carbon::createFromFormat('Y-m-d H:s:i', '2022-2-16 9:30:34');
                   //real end date
                   $from = Carbon::parse($trade->date);

                   $diff_in_days = $to->diffInDays($from);
                   $diff_in_hrs = $to->diffInHours($from);
                   //compare days paid with difference
                   $days_not_paid = $diff_in_days - $paid;
                 //  dd("$diff_in_hrs");

               if($days_not_paid > 0 ){
                   
                  // dd($trade);
                           //get id of users to be paid
                           $id =  $trade->user_id;
                         
                           //get capital
                           $capital = $trade->capital;
                           //get id of that running investment
                           $invest_id = $trade->id;
                           //select those users
                           $users = DB::table('users')->where('id', $id)->get();
                           //loop through each unpaid person
                           foreach ($users as $user){
                               //dd(Auth::user()->daily_tasks);
                                      //calculate net profits
                                      $net_profit = $profit * $days_not_paid;
                                      //initialize their balance
                                       $balance = $user ->balance;
                                       //add profits to balance
                                       $new_balance = $balance + $net_profit;
                                       
                                      

                                   //pay them
                                   $affected = DB::table('users')
                                   ->where('id', $id)
                                   //update to new balance
                                   ->update(['daily_tasks' => Auth::user()->daily_tasks + $trade->daily_tasks, ]);
                                
                           }

                        
               }
               
            


       }
       
        return view ('user.dashboard');
            


    }
    
   
    
    public function wealthCreation(){
      
           //import my trades which haven't matured
        $trades = DB::table('wealthcreation')->where('status', 1)->where('user_id', Auth::user()->id)->get();
        
        
        //we use foreach to get them all
        foreach ($trades as $trade) {
            // dd($trade);
                   //get profit foreach user
                   $profit=$trade->returns;
                   //get trading period
                   $period = $trade->period;
                   //get days paid so far
                   $paid = $trade->days_paid;
                    // $to = Carbon::parse($trade->end_date);
                   $from_yangu = Carbon::parse($trade->end_date);
                   //$to = \Carbon\Carbon::createFromFormat('Y-m-d H:s:i', '2015-5-5 3:30:34');
                   $to = Carbon::now()->addHours(0);
                   //dd($to);
                   //assumed date of start of investing
                   $from_fake = Carbon::createFromFormat('Y-m-d H:s:i', '2022-2-16 9:30:34');
                   //real end date
                   $from = Carbon::parse($trade->date)->addHours(3);

                   $diff_in_days = $to->diffInDays($from);
                   //dd($diff_in_days);
                   $diff_in_hrs = $to->diffInHours($from);
                   //compare days paid with difference
                   $days_not_paid = $diff_in_days - $paid;
                

               if($days_not_paid > 0 ){
                   
                  //dd($trade);
                           //get id of users to be paid
                           $id =  $trade->user_id;
                           //get capital
                           $capital = $trade->capital;
                           //get id of that running investment
                           $invest_id = $trade->id;
                           //select those users
                           $users = DB::table('users')->where('id', $id)->get();
                           //loop through each unpaid person
                           foreach ($users as $user){
                                      //calculate net profits
                                      $net_profit = $profit * $days_not_paid;
                                      //initialize their balance
                                       $balance = $user ->balance;
                                       //add profits to balance
                                       $new_balance = $balance + $net_profit;
                                       
                                      

                                   //pay them
                                   $affected = DB::table('users')
                                   ->where('id', $id)
                                   //update to new balance
                                   ->update(['balance' => $new_balance, 'daily_tasks' => 0 ]);
                                    //reward team builders
                                  $authUser = Auth::user();

                                    $uplineClient = DB::table('users')->where(function ($query) use ($authUser) {
                                        $query->where('username', $authUser->upline)
                                              ->orWhere('id', $authUser->upline);
                                    })->first();
                                  
                           }

                           //mark paid
                           $nextPay = Carbon::parse($from)->addDays($diff_in_days + 1);
                           $markPaid =DB::table('wealthcreation')
                           ->where('id', $invest_id)
                           //set everyone paid
                           ->update([
                               'next_payment' => $nextPay,
                               'days_paid' => $diff_in_days,
                               'status' => 1
                               ]);
               }
               
            


       }
    }
    
    public function payMe(Request $req)
    {
       $id = $req->query('id');
       
       if(!$id){
            return redirect()->back()->with('error', 'Error occurred try again later');  
       }
       
      // dd($id);
       //import my trades which haven't matured
            $trades = DB::table('invest')->where('status', 1)->where('type', 0)->where('user_id', Auth::user()->id)->get();
            
            
            $trade = DB::table('invest')->where('id', $id)->first();
            $package = DB::table('packages')->where('price', $trade->capital)->first();
            // dd($trade);
                   //get profit foreach user
                   $profit=$trade->returns;
                   //get trading period
                   $period = $trade->period;
                   //get days paid so far
                   $paid = $trade->days_paid;
                    // $to = Carbon::parse($trade->end_date);
                   $from_yangu = Carbon::parse($trade->end_date);
                   //$to = \Carbon\Carbon::createFromFormat('Y-m-d H:s:i', '2015-5-5 3:30:34');
                   $to = Carbon::now()->subHours(0);
                   //dd($to);
                   //assumed date of start of investing
                   $from_fake = Carbon::createFromFormat('Y-m-d H:s:i', '2022-2-16 9:30:34');
                   //real end date
                   $from = Carbon::parse($trade->date);

                   $diff_in_days = $to->diffInDays($from);
                   $diff_in_hrs = $to->diffInHours($from);
                   //compare days paid with difference
                   $days_not_paid = $diff_in_days - $paid;
                  //dd("$days_not_paid");

               if($days_not_paid > 0 ){
                   
                  //dd($trade);
                           //get id of users to be paid
                           $id =  $trade->user_id;
                           //get capital
                           $capital = $trade->capital;
                           //get id of that running investment
                           $invest_id = $trade->id;
                           //select those users
                           $user = DB::table('users')->where('id', $id)->first();
                           
                          //calculate net profits
                          $net_profit = $profit * $days_not_paid;
                          
                          //initialize their balance
                           $balance = $user ->balance;
                           //add profits to balance
                           $new_balance = $balance + $net_profit;
                           //pay them
                           $affected = DB::table('users')
                           ->where('id', $id)
                           //update to new balance
                           ->update(['balance' => $new_balance, 'daily_tasks' => 0 ]);
                            //reward team builders
                           $uplineClient = DB::table('users')->where(function ($query) {
                        $query->where('username', Auth::user()->upline)
                              ->orWhere('id', Auth::user()->upline);
                    })->first();
                                  
                           
                           //mark paid
                           $nextPay = Carbon::parse($from)->addDays($diff_in_days + 1);
                           $markPaid =DB::table('invest')
                           ->where('id', $invest_id)
                           //set everyone paid
                           ->update([
                               'next_payment' => $nextPay,
                               'days_paid' => $diff_in_days,
                               'status' => 1
                               ]);
                               
                          if(($paid + 1) >= $package->days){
                              DB::table('invest')
                                   ->where('id', $invest_id)
                                   //set everyone paid
                                   ->update([
                                       'status' => 2
                                       ]);
                          }
               }
               
            


      
       
       // dd('hey');
       
         return redirect()->back()->with('success', "Task Done and collected $net_profit"); 
    }



    public function dashboard (){
  //import my trades which haven't matured
        $trades = DB::table('invest')->where('status', 1)->where('type', 0)->where('user_id', Auth::user()->id)->get();
        //we use foreach to get them all
        foreach ($trades as $trade) {
                   //get profit foreach user
                   $profit=$trade->returns;
                   //get trading period
                   $period = $trade->period;
                   //get days paid so far
                   $paid = $trade->days_paid;
                    // $to = Carbon::parse($trade->end_date);
                   $from_yangu = Carbon::parse($trade->end_date);
                   //$to = \Carbon\Carbon::createFromFormat('Y-m-d H:s:i', '2015-5-5 3:30:34');
                   $to = Carbon::now()->addHour(3);
                   //assumed date of start of investing
                   $from_fake = Carbon::createFromFormat('Y-m-d H:s:i', '2022-2-16 9:30:34');
                   //real end date
                   $from = $trade->date;

                   $diff_in_days = $to->diffInDays($from);
                   //compare days paid with difference
                   $days_not_paid = $diff_in_days - $paid;
 //dd($diff_in_days);
               if($diff_in_days >= 3){
                           //get id of users to be paid
                           $id =  $trade->user_id;
                           //get capital
                           $capital = $trade->capital;
                           //get id of that running investment
                           $invest_id = $trade->id;
                           //select those users
                           $users = DB::table('users')->where('id', $id)->get();
                           //loop through each unpaid person
                           foreach ($users as $user){
                                      //calculate net profits
                                      $net_profit = $profit;
                                      //initialize their balance
                                       $balance = $user ->balance;
                                       //add profits to balance
                                       $new_balance = $balance + $net_profit;

                                   //pay them
                                   $affected = DB::table('users')
                                   ->where('id', $id)
                                   //update to new balance
                                   ->update(['balance' => $new_balance]);
                           }

                           //mark paid
                           $markPaid =DB::table('invest')
                           ->where('id', $invest_id)
                           //set everyone paid
                           ->update([
                               'days_paid' => $diff_in_days,
                               'status' => 2
                               ]);
               }


       }
    //    *****************************************************************//
        

        return view ('user.dashboard');
    }
    
    
        
    
    public function videoTask (){
        $user = Auth::user();
        $invests = DB::table('invest')->where('user_id', $user->id)->get();
        return view ('video.video-task', compact('invests'));
    }
public function videoTaskStore(Request $request)
{
    $user = Auth::user();  

    // 1. Get user investment 
    $invest = DB::table('invest')->where('id', $request->invest_id)->first();
    if (!$invest) {
        return back()->with('error', 'Investment not found.');
    }

    // 2. Get package details
    $package = DB::table('packages')->where('id', $invest->package_id)->first();
    $dailyIncome = $package ? $package->daily_income : 0;

    // 3. Check if 60-day task duration is over
    $startDate = Carbon::parse($invest->date);
    $now = Carbon::now();
    $daysSince = $now->diffInDays($startDate);

    if ($daysSince >= 30) {
        return back()->with('error', 'This investment has expired after 30 days.');
    }

    // 4. Check if the task is already paid for today (24hr wait)
    if ($now->lt(Carbon::parse($invest->next_payment))) {
        return back()->with('error', 'You have already completed today’s task. Try again later.');
    }

    // 5. Update user balance
    $newBalance = $user->balance + $dailyIncome;
    DB::table('users')->where('id', $user->id)->update([
        'balance' => $newBalance
    ]);

    // 6. Update investment: next_payment, days_paid, updated_at
    $nextPayment = Carbon::now()->addDay();
    DB::table('invest')->where('id', $invest->id)->update([
        'next_payment' => $nextPayment,
        'days_paid' => $invest->days_paid + 1,
        'updated_at' => now()
    ]);

    return back()->with('success', 'Daily video task completed and rewarded!');
}

    
    public function learning (){
        $user = Auth::user();
        $invests = DB::table('invest')->where('user_id', $user->id)->get();
        return view ('learning.learning', compact('invests'));
    }
public function learningStore(Request $request)
{
    $user = Auth::user();  

    // 1. Get user investment 
    $invest = DB::table('invest')->where('id', $request->invest_id)->first();
    if (!$invest) {
        return back()->with('error', 'Investment not found.');
    }

    // 2. Get package details
    $package = DB::table('packages')->where('id', $invest->package_id)->first();
    $dailyIncome = $package ? $package->daily_income : 0;

    // 3. Check if 60-day task duration is over
    $startDate = Carbon::parse($invest->date);
    $now = Carbon::now();
    $daysSince = $now->diffInDays($startDate);

    if ($daysSince >= 60) {
        return back()->with('error', 'This investment has expired after 60 days.');
    }

    // 4. Check if the task is already paid for today (24hr wait)
    if ($now->lt(Carbon::parse($invest->next_payment))) {
        return back()->with('error', 'You have already completed today’s task. Try again later.');
    }

    // 5. Update user balance
    $newBalance = $user->balance + $dailyIncome;
    DB::table('users')->where('id', $user->id)->update([
        'balance' => $newBalance
    ]);

    // 6. Update investment: next_payment, days_paid, updated_at
    $nextPayment = Carbon::now()->addDay();
    DB::table('invest')->where('id', $invest->id)->update([
        'next_payment' => $nextPayment,
        'days_paid' => $invest->days_paid + 1,
        'updated_at' => now()
    ]);

    return back()->with('success', 'Daily learning task completed and rewarded!');
}

    public function downlines (){
        return view ('user.downlines');
    }
    
    public function depoHistory (){
        return view ('deposit.depoHistory');
    }
       public function cashHistory (){
        return view ('cashouts.cashHistory');
    }
        public function mine (){
        return view ('user.mine');
    }
    
        public function support (){
        return view ('support.support');
    }
          public function about (){
        return view ('user.about');
    }
            public function orders (){
        return view ('user.orders');
    }
            public function accounts (){
        return view ('user.accounts');
    }
            public function luckyCode (){
        return view ('user.lucky-code');
    }
public function team (){
        return view ('team.team');
    }
     public function checkin (){
        return view ('checkin.promocode');
    }
             // for admins
         public function admin_view (){
        return view ('user.admin');
    }
       public function updatePackage_view (){
        return view ('user.updatepackages');
    }
         public function active_view (){
        return view ('user.active');
    }
    public function service (){
        return view ('service.service');
    }

         public function inactive_view (){
        return view ('user.inactive');
    }
         public function pendingwithdrawals_view (){
        return view ('user.pendingwithdrawals');
    }    
    public function allwithdrawals_view (){
        return view ('user.allwithdrawals');
    }
    
         public function alldeposits_view (){
        return view ('user.alldeposits');
    }
     public function allpendingdeposits_view (){
        return view ('user.allPendingDeposits');
    }
    
         public function adminsrules_view (){
        return view ('user.adminsrules');
    }
    
    // end of admins
    // for admins
    
   public function quickPackage(Request $req)
{
    $p = request()->query('p');

    $user = Auth::user();
    $balance = $user->balance;
    $userId = $user->id;

    if ($p == 'audio') {
        $video_url = DB::table('settings')->first()->video;
        $price = 0;
        $returns = 20;
        $amount = $price;

        $day = Carbon::now();
        $endDate = $day->copy()->addDays(30);
        $dayPay = Carbon::now()->addDays(1);

        $new_cash = $balance - $amount;
        $new_invs = $user->investments + $amount;

        if ($new_cash < 0) {
            return back()->with('error', 'Insufficient account balance!');
        }

        $invest = DB::table('invest')->insert([
            'user_id' => $userId,
            'status' => 1,
            'period' => 365,
            'returns' => $returns,
            'type' => 1,
            'package_id' => 0, // audio has no package_id
            'capital' => $amount,
            'days_paid' => 0,
            'next_payment' => $dayPay,
            'upline_bonus' => $amount * 0.10,
            'date' => $day,
            'end_date' => $endDate,
            'created_at' => $day,
            'updated_at' => $day
        ]);

        // Update user balance
        DB::table('users')->where('id', $userId)->update([
            'balance' => $new_cash,
            'investments' => $new_invs,
            'status' => 1
        ]);

        return back()->with('success', 'Processed successfully!');
    } else {
        $p_details = DB::table('packages')->where('id', $p)->first();
        if (!$p_details) {
            return back()->with('error', 'Invalid package selected.');
        }

        $price = $p_details->price;
        $returns = $p_details->daily_income;
        $amount = $price;

        $day = Carbon::now();
        $endDate = $day->copy()->addDays(30);
        $dayPay = Carbon::now()->addDays(1);

        $new_cash = $balance - $amount;
        $new_invs = $user->investments + $amount;

        if ($new_cash < 0) {
            return back()->with('error', 'Insufficient account balance!');
        }

        $invest = DB::table('invest')->insert([
            'user_id' => $userId,
            'status' => 1,
            'period' => 30,
            'returns' => $returns,
            'package_id' => $p_details->id,
            'type' => 0,
            'capital' => $amount,
            'days_paid' => 0,
            'next_payment' => $dayPay,
            'upline_bonus' => $amount * 0.10,
            'date' => $day,
            'end_date' => $endDate,
            'created_at' => $day,
            'updated_at' => $day
        ]);

        // Update user account
        DB::table('users')->where('id', $userId)->update([
            'balance' => $new_cash,
            'investments' => $new_invs,
            'status' => 1
        ]);

// Upline bonuses (3-level)
$levels = [1 => 0.15, 2 => 0.02, 3 => 0.01];
$currentUpline = $user->upline;
$level = 1;

// Debugging: Log initial state
\Log::info("Starting bonus distribution", [
    'user_id' => $user->id,
    'amount' => $amount,
    'initial_upline' => $currentUpline
]);

while ($currentUpline && $level <= 3) {
    $uplineUser = DB::table('users')
        ->where(function($query) use ($currentUpline) {
            $query->where('ref_code', $currentUpline)
                  ->orWhere('id', $currentUpline);
        })
        ->first();

    if (!$uplineUser) {
        \Log::warning("Upline not found", ['level' => $level, 'currentUpline' => $currentUpline]);
        break;
    }

    $bonus = $amount * $levels[$level];
    
    // Debugging: Log before payment
    \Log::info("Processing bonus", [
        'level' => $level,
        'upline_id' => $uplineUser->id,
        'bonus_amount' => $bonus
    ]);

    // 1. Pay the bonus to the upline user
    DB::table('users')->where('id', $uplineUser->id)->increment('balance', $bonus);
    
    // 2. Track in current user's bonus columns
    $bonusColumn = 'bonus_' . $level;
    DB::table('users')
        ->where('id', Auth::user()->id)
        ->increment($bonusColumn, $bonus);

    // Log the bonus
    DB::table('bonus_logs')->insert([
        'user_id' => $uplineUser->id,
        'from_user' => $user->id,
        'level' => $level,
        'amount' => $bonus,
        'created_at' => now()
    ]);

    // Debugging: Log successful payment
    \Log::info("Bonus paid", [
        'level' => $level,
        'upline_id' => $uplineUser->id,
        'bonus_column' => $bonusColumn,
        'paid_amount' => $bonus
    ]);

    $currentUpline = $uplineUser->upline;
    $level++;
}

// Final debug log
\Log::info("Bonus distribution completed", [
    'final_level_reached' => $level-1,
    'final_upline' => $currentUpline
]);

        return back()->with('success', 'Processed successfully!');
    }
}

    
    public function submitSurvey() {
        DB::table('users')
          ->where('id', Auth::user()->id)
          ->update([
              'survey' => "30",
              'balance' => Auth::user()->balance + 30,
          ]);
          
          return back()->with('success', "you have earned today wait next week");
    }
    
     public function showRandomTopic()
    {
        // Fetch a random topic from the topics table (assuming you have a topics table)
        $topic = DB::table('topics')->inRandomOrder()->value('topic_name');
        
        // Show the article writing page with the random topic
        return view('article', ['topic' => $topic]);
    }

    public function submitArticle(Request $request)
    {
        DB::table('users')
          ->where('id', Auth::user()->id)
          ->update([
              'writing' => "30",
              'balance' => Auth::user()->balance + 30,
          ]);
          
          return back()->with('success', "you have earned from writing today wait next week");
    }
    
   public function changePassword(Request $request)
    {
        $request->validate([
            'current_password' => 'required',
            'new_password' => 'required|min:3|confirmed',
        ]);
    
        $user = Auth::user();
    
        if (!Hash::check($request->current_password, $user->password)) {
            return back()->withErrors(['current_password' => 'The current password is incorrect.']);
        }
    
        $user->password = Hash::make($request->new_password);
        $user->save();
    
        return back()->with('success', 'Password successfully updated!');
    }
    
    public function notify()
    {
        return view('notify');
    }
    
    public function toDos()
    {
        return view('todo');
    }
    
    
    /**
     * Handle sending the verification code via WhatsApp or SMS.
     */
         
    public function updateUser(Request $request, $id)
{
    // Validate the request data
    $request->validate([
        'email' => 'required|string|max:255',
        'phone' => 'required|string|max:20',
        'balance' => 'required|numeric|min:0',
    ]);

    // Find the user and update the details
    $user = User::find($id);

    if (!$user) {
        return redirect()->back()->with('error', 'User not found.');
    }

    $user->email = $request->email;
    $user->phone = $request->phone;
    $user->balance = $request->balance;
    $user->save();

    return redirect()->back()->with('success', 'User updated successfully.');
}
    public function sendCode(Request $request)
    {
        $request->validate([
            'phone' => 'required|digits:10'
        ]);

        $phone = $request->phone;
        $code = rand(100000, 999999); // Generate a 6-digit verification code

        // Store code in cache for 10 minutes
        Cache::put("phone_verification_{$phone}", $code, now()->addMinutes(10));

        $message = "Your verification code is: {$code}";

        // Send via WhatsApp
        $whatsappResponse = $this->whatsappService->sendMessage($message, $phone);
        
        Log::alert($whatsappResponse);

        // If WhatsApp fails, fallback to SMS
        if (!$whatsappResponse || !$whatsappResponse->successful()) {
            $smsResponse = $this->smsService->sendSMS($phone, $message);
            if (!isset($smsResponse['status']) || $smsResponse['status'] !== 'success') {
                return response()->json(['success' => false, 'message' => 'Failed to send code via both WhatsApp and SMS.'], 500);
            }
        }

        return response()->json(['success' => true, 'message' => 'Verification code sent successfully.']);
    }

    /**
     * Handle changing the phone number after verifying the code.
     */
    public function changePhone(Request $request)
    {
        $request->validate([
            'new_phone' => 'required|digits:10|unique:users,phone',
            'current_password' => 'required',
        ]);

        $user = Auth::user();
        $newPhone = $request->new_phone;
        $enteredCode = $request->verification_code;

        // Verify current password
        if (!Hash::check($request->current_password, $user->password)) {
            return back()->withErrors(['current_password' => 'Incorrect password.']);
        }


        // Update the phone number
        $user->phone = $newPhone;
        $user->save();

        // Remove the verification code from cache
        Cache::forget("phone_verification_{$newPhone}");

        return back()->with('success', 'Phone number changed successfully.');
    }
    
    public function changeUpline(Request $request)
{
    // Find the user entered in the form
    $user = DB::table('users')->where('username', $request->username)->first();

    if (!$user) {
        return back()->with(['error' => 'User not found.']);
    }

    // Check if the user already has an upline that is NOT "system"
    if ($user->upline !== 'system') {
        return back()->with('error', "This user already has an upline. Upline ID: {$user->upline}");
    }

    // Set the upline to the authenticated user
    $authUser = auth()->user();

    // Calculate the total investments of the downline
    $downlineInvestment = DB::table('invest')->where('user_id', $user->id)->sum('capital');

    // Calculate the 6% bonus
    $bonus = $downlineInvestment * 0.06;

    // Update the user's upline
    DB::table('users')->where('id', $user->id)->update(['upline' => $authUser->username]);

    // Add the bonus to the upline's balance
    DB::table('users')->where('id', $authUser->id)->increment('balance', $bonus);

    return back()->with('success', "User '{$user->username}' is now your downline. You earned KES {$bonus}.");
}



}
