<?php
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use App\Http\Controllers\Controller; // Ensure you extend the correct base class

class PromoController extends Controller
{
    public function applyPromoCode(Request $request)
    {
        $user = Auth::user();
        $promoCode = trim($request->input('promo_code'));

        // Check if promo code exists
        $promo = DB::table('promo_codes')->where('code', $promoCode)->first();

        if (!$promo) {
            return back()->with('error', 'Invalid promo code.');
        }

        // Get reward amount and add to user balance
        $rewardAmount = $promo->reward_amount;

        // Update user balance
        DB::table('users')
            ->where('id', $user->id)
            ->increment('balance', $rewardAmount);

        return back()->with('success', 'Promo code applied successfully! Your balance has been updated.');
    }
}
