<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Http;
use App\Models\User;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Validator;

class UserController extends Controller
{
    public function sendResetCode(Request $request)
    {
        $request->validate([
            'identifier' => 'required',
        ]);

        // Find user by username or phone
        $user = User::where('username', $request->identifier)
                    ->orWhere('phone', $request->identifier)
                    ->first();

        if (!$user) {
            return back()->withErrors(['identifier' => 'User not found.']);
        }

        // Generate a random 6-digit code
        $resetCode = rand(100000, 999999);

        // Save the code in the session (or store in DB if needed)
        session(['reset_code' => $resetCode, 'user_id' => $user->id]);

        // Send WhatsApp message
        $this->sendWhatsAppMessage($user->phone, "Your *SAHU ACCOUNT* password reset code is: *$resetCode*");

       return redirect("reset?id=$user->id")->with('success', "Reset Code  sent to your whatsapp and sms");
    }

    private function sendWhatsAppMessage($phoneNumber, $message)
    {
        $apiUrl = "https://backend.payhero.co.ke/api/v2/whatspp/sendText";
        $session = "ninjadev"; // Replace with your actual session name
   
        $username = "XjoVGaVDJ3I1x6X2DFAi";
        $password = "3X4ZP0MHdrd6OciPfr0ECZm6865zBe8dIF1o5ZbJ";
        
        // Encode credentials in Base64
        $token = base64_encode("$username:$password");

        $response = Http::withHeaders([
            'Content-Type'  => 'application/json',
            'Authorization' => "Basic $token",
        ])->post($apiUrl, [
            "message"      => $message,
            "phone_number" => $phoneNumber,
            "session"      => $session,
        ]);

        return $response->json();
    }

   public function verifyResetCode(Request $request)
    {
    
        // Debugging to check session values
        if (!session()->has('reset_code')) {
            return back()->withErrors(['reset_code' => 'Session expired. Please request a new code.']);
        }
    
        // Loose comparison to avoid type mismatch issues
        if ((int) $request->reset_code === (int) session('reset_code')) {
            return redirect()->route('updatePasswordForm', ['id' => $request->id]);
        }
    
        return back()->withErrors(['reset_code' => 'Invalid code.']);
    }


    public function showResetForm()
    {
        return view('auth.passwords.reset');
    }
    
    public function updatePassword(Request $request)
    {
     
       

        // Find user
        $user = User::where('id', $request->id)
                    ->orWhere('username', Session::get('identifier'))
                    ->first();
    
        if (!$user) {
            return back()->withErrors(['error' => 'User not found!']);
        }

        // Update password
        $user->password = Hash::make($request->password);
        $user->save();

        // Clear session data
        Session::forget(['reset_code', 'identifier', 'verified']);

        return redirect()->route('login')->with('success', 'Password updated successfully! Please login.');
    
    }
    
    public function updatePassForm(){
        return view('auth.passwords.update');
    }
    
}

