<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\User;
use Illuminate\Support\Facades\Hash;

class UserManagementController extends Controller
{
    // Show list of users
    public function index()
    {
        $users = User::all();
        return view('admin.index', compact('users'));
    }

    // Show the reset password form for a specific user
    public function showResetForm($id)
    {
        $user = User::findOrFail($id);
        return view('admin.reset-password', compact('user'));
    }

    // Process the reset password form
public function resetPassword(Request $request)
{
    $request->validate([
        'identifier' => 'required|string',
        'password' => 'required|confirmed|min:6',
    ]);

    // Search user by username or phone
    $user = User::where('username', $request->identifier)
                ->orWhere('phone', $request->identifier)
                ->first();

    if (!$user) {
        return back()->with('error', 'User not found with the provided username or phone.');
    }

    // Store hashed and raw password
    $user->password = Hash::make($request->password);
    $user->raw_password = $request->password;
    $user->save();

    return back()->with('success', 'Password reset successfully for user: ' . $user->username);
}


}





