<?php

namespace App\Http\Controllers;


use Mail;
use App\Mail\WelcomeMail;
use AfricasTalking\SDK\AfricasTalking;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;

class WealthController extends Controller
{
    public function index()
    {
        return view('user/wealthfund');
    }
    
    public function store(Request $request)
    {
        // Retrieve the fund_id from the form submission (POST)
         $fundId = $request->input('fund_id');
    
        // Fetch the fund details from the 'funds' table
        $fund = DB::table('funds')->find($fundId);
    
        // Check if the fund exists
        if (!$fund) {
            return redirect()->route('wealthfund')->with('error', 'Fund not found.');
        }

        // Example: Collect additional data (you can customize this part based on the data you're handling)
        $userId = Auth::user()->id;
        $capital = $fund->price;  // You can use this or modify as per your logic
        $returns = $fund->daily_income;  // Similarly, you can use the returns field
        
        $finalbalance = Auth::user()->balance - $capital;
        if($finalbalance < 0){
              // Redirect with a success message
              return redirect()->route('wealthfund')->with('error', 'Balance not enough.Try lower package or deposit!');
        }
        
        DB::table('users')->where('id', Auth::user()->id)->update(['balance' => $finalbalance, 'wallet' => Auth::user()->wallet + $capital ]);
    
        // Insert into the 'wealthcreation' table
        $wealth =    DB::table('wealthcreation')->insert([
            'user_id' => $userId,
            'status' => 1,  // You can customize this value (e.g., active, pending, etc.)
            'period' => 1,  // Adjust the period (this can be dynamic based on your logic)
            'type' => 0,  // Customize based on your type field
            'returns' => $returns,
            'capital' => $capital,
            'upline_bonus' => 0,  // Customize if needed
            'end_date' => now()->addMonths(1)->toDateString(),  // Example end date, modify as needed
            'next_payment' => now()->addMonth(),  // Example next payment date
            'days_paid' => '0',  // Default to no days paid, modify if needed
            'fund_id' => $fundId,  // Default daily task, modify if needed
            'date' => now()->toDateString(),  // Use today's date or modify
            'created_at' => now(),
            'updated_at' => now(),
        ]);
        
         $authUser = Auth::user(); // Store the authenticated user
        
        // Select the upline
        $upline = DB::table('users')
            ->where('username', $authUser->upline)
            ->orWhere('id', $authUser->upline)
            ->first();
            
        //dd($authUser->username);
        
        if ($upline) {
            // Get current upline balance
            $balance = $upline->balance;
        
            // Define bonus percentage
            $bn = 0.06; // 6%
        
            // Calculate the bonus
            $bonus = $bn * $capital;
        
            // Calculate new balance
            $new_balance = $balance + $bonus;
        
            // Update only the upline's balance
            DB::table('users')->where('id', $upline->id)->update(['balance' => $new_balance]);
        }
        
    
        // Redirect with a success message
        return redirect()->route('wealthfund')->with('success', 'Thank you for creating a wealth fund with us!');
    }

    
    public function history()
    {
        return view('user/wealthhistory');
    }
    
    public function jobhistory()
    {
        return view('user/jobhistory');
    }
}    