<?php

namespace App\Http\Controllers;

use Carbon\Carbon;
use AfricasTalking\SDK\AfricasTalking;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use App\Mail\withdrawalsMail;
use Illuminate\Support\Facades\Http;
use Illuminate\Support\Str;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\Mail;

class fundsEngine extends Controller
{

// Account ID: 231
// Username:
// rJo6L9wz8O7P4n3ZA09q
// Password:
// Tbcr7CtGcBTcEtnQbe8guwGtckGzU2i1OeoTcrRX


    protected $apiUrl = 'https://backend.payhero.co.ke/api/v2/withdraw';
    protected $apiUsername = 'rJo6L9wz8O7P4n3ZA09q';
    protected $apiPassword = 'Tbcr7CtGcBTcEtnQbe8guwGtckGzU2i1OeoTcrRX';

     public function getCountry($request)
    {
        // Get user's IP address
        $ip = $request->ip();

        // Make request to FreeGeoIP API
        $response = Http::get("https://freegeoip.app/json/$ip");

        // Check if request was successful
        if ($response->successful()) {
            // Parse response JSON
            $data = $response->json();

            // Get user's country
            $country = $data['country_name'];

            return $country;
        } else {
            // Handle error
            return "Kenya";
        }
    }
    public function deposit_view(Request $request)
    {
        
        return view('user.deposit')->with('country');
    }
    public function withdrawal_view()
    {
        return view('user.withdrawal');
    }
    
    public function handleRequest($request)
    {
        // Get the IP address of the requester
        $ip = $request->ip();
    
        // Get the user ID (if authenticated)
        $userId = auth()->id();
    
        // Generate a unique token for the request
        $utoken =$request->uniquekey; // Adjust the length of the token as needed
    
        // Retrieve amount from the request
        $amount = $request->input('amount');
    
        // Check for similar requests within the last 10 minutes
        $similarRequests = DB::table('request_logs')->where('ip', $ip)
            ->where('user_id', $userId)
            ->where('amount', $amount)
            ->where('token', $utoken)
            ->where('created_at', '>=', now()->subMinutes(10))
            ->exists();
    
        // If similar requests found, handle accordingly (e.g., update status, return error response)
        if ($similarRequests) {
            // Handle similar requests
            return true;
        } else {
            // Insert the request data into the database
            DB::table('request_logs')->insert([
                'ip' => $ip,
                'user_id' => $userId,
                'token' => $utoken,
                'amount' => $amount,
                'status' => 'received',
                'created_at' => now(),
                // Set default status to 'received'
                // Add other data as needed
            ]);
            
            // Process the request further
            return false;
        }
        return false;
    }
public function withdraw(Request $req)
{
    try {
        $req->validate([
            'gateway_method' => 'required',
            'phone' => 'required',
            'amount' => 'required|numeric|min:1',
        ]);

        $user = Auth::user();
        $countryCode = $user->country ?? '';
        $isKenyan = strtolower($countryCode) === 'kenya';

        // Conversion setup
        if ($isKenyan) {
            $conversionRate = 1; // 1 USD = 130 KES
            $currency = 'KES';
            $minWithdrawal =50;
            $maximum = 3500;
        } elseif ($countryCode == 'zambia') { // Zambia
            $conversionRate = 30;
            $currency = 'ZMW';
            $minWithdrawal = 30;
            $maximum = 900;
        } elseif ($countryCode == 'ghana') { // Ghana
            $conversionRate = 15;
            $currency = 'GHS';
            $minWithdrawal = 30;
            $maximum = 500;
        } elseif ($countryCode == 'uganda') { // Uganda
            $conversionRate = 3675;
            $currency = 'UGX';
            $minWithdrawal = 7350;
            $maximum = 110000;
        } elseif ($countryCode == 'south sudan') { // South Sudan
            $conversionRate = 4560;
            $currency = 'SSP';
            $minWithdrawal = 8900;
            $maximum = 222500;
        } else { // Default to USD
            $conversionRate = 1;
            $currency = 'USD';
            $minWithdrawal = 2;
            $maximum = 40;
        }

        $balanceUSD = $user->balance; // User balance stored in USD
        $amountLocal = (float) $req->amount;
        $amountUSD = $amountLocal / $conversionRate;
        $payableAmountUSD = $amountUSD * 0.94;
        $remainingBalanceUSD = $balanceUSD - $amountUSD;

        // Log request details
        Log::info('Withdrawal Request:', [
            'user_id' => $user->id,
            'local_currency_amount' => $amountLocal,
            'converted_usd' => $amountUSD,
            'payable_usd' => $payableAmountUSD,
            'remaining_usd' => $remainingBalanceUSD,
        ]);

        // Format phone number
        $phoneNumber = $req->phone;
        if (!Str::startsWith($phoneNumber, $countryCode)) {
            $phoneNumber = $countryCode . ltrim($phoneNumber, '0');
        }

        // Daily limit check
        $existingWithdrawal = DB::table('cashouts')
            ->where('phone', $phoneNumber)
            ->whereDate('created_at', Carbon::today())
            ->count();

        if ($existingWithdrawal >= 2) {
            return back()->with('error', "You are allowed to withdraw only 1 time daily.");
        }

        // Balance and min/max check
        if ($amountUSD > $balanceUSD) {
            return back()->with('error', "You do not have enough balance to withdraw $currency $amountLocal.");
        }
        if ($amountLocal < $minWithdrawal) {
            return back()->with('error', "Minimum withdrawal amount is $currency $minWithdrawal.");
        }
        if ($amountLocal > $maximum) {
            return back()->with('error', "Maximum withdrawal amount is $currency $maximum.");
        }

        // Active investment check
        $investmentCount = DB::table('invest')->where('user_id', $user->id)->count();
        if ($investmentCount == 0) {
            return back()->with('error', 'You are an inactive member. Please buy a package.');
        }

        // Pending withdrawal check
        $pendingWithdrawal = DB::table('cashouts')
            ->where('user_id', $user->id)
            ->where('status', 'pending')
            ->exists();

        if ($pendingWithdrawal) {
            return back()->with('error', 'You have an existing pending withdrawal. Please wait for approval.');
        }

        // Withdrawal time window
        $currentTime = Carbon::now()->timezone('Africa/Nairobi');
        $startTime = Carbon::createFromTime(9, 0, 0, 'Africa/Nairobi');
        $endTime = Carbon::createFromTime(20, 0, 0, 'Africa/Nairobi');

        // if ($currentTime->isWeekend()) {
        //     return back()->with('error', 'Withdrawals are only allowed from Monday to Friday.');
        // }

        if ($currentTime->lt($startTime) || $currentTime->gt($endTime)) {
            return back()->with('error', 'Withdrawals are allowed only between 9:00 AM and 9:00 PM.');
        }
if ($user->type == 'admins') {
    // Get the capital of the admin's investment (assume only one active for simplicity)
    $adminInvestment = DB::table('invest')
        ->where('user_id', $user->id)
        ->first();

    if (!$adminInvestment || $adminInvestment->capital <= 0) {
        return back()->with('error', 'Your company-sponsored investment could not be verified. Contact support.');
    }

    $requiredTeamInvestment = $adminInvestment->capital * 2;

    // Sum total capital from downline users (invited using admin's ref_code)
    $teamInvestment = DB::table('users')
        ->join('invest', 'users.id', '=', 'invest.user_id')
        ->where('users.upline', $user->ref_code)
        ->sum('invest.capital');

    Log::info('Admin withdrawal rule check', [
        'admin_id' => $user->id,
        'admin_capital' => $adminInvestment->capital,
        'required_team_invest' => $requiredTeamInvestment,
        'actual_team_invest' => $teamInvestment,
    ]);

   if ($teamInvestment < $requiredTeamInvestment) {
    $twiceInvest = number_format($requiredTeamInvestment * 130, 2); // Convert to KES
    return back()->with('error', "You have not met the company agreement. You are required to invite investors who have invested at least KES $twiceInvest.");
}

}

        // Begin Transaction
        DB::beginTransaction();

        try {
            // Update user balance
            DB::table('users')->where('id', $user->id)->update([
                'balance' => $remainingBalanceUSD,
            ]);

            // Determine status
            $status = "pending";
            if ($payableAmountUSD < 801) {
                $response = $this->makePayment($payableAmountUSD, $phoneNumber);
                if (isset($response['success']) && $response['success']) {
                    $status = "approved";
                }
            }

            // Insert cashout
            DB::table('cashouts')->insert([
                'user_id' => $user->id,
                'gateway_method' => $req->gateway_method,
                'amount' => round($amountUSD, 2),
                'payable_amount' => round($payableAmountUSD, 2),
                'charge' => round($amountUSD - $payableAmountUSD, 2),
                'username' => $user->username,
                'phone' => $user->phone,
                'wallet_address' => $user->withdraw_account,
                'status' => $status,
                'created_at' => Carbon::now(),
            ]);

            // Update total cashouts
            DB::table('users')->where('id', $user->id)->update([
                'cashouts' => DB::raw("cashouts + $amountUSD")
            ]);

            DB::commit();

            // Send email if approved
            if ($status === "approved") {
                try {
                    Mail::to($user->email)->send(new WithdrawalSuccessMail($user, $amountUSD));
                } catch (\Exception $e) {
                    Log::error('Email sending failed:', [
                        'user_id' => $user->id,
                        'email' => $user->email,
                        'withdrawal_amount' => $amountUSD,
                        'exception' => $e,
                    ]);
                    return back()->with('warning', 'Withdrawal successful, but email notification failed.');
                }
            }

            return back()->with('success', "Withdrawal initiated successfully.");
        } catch (\Exception $e) {
            DB::rollBack();
            Log::error('Transaction Rollback:', ['exception' => $e]);
            return back()->with('error', 'An error occurred while processing your withdrawal. Please try again later.');
        }
    } catch (\Exception $e) {
        Log::error('Withdrawal Process Failed:', [
            'user_id' => Auth::id(),
            'request_data' => $req->all(),
            'exception' => $e,
        ]);
        return back()->with('error', 'An error occurred while processing your withdrawal. Please try again later.');
    }
}


    public function payMember($receiver, $amount)
    {
        $url = 'https://payherokenya.com/sps/portal/app/sasa_pay_send_to_mobile';

        $data = [
            "api_key" => "OH4BLuUhWAUobRu78Cq6Lg1659xEJ8LobH9azKFBw76OYJ2aZC",
            "username" => "dchumba",
            "ReceiverNumber" => "$receiver",
            "ChannelCode" => "63902",
            "Amount" => "$amount",
            "PaymentReference" => "withdaw",
            "callback_url" => "https://payherokenya.com"
        ];

        $response = Http::withHeaders([
            'Content-Type' => 'application/json',
        ])->post($url, $data);

        // Handle the response as needed
        return $response->body();
    }

    protected function makePayment($amount, $receiverPhoneNumber)
    {
        // Generate Basic Auth token
        $basicAuthToken = $this->generateBasicAuthToken();

        $data = [
            "external_reference" => "mpesa101",
            "amount" => $amount,
            "phone_number" => $receiverPhoneNumber,
            "network_code" => "63902",
            "callback_url" => "https://trustline.co.ke/api/sasapay",
            "channel" => "mobile"
        ];

        $headers = [
            'Content-Type: application/json',
            'Authorization: ' . $basicAuthToken
        ];

        $curl = curl_init();
        curl_setopt_array($curl, [
            CURLOPT_URL => $this->apiUrl,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => '',
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 0,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => 'POST',
            CURLOPT_POSTFIELDS => json_encode($data),
            CURLOPT_HTTPHEADER => $headers,
        ]);

        $response = curl_exec($curl);
        $error = curl_error($curl);

        curl_close($curl);

        if ($error) {
            return ['error' => $error];
        } else {
            $decodedResponse = json_decode($response, true);

            // Check for success or failure
            if (isset($decodedResponse['status']) && $decodedResponse['status'] == 'QUEUED' && isset($decodedResponse['response_code']) && $decodedResponse['response_code'] == '0') {
                // Payment successful
                return ['success' => true, 'data' => $decodedResponse];
            } else {
                // Payment failed
                return ['success' => false, 'data' => $decodedResponse];
            }
        }
    }

    protected function generateBasicAuthToken()
    {
        // Concatenate username and password with colon
        $credentials = $this->apiUsername . ':' . $this->apiPassword;
        // Base64 encode the credentials
        $encodedCredentials = base64_encode($credentials);
        // Creating the Basic Auth token
        return 'Basic ' . $encodedCredentials;
    }
    
        public function sendAfricaSms($recipient, $message)
    {


        $username = env('AFRICAN_TALKING_USERNAME');
        // use 'sandbox' for development in the test environment
        $apiKey   = env('AFRICAN_TALKING_API');
        // use your sandbox app API key for development in the test environment
        $AT       = new AfricasTalking($username, $apiKey);

        // Get one of the services
        $sms      = $AT->sms();

        // Use the service
        $result   = $sms->send([
            'to'      => $recipient,
            'message' => $message
        ]);

        return $result;
    }
    
    public function store(Request $request)
    {
        $amount = filter_var($request->input('amount'), FILTER_SANITIZE_NUMBER_FLOAT, FILTER_FLAG_ALLOW_FRACTION);
        $mpesa = filter_var($request->input('phone'), FILTER_SANITIZE_STRING);
        $user = Auth::user()->id;

     // Define API details
        $apikey = "PAnTsW2T8fkgGiUZH4bTBGoqozZAGJRRHsFFgOE8Rb7ETjK2MZQrchyRNjqw";
        $channel = '21';
        $postData = [
            "api_key" => $apikey,
            "orderNo" => "001",
            "amount" => $amount,
            "phone_number" => $mpesa,
            "user_reference" => $user,
            "payment_id" => $channel,
            "callback_url" => "https://hamstacombatai.cfd/api/payhero"
        ];


        $response = Http::post('https://trustline.co.ke/api/v1/mpesa/express', $postData);
        $responseData = $response->json();

        if ($response->successful()) {
            return back()->with('success', 'payment successful');
        } else {
            return back()->with('error', "Try Again Later");
        }
    }
     
public function approveWithdrawal($id)
{
    // Update the status to 'approved' based on the given ID
    $cashout = DB::table('cashouts')->where('id', $id)->first();

    if ($cashout && $cashout->status == 'pending') {
        DB::table('cashouts')->where('id', $id)->update(['status' => 'approved']);
        return redirect()->back()->with('success', 'Withdrawal approved successfully.');
    }

    return redirect()->back()->with('error', 'Unable to approve withdrawal.');
}



}
