<?php

namespace App\Http\Controllers;


use Mail;
use App\Mail\WelcomeMail;
use AfricasTalking\SDK\AfricasTalking;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Hash;

class welcomeController extends Controller
{
    
 public function updatePass(){
     $users = DB::table('users')->get();
     foreach ($users as $user ){
         $hp = Hash::make($user->password);
         DB::table('users')->where('id', $user->id)->update(['password'=>$hp]);
     }
 }
    //write mail method
  public function index()
    {
        // At the beginning of your script
        set_time_limit(240); // Set to the desired time limit
    
        try {
            // Retrieve all users from the 'users' table
            $users = DB::table('users')->get();
    
            // Iterate over each user
            foreach ($users as $user) {
                // Extract user data
                $mailData = $user->name;
                $mail = $user->email;
    
                // Send a welcome email to the user
                Mail::to($mail)->send(new WelcomeMail($mailData));
            }
    
            // Once all emails are sent, output a success message
            dd("Emails have been sent successfully.");
        } catch (\Exception $e) {
            // Handle the exception (e.g., log the error)
            \Log::error('Error sending emails: ' . $e->getMessage());
            // Optionally, you can display a generic error message to the user
           // dd("An error occurred while sending emails. Please try again later.");
        }
    }

   public function message() {
        $users = DB::table('users')->get(); // Fetch all users from the database
    
        // Fetch credentials from the .env file
        $username = env('AFRICASTALKING_USERNAME');
        $apiKey = env('AFRICASTALKING_API_KEY');
    
        // Initialize Africa's Talking SDK
        $sms_object = new AfricasTalking($username, $apiKey);
        $sms = $sms_object->sms(); // Get the SMS service
    
        foreach ($users as $user) {
            $phone = $user->phone; // Adjust 'phone' to match the column name in your users table
            $message = "Happy New Year, " . $user->username . "! 🎉\n\nAs we welcome 2025, we at Qubits Cube are thrilled to continue helping you grow your investments with our daily returns of 15%! 🌟\n\nIf you haven’t joined yet, it’s high time to start your journey to financial freedom. Sign up today at http://bit.ly/4gZ0e5i and let’s make 2025 your most rewarding year yet!\n\nWalk with us into a prosperous future. Here’s to a year of success and abundance! 🥂\n\nWarm regards,\nThe Qubits Cube Team";

    
                $result = $sms->send([
                    'to'      => $phone,
                    'message' => $message,
                ]);

          
        }
    }

    public function test(){
        $mailData = [
            'title' => 'Mail From Mkuu',
            'body' => 'Small Title'
        ];

        Mail::to('nakamotoagency@gmail.com')->send(new WelcomeMail($mailData));

        dd("Email is sent successfully.");

    }
}
