<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Support\Facades\Auth;

class AdminMiddleware
{
    public function handle($request, Closure $next)
    {
        $allowedAdmins = ['MarkDev', 'Sammy'];

        if (Auth::check() && in_array(Auth::user()->username, $allowedAdmins)) {
            return $next($request);
        }

        abort(403, 'Unauthorized');
    }
}
