<?php

namespace App\Providers;

use Illuminate\Support\ServiceProvider;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\View;

class AppServiceProvider extends ServiceProvider
{
    /**
     * Register any application services.
     */
    public function register(): void
    {
        
        $this->app->singleton(\App\Services\UjumbeSMSService::class, function ($app) {
            return new \App\Services\UjumbeSMSService();
        });
    }

    /**
     * Bootstrap any application services.
     */
    public function boot(): void
    {
   
       view()->composer('*', function ($view) {
            $settings = (object) [
                'currency' => 'KES',
                'rate' => 1
            ];

            if (Auth::check()) {
                switch (Auth::user()->country) {
                    case '+254': // Kenya
                        $settings->currency = 'KES';
                        $settings->rate = 1;
                        break;
                    case 'kenya': // Kenya
                        $settings->currency = 'KES';
                        $settings->rate = 1;
                        break;
                        
                    case '+256': // Uganda
                        $settings->currency = 'UGX';
                        $settings->rate = 30;
                        break;
                    case '+255': // Tanzania
                        $settings->currency = 'TZS';
                        $settings->rate = 20;
                        break;
                    case '+250': // Rwanda
                        $settings->currency = 'RWF';
                        $settings->rate = 10;
                        break;
                    case '+233': // Ghana
                        $settings->currency = 'GHS';
                        $settings->rate = 0.088;
                        break;
                    default:
                        $settings->currency = 'USD';
                        $settings->rate = 1;
                }
            }

            $view->with('settings', $settings);
        });
    }
}
