<?php

namespace App\Services;

use Illuminate\Support\Facades\Http;

class UjumbeSMSService
{
    protected $apiUrl = 'https://ujumbesms.co.ke/api/messaging';
    protected $apiKey = 'MzA4MDQ4ZTY0MTFlODdhNWMyYWVlNWM3ZGYxMjlh'; // Use your actual API key
    protected $email = 'dennisdeveloper3@gmail.com'; // Use your actual email

    /**
     * Send an SMS message using the UjumbeSMS API.
     *
     * @param string $number
     * @param string $message
     * @param string $sender
     * @return array
     */
    public function sendSMS(string $number, string $message, string $sender = 'DEPTHSMS'): array
    {
        // Prepare the payload
        $payload = [
            'data' => [
                [
                    'message_bag' => [
                        'numbers' => $number, // Single or multiple numbers
                        'message' => $message,
                        'sender' => $sender,
                    ]
                ]
            ]
        ];

        // Use cURL to send the request
        $response = $this->sendCurlRequest($payload);

        return $response;
    }

    /**
     * Helper method to send the cURL request.
     *
     * @param array $payload
     * @return array
     */
    protected function sendCurlRequest(array $payload): array
    {
        $curl = curl_init();

        // Set cURL options
        curl_setopt_array($curl, [
            CURLOPT_URL => $this->apiUrl,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => '',
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 0,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => 'POST',
            CURLOPT_POSTFIELDS => json_encode($payload),
            CURLOPT_HTTPHEADER => [
                'X-Authorization: ' . $this->apiKey,
                'email: ' . $this->email,
                'Content-Type: application/json'
            ],
        ]);

        // Execute the request and close cURL
        $response = curl_exec($curl);
        curl_close($curl);

        // Return the response as an array (json_decode converts JSON response into an array)
        return json_decode($response, true);
    }
}
