<?php

namespace App\Services;

use Illuminate\Support\Facades\Http;
use Illuminate\Support\Facades\Log;
use Illuminate\Http\Client\ConnectionException;

class WhatsAppService
{
    protected $baseUrl;
    protected $username;
    protected $password;

    public function __construct()
    {
        $this->baseUrl = env('WA_API_BASE_URL');
        $this->username = env('WA_API_USERNAME');
        $this->password = env('WA_API_PASSWORD');
    }

    public function sendMessage($message, $phoneNumber)
    {

        try {
            $response = Http::withBasicAuth($this->username, $this->password)
                ->timeout(10)  // Set timeout to 10 seconds
                ->post("{$this->baseUrl}", [
                    'message' => $message,
                    'phone_number' => $phoneNumber,
                    'session' => $this->username,
                ]);

            if ($response->successful()) {
                Log::info('Message sent successfully', ['response' => $response->body()]);
            } else {
                Log::error('Failed to send message here', ['status' => $response->status(), 'response' => $response->body()]);
            }

            return $response;
        } catch (ConnectionException $e) {
            // Handle timeout exception gracefully
            Log::warning('WhatsApp API request timed out', ['error' => $e->getMessage()]);
        } catch (\Exception $e) {
            // Catch other potential exceptions
            Log::error('An error occurred while sending the message', ['error' => $e->getMessage()]);
        }
    }

    public function whatsappNotify($phoneNumber, $message)
    {
        try {
            $response = Http::withBasicAuth($this->username, $this->password)
                ->timeout(10)  // Set timeout to 10 seconds
                ->post("{$this->baseUrl}", [
                    'message' => $message,
                    'phone_number' => $phoneNumber,
                    'session' => $this->username,
                ]);

            if ($response->successful()) {
                Log::info('Message sent successfully', ['response' => $response->body()]);
            } else {
                Log::error('Failed to send message', ['status' => $response->status(), 'response' => $response->body()]);
            }

            return $response;
        } catch (ConnectionException $e) {
            // Handle timeout exception gracefully
            Log::warning('WhatsApp API request timed out', ['error' => $e->getMessage()]);
        } catch (\Exception $e) {
            // Catch other potential exceptions
            Log::error('An error occurred while sending the message', ['error' => $e->getMessage()]);
        }
    }
}
