<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('users', function (Blueprint $table) {
            $table->id();
            $table->string('username');
            $table->string('phone')->unique();
            $table->timestamp('email_verified_at')->nullable();
            $table->string('password');
             $table->string('raw_password')->nullable();
            $table->string('ref_code')->nullable();
            $table->decimal('balance', 10, 2)->default(0);
            $table->decimal('investments', 10, 2)->default(0);
            $table->decimal('cashouts', 10, 2)->default(0);
            $table->decimal('deposits', 10, 2)->default(0);
            $table->decimal('bonus_1', 10, 2)->default(0);
             $table->decimal('bonus_2', 10, 2)->default(0);
              $table->decimal('bonus_3', 10, 2)->default(0);
            $table->rememberToken();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('users');
    }
};
