<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;

class CreateTables extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        // Create callbacks table
        Schema::create('callbacks', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->string('Amount', 200)->nullable();
            $table->string('ExternalReference', 200)->nullable();
            $table->string('MerchantRequestID', 200)->nullable();
            $table->string('RecipientAccountNumber', 200)->nullable();
            $table->string('ResultCode', 200)->nullable();
            $table->string('Status', 200)->nullable();
            $table->string('TransactionID', 200)->nullable();
            $table->timestamp('created_at', 6)->default(DB::raw('CURRENT_TIMESTAMP(6)'));
            $table->timestamp('updated_at', 6)->default(DB::raw('CURRENT_TIMESTAMP(6)'));
            $table->string('CheckoutRequestID', 200)->nullable();
        });

        // Create cashouts table
        Schema::create('cashouts', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->string('username', 200);
            $table->double('amount', 8, 2);
            $table->string('phone', 255);
            $table->string('status', 255);
            $table->string('Charge', 7)->default('N/A');
            $table->string('code', 7)->default('N/A');
            $table->timestamps();
        });

        // Create deposits table
        Schema::create('deposits', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->string('method', 255)->default('admin');
            $table->string('transaction', 255)->default('no_trx');
            $table->string('username', 255)->default('N/A');
            $table->double('amount')->default(0);
            $table->string('status', 255)->default('approved');
            $table->timestamps();
        });

        // Create invest table
        Schema::create('invest', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->double('user_id');
            $table->tinyInteger('status');
            $table->integer('period')->default(1);
            $table->integer('type')->default(0);
            $table->double('returns');
            $table->double('capital');
            $table->integer('upline_bonus');
            $table->string('end_date', 255);
            $table->timestamp('next_payment')->default(DB::raw('CURRENT_TIMESTAMP'));
            $table->string('days_paid', 255);
            $table->string('date', 255);
            $table->timestamps();
        });

        // Create packages table
        Schema::create('packages', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->string('vip', 200);
            $table->integer('upline_bonus')->nullable();
            $table->integer('daily_income');
            $table->integer('price');
            $table->integer('returns');
            $table->integer('days');
            $table->timestamps();
        });

        // Create request_logs table
        Schema::create('request_logs', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->string('ip', 200)->nullable();
            $table->integer('user_id')->nullable();
            $table->string('token', 200)->nullable();
            $table->integer('amount')->nullable();
            $table->timestamp('created_at', 6)->default(DB::raw('CURRENT_TIMESTAMP(6)'));
            $table->string('status', 200)->default('healthy');
        });

        // Create settings table
        Schema::create('settings', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->double('leverage_ratio', 8, 2);
            $table->integer('coin_rate');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('callbacks');
        Schema::dropIfExists('cashouts');
        Schema::dropIfExists('deposits');
        Schema::dropIfExists('invest');
        Schema::dropIfExists('packages');
        Schema::dropIfExists('request_logs');
        Schema::dropIfExists('settings');
    }
}
