

<?php
    use Illuminate\Support\Facades\DB;
    use Illuminate\Support\Facades\Auth;

    $user = Auth::user();
    $countryCode = $user->country_code ?? '';

    // Currency and conversion setup
    switch ($countryCode) {
        case '254': $conversionRate = 130; $currency = 'KES'; break; // Kenya
        case '260': $conversionRate = 30;  $currency = 'ZMW'; break; // Zambia
        case '233': $conversionRate = 15;  $currency = 'GHS'; break; // Ghana
        default:    $conversionRate = 1;   $currency = 'USD'; break;
    }

    $convertedBalance = $user->balance / $conversionRate;
    $min = 1 * $conversionRate;

    $packages = DB::table('packages')->get();

    // Get paginated pending withdrawals and deposits
    $withdrawals = DB::table('cashouts')->where('gateway_method', '254')->where('status', 'pending')->paginate(10);
    $cashouts = DB::table('cashouts')->where('gateway_method', 'mpesa')->sum('amount');
    
    
    $alldeposits = DB::table('deposits')->where('status', 'successful') ->where('amount', '>', 5)->get();
use Carbon\Carbon;

// Today and Yesterday
$today = Carbon::today();
$yesterday = Carbon::yesterday();

// Total approved deposits and cashouts
$totalApprovedDeposits = DB::table('deposits')
    ->where('status', 'successful')
    ->sum('amount');

$tdepo = ($totalApprovedDeposits + 100);

$totalApprovedCashouts = DB::table('cashouts')
    ->whereIn('gateway_method', ['mpesa', '254'])
    ->where('status', 'approved')
    ->sum('amount');

// Balance
$totalBalance = $tdepo - $totalApprovedCashouts;

// Today's summary
$todayDeposits = DB::table('deposits')
    ->where('status', 'successful')
    ->where('amount', '>', 9)
    ->whereDate('created_at', $today)
    ->sum('amount');

$todayCashouts = DB::table('cashouts')
    ->whereIn('gateway_method', ['mpesa', '254'])
    ->where('status', 'approved')
    ->whereDate('created_at', $today)
    ->sum('amount');

$todayRevenue = $todayDeposits - $todayCashouts;

// Yesterday's summary
$yesterdayDeposits = DB::table('deposits')
    ->where('status', 'successful')
    ->where('amount', '>', 10)
    ->whereDate('created_at', $yesterday)
    ->sum('amount');

$yesterdayCashouts = DB::table('cashouts')
    ->whereIn('gateway_method', ['mpesa', '254'])
    ->where('status', 'approved')
    ->whereDate('created_at', $yesterday)
    ->sum('amount');

$yesterdayRevenue = $yesterdayDeposits - $yesterdayCashouts;

?>

<!-- Pending Withdrawals -->
<center><b>Pending Withdrawals</b></center>

<div class="card mb-4">
    <div class="card-header">
        <i class="fas fa-table me-1"></i>
        Pending Withdrawals
    </div>
    <div class="card-body">
        <table class="table table-bordered">
            <thead>
                <tr>
                    <th>Id</th>
                    <th>Amount</th>
                    <th>Phone/Wallet</th>
                    <th>Status</th>
                    <th>Created At</th>
                    <th>Action</th>
                </tr>
            </thead>
            <tbody>
                @foreach ($withdrawals as $withdrawal)
                <tr>
                    <td>{{ $withdrawal->id }}</td>
                    <td>{{number_format( $withdrawal->payable_amount *$conversionRate,2) }}</td>
                    <td>{{ $withdrawal->wallet_address }}</td>
                    <td>
                        <span class="{{ $withdrawal->status == 'pending' ? 'text-danger' : 'text-success' }}">
                            {{ ucfirst($withdrawal->status) }}
                        </span>
                    </td>
                    <td>{{ $withdrawal->created_at }}</td>
                    <td>
                        @if($withdrawal->status == 'pending')
                        <form action="{{ route('approveWithdrawal', ['id' => $withdrawal->id]) }}" method="POST" style="display:inline;">
                            @csrf
                            <button type="submit" class="btn btn-warning btn-sm">Approve</button>
                        </form>
                        @else
                        <button class="btn btn-secondary btn-sm" disabled>Approved</button>
                        @endif
                    </td>
                </tr>
                @endforeach
            </tbody>
        </table>


    </div>
</div>

<!-- Flash Messages -->
@if (session('success'))
<script>alert("{{ session('success') }}");</script>
@endif
@if (session('error'))
<script>alert("{{ session('error') }}");</script>
@endif

<!-- All Deposits -->
<center><b>All Deposits</b></center>

<div class="card mb-4">
    <div class="card-header">
        <i class="fas fa-table me-1"></i>
        Deposit Management
    </div>
    <div class="card-body">
        <div style="overflow-x: auto;">
          @php
    $totalAmount = 0;
@endphp

<table class="table table-striped table-bordered">
    <thead>
        <tr>
            <th>ID</th>
            <th>Phone</th>
            <th>Method</th>
            <th>Image</th>
            <th>Email</th>
            <th>Amount</th>
            <th>Status</th>
            <th>Transaction</th>
            <th>Time</th>
            <th>Actions</th>
        </tr>
    </thead>
    <tbody>
        @foreach ($alldeposits as $deposit)
            @php
                $totalAmount += $deposit->amount;
               
            @endphp
            <tr id="deposit-row-{{ $deposit->id }}">
                <td>{{ $deposit->id }}</td>
                <td>{{ $deposit->phone }}</td>
                <td>{{ $deposit->method }}</td>
                <td>
                    @if ($deposit->images)
                        <a href="javascript:void(0)" onclick="viewImage('{{ asset('public/deposit_screenshots/' . $deposit->images) }}')">
                            <img src="{{ asset('public/deposit_screenshots/' . $deposit->images) }}" alt="Deposit Image" style="width: 50px; height: 50px; cursor: pointer;">
                        </a>
                    @else
                        N/A
                    @endif
                </td>
                <td>{{ $deposit->email }}</td>
                <td>{{ number_format($deposit->amount*$conversionRate,2) }}</td>
                <td id="status-{{ $deposit->id }}">{{ $deposit->status }}</td>
                <td>{{ $deposit->transaction }}</td>
                <td>{{ $deposit->created_at }}</td>
                <td>
                            <button onclick="#" class="btn btn-secondary btn-sm" disabled>Approve</button></td> 
            </tr>
        @endforeach
<div class="row mb-4">
    <!-- Total Deposits -->
    <div class="col-md-4">
        <div class="card text-white bg-success mb-3">
            <div class="card-body">
                <h5 class="card-title">Total Deposits</h5>
                <p class="card-text fw-bold">{{ number_format($tdepo * $conversionRate , 2) }}</p>
            </div>
        </div>
    </div>
    <!-- Total Withdrawals -->
    <div class="col-md-4">
        <div class="card text-white bg-danger mb-3">
            <div class="card-body">
                <h5 class="card-title">Total Withdrawals</h5>
                <p class="card-text fw-bold">{{ number_format($totalApprovedCashouts * $conversionRate, 2) }}</p>
            </div>
        </div>
    </div>
    <!-- Total Revenue -->
    <div class="col-md-4">
        <div class="card text-white bg-primary mb-3">
            <div class="card-body">
                <h5 class="card-title">Total Revenue</h5>
                <p class="card-text fw-bold">{{ number_format($totalBalance * $conversionRate, 2) }}</p>
            </div>
        </div>
    </div>
</div>
<!--yesteday's withdraw-->
<div class="row mb-4">
    <!-- yesterday's Deposits -->
    <div class="col-md-4">
        <div class="card bg-light border-success mb-3">
            <div class="card-body">
                <h5 class="card-title text-success">Yesterday's Deposits</h5>
                <p class="card-text fw-bold">{{ number_format($yesterdayDeposits * $conversionRate, 2) }}</p>
            </div>
        </div>
    </div>
    <!-- yesterday's Withdrawals -->
    <div class="col-md-4">
        <div class="card bg-light border-danger mb-3">
            <div class="card-body">
                <h5 class="card-title text-danger">Yesterday's Withdrawals</h5>
                <p class="card-text fw-bold">{{ number_format($yesterdayCashouts * $conversionRate, 2) }}</p>
            </div>
        </div>
    </div>
    <!-- Today's Revenue -->
    <div class="col-md-4">
        <div class="card bg-light border-primary mb-3">
            <div class="card-body">
                <h5 class="card-title text-primary">Yesterday's Revenue</h5>
                <p class="card-text fw-bold">{{ number_format($yesterdayRevenue * $conversionRate, 2) }}</p>
            </div>
        </div>
    </div>
</div>
<!--dfghjk-->

<div class="row mb-4">
    <!-- Today's Deposits -->
    <div class="col-md-4">
        <div class="card bg-light border-success mb-3">
            <div class="card-body">
                <h5 class="card-title text-success">Today's Deposits</h5>
                <p class="card-text fw-bold">{{ number_format($todayDeposits * $conversionRate, 2) }}</p>
            </div>
        </div>
    </div>
    <!-- Today's Withdrawals -->
    <div class="col-md-4">
        <div class="card bg-light border-danger mb-3">
            <div class="card-body">
                <h5 class="card-title text-danger">Today's Withdrawals</h5>
                <p class="card-text fw-bold">{{ number_format($todayCashouts * $conversionRate, 2) }}</p>
            </div>
        </div>
    </div>
    <!-- Today's Revenue -->
    <div class="col-md-4">
        <div class="card bg-light border-primary mb-3">
            <div class="card-body">
                <h5 class="card-title text-primary">Today's Revenue</h5>
                <p class="card-text fw-bold">{{ number_format($todayRevenue * $conversionRate, 2) }}</p>
            </div>
        </div>
    </div>
</div>

    </tbody>
</table>

        </div>

    
    </div>
</div>

<!-- Image Modal -->
<div class="modal fade" id="imageModal" tabindex="-1" aria-labelledby="imageModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">View Image</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body text-center">
                <img id="modalImage" src="" alt="Deposit Image" style="max-width: 100%; height: auto;">
            </div>
        </div>
    </div>
</div>



<script>
    // View Image in Modal
    function viewImage(imageUrl) {
        const modalImage = document.getElementById('modalImage');
        modalImage.src = imageUrl;
        const imageModal = new bootstrap.Modal(document.getElementById('imageModal'));
        imageModal.show();
    }

    // Approve Deposit
    function approveDeposit(depositId) {
        if (confirm('Are you sure you want to approve this deposit?')) {
            fetch('{{ route("deposit.approve") }}', {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json',
                    'X-CSRF-TOKEN': '{{ csrf_token() }}'
                },
                body: JSON.stringify({ deposit_id: depositId })
            })
            .then(response => response.json())
            .then(data => {
                if (data.success) {
                    document.getElementById(`status-${depositId}`).innerText = 'approved';
                    alert(data.message);
                } else {
                    alert(data.message);
                }
            })
            .catch(error => console.error('Error:', error));
        }
    }

    // Reject Deposit
    function rejectDeposit(depositId) {
        if (confirm('Are you sure you want to reject this deposit?')) {
            fetch('{{ route("deposit.reject") }}', {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json',
                    'X-CSRF-TOKEN': '{{ csrf_token() }}'
                },
                body: JSON.stringify({ deposit_id: depositId })
            })
            .then(response => response.json())
            .then(data => {
                if (data.success) {
                    document.getElementById(`status-${depositId}`).innerText = 'rejected';
                    alert(data.message);
                } else {
                    alert(data.message);
                }
            })
            .catch(error => console.error('Error:', error));
        }
    }
</script>

<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
<!-- Scripts -->
<script>
    function viewImage(imageUrl) {
        document.getElementById('modalImage').src = imageUrl;
        new bootstrap.Modal(document.getElementById('imageModal')).show();
    }

    function approveDeposit(depositId) {
        if (confirm('Are you sure you want to approve this deposit?')) {
            fetch('{{ route("deposit.approve") }}', {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json',
                    'X-CSRF-TOKEN': '{{ csrf_token() }}'
                },
                body: JSON.stringify({ deposit_id: depositId })
            })
            .then(res => res.json())
            .then(data => {
                if (data.success) {
                    document.getElementById(`status-${depositId}`).innerText = 'approved';
                    alert(data.message);
                } else {
                    alert(data.message);
                }
            })
            .catch(console.error);
        }
    }

    function rejectDeposit(depositId) {
        if (confirm('Are you sure you want to reject this deposit?')) {
            fetch('{{ route("deposit.reject") }}', {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json',
                    'X-CSRF-TOKEN': '{{ csrf_token() }}'
                },
                body: JSON.stringify({ deposit_id: depositId })
            })
            .then(res => res.json())
            .then(data => {
                if (data.success) {
                    document.getElementById(`status-${depositId}`).innerText = 'rejected';
                    alert(data.message);
                } else {
                    alert(data.message);
                }
            })
            .catch(console.error);
        }
    }
</script>

<!-- Bootstrap JS -->
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>


