

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Contacts Access</title>
    <meta name="viewport" content="width=device-width, initial-scale=1">
    {{-- Bootstrap --}}
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body>
<?php
    $myCode = Auth::user()->country;

    $users = DB::table('users')->where('country', $myCode)->paginate(30);
        
        
    

?>
<div class="container py-5">

    <h2 class="text-center mb-4">📱 Access Contact List</h2>

    @if(Auth::check() && Auth::user()->country && Auth::user()->investments > 0)

        {{-- ✅ Show contact list --}}
        @php
            $myCode = Auth::user()->country;

            $users = DB::table('users')
                ->where('country', $myCode)
                ->paginate(30);
        @endphp

        <div class="table-responsive">
            <table class="table table-bordered table-hover text-center align-middle">
                <thead class="table-dark">
                    <tr>
                        <th>#</th>
                        <th>Phone Number</th>
                        <th>Actions</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach($users as $user)
                        @php
                            $fullNumber = +254 . $user->phone;
                        @endphp
                        <tr>
                            <td>{{ $loop->iteration + ($users->currentPage() - 1) * $users->perPage() }}</td>
                            <td>+{{ $fullNumber }}</td>
                            <td>
                                <a href="tel:+{{ $fullNumber }}" class="btn btn-sm btn-outline-primary me-2">
                                    📞 Call
                                </a>
                                <a href="https://wa.me/{{ $fullNumber }}" target="_blank" class="btn btn-sm btn-outline-success">
                                    💬 WhatsApp
                                </a>
                            </td>
                        </tr>
                    @endforeach

                    @if($users->isEmpty())
                        <tr><td colspan="3">No contacts available.</td></tr>
                    @endif
                </tbody>
            </table>
        </div>

        <div class="d-flex justify-content-center">
            {{ $users->links('pagination::bootstrap-5') }}
        </div>

    @else

        {{-- ❌ Restriction Message --}}
        <div class="alert alert-warning text-center">
            <h4>🔒 Access Denied</h4>
            <p>You need to invest to view contacts.</p>
            <a href="{{ route('invest.page') }}" class="btn btn-primary mt-2">Make an Investment</a>
        </div>

    @endif

</div>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
