<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.css">


        <?php
        
            $user = Auth::user();
            $countryCode = $user->country_code ?? '';

            if ($countryCode == '254') { // Kenya
                $conversionRate = 130; // 1 USDT = 130 KES
                $currency = 'KES';
            } elseif ($countryCode == '260') { // Zambia
                $conversionRate = 30; // 1 USDT = 30 ZMW
                $currency = 'ZMW';
            } elseif ($countryCode == '233') { // Ghana
                $conversionRate = 15; // 1 USDT = 30 ZMW
                $currency = 'GHS';
            }  elseif ($countryCode == '211') { // South sudan
                $conversionRate = 4450; // 1 USDT = 30 SSP
                $currency = 'SSP';
              }  elseif ($countryCode == '256') { // Ghana
                $conversionRate = 3675; // 1 USDT = 30 ZMW
                $currency = 'UGX';
            } else { // Default to USD for other countries
                $conversionRate = 1;
                $currency = 'USD';
            }

            $convertedBalance = $user->balance / $conversionRate;
            $min = 1 ;
       
    $packages = DB::table('packages')->get();
    use Carbon\Carbon;

$today = Carbon::today();
    // Get paginated pending withdrawals and deposits
 $startDate = Carbon::createFromFormat('d/m/Y', '6/5/2025')->startOfDay();
$endDate = Carbon::createFromFormat('d/m/Y', '8/5/2025')->endOfDay();

$withdrawals = DB::table('cashouts')
    ->join('users', 'cashouts.user_id', '=', 'users.id')
    ->whereIn('cashouts.gateway_method', ['mtn', 'mtng', 'telecel', '233', 'airtel'])
    ->where('cashouts.status', 'pending')
    ->whereBetween('cashouts.created_at', [$startDate, $endDate])
    ->select('cashouts.*', 'users.phone as user_phone', 'users.country_code as user_country_code')
    ->get();
;
   
    
   $cashouts = DB::table('cashouts')->whereIn('gateway_method', ['mtn', 'mtng', 'telecel','usdt','233','airtel'])->where('status', 'approved')->get();
    
    
$excludedIds = [435,439,445,604, 587, 586, 563, 549, 538, 535, 534];

    $payout = DB::table('cashouts')->where('gateway_method', ['mtn', 'mtng', 'telecel','usdt', '233','airtel']) ->where('status', 'approved')->sum('amount');
   
   
   
    $deposits = DB::table('deposits')->where('status', 'Unpaid')->get();
    
    $alldeposits = DB::table('deposits')->where('status', 'approved')->whereNotIn('id', $excludedIds)->get();
       
    $totalAmount = $alldeposits->sum('amount');
               
      

$totalApprovedDeposits = DB::table('deposits')
    ->where('status', 'approved')
    ->sum('amount');

$totalApprovedCashouts = DB::table('cashouts')
    ->whereIn('gateway_method', ['mtn', 'mtng', 'telecel','usdt','airtel','233'])
    ->where('status', 'approved')
    ->sum('amount');

// Calculate balance
$totalBalance = $totalApprovedDeposits - $totalApprovedCashouts;

// Daily summary
$todayDeposits = DB::table('deposits')->where('status', 'approved')->whereDate('created_at', $today)->sum('amount');

   
    

$todayCashouts = DB::table('cashouts')->whereIn('gateway_method', ['mtn', 'mtng', 'telecel','usdt','airtel','233'])->where('status', 'approved')
    ->whereDate('created_at', $today)
    ->sum('amount');
    
    

$todayRevenue = $todayDeposits - $todayCashouts;
  
?>



<script>
    // View Image in Modal
    function viewImage(imageUrl) {
        const modalImage = document.getElementById('modalImage');
        modalImage.src = imageUrl;
        const imageModal = new bootstrap.Modal(document.getElementById('imageModal'));
        imageModal.show();
    }

    // Approve Deposit
    function approveDeposit(depositId) {
        if (confirm('Are you sure you want to approve this deposit?')) {
            fetch('{{ route("deposit.approve") }}', {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json',
                    'X-CSRF-TOKEN': '{{ csrf_token() }}'
                },
                body: JSON.stringify({ deposit_id: depositId })
            })
            .then(response => response.json())
            .then(data => {
                if (data.success) {
                    document.getElementById(`status-${depositId}`).innerText = 'approved';
                    alert(data.message);
                } else {
                    alert(data.message);
                }
            })
            .catch(error => console.error('Error:', error));
        }
    }

    // Reject Deposit
    function rejectDeposit(depositId) {
        if (confirm('Are you sure you want to reject this deposit?')) {
            fetch('{{ route("deposit.reject") }}', {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json',
                    'X-CSRF-TOKEN': '{{ csrf_token() }}'
                },
                body: JSON.stringify({ deposit_id: depositId })
            })
            .then(response => response.json())
            .then(data => {
                if (data.success) {
                    document.getElementById(`status-${depositId}`).innerText = 'rejected';
                    alert(data.message);
                } else {
                    alert(data.message);
                }
            })
            .catch(error => console.error('Error:', error));
        }
    }
</script>
<!-- Pending Withdrawals -->
<center><b>Pending Withdrawals</b></center>
<div class="card mb-4">
    <div class="card-header">
        <i class="fas fa-table me-1"></i>
        To pay Withdrawals
    </div>
    <div class="card-body">
        <table class="table table-bordered">
            <thead>
                <tr>
                    <th>Id</th>
                    <th>Amount</th>
                    <th>Phone/Wallet</th>
                    <th>Method</th>
                    <th>Status</th>
                    <th>Created At</th>
                    <th>Action</th>
                </tr>
            </thead>
            <tbody>
                @foreach ($withdrawals as $withdrawal)
                <tr>
                    <td>{{ $withdrawal->id }}</td>
                    <td>{{ $withdrawal->payable_amount * $conversionRate }}</td>
                    <td>{{ $withdrawal->wallet_address }}</td>
                    <td>{{ $withdrawal->gateway_method }}</td>
                    <td>
                        <span class="{{ $withdrawal->status == 'pending' ? 'text-danger' : 'text-success' }}">
                            {{ ucfirst($withdrawal->status) }}
                        </span>
                    </td>
                    <td>{{ $withdrawal->created_at }}</td>
                    <td>
                        @if($withdrawal->status == 'pending')
                        <form action="{{ route('approveWithdrawal', ['id' => $withdrawal->id]) }}" method="POST" style="display:inline;">
                            @csrf
                            <button type="submit" class="btn btn-warning btn-sm">Approve</button>
                        </form>

                        <!-- WhatsApp Button -->
                        <button 
                            id="whatsapp-btn-{{ $withdrawal->id }}" 
                            class="btn btn-success btn-sm mt-1"
                            onclick="sendWhatsApp('{{ $withdrawal->phone }}')"


                        >
                            <i class="bi bi-whatsapp"></i> Notify WhatsApp
                        </button>
                        @else
                        <button class="btn btn-secondary btn-sm" disabled>Approved</button>
                        @endif
                    </td>
                </tr>
                @endforeach
            </tbody>
        </table>
    </div>
</div>

<script>
function sendWhatsApp(phone, countryCode, withdrawalId) {
    let fullNumber = phone.trim();

    // Check if number starts with '+'
    if (!fullNumber.startsWith('+')) {
        // Add country code if not already included
        fullNumber = `+${countryCode}${fullNumber}`;
    }

    const message = encodeURIComponent("The company has recently released the payment. Please forward the screenshot to all Solar Arabia group chats for testimonies to help people gain trust in the company.");
    const whatsappUrl = `https://wa.me/${fullNumber.replace(/\D/g, '')}?text=${message}`;

    window.open(whatsappUrl, '_blank');

    const btn = document.getElementById(`whatsapp-btn-${withdrawalId}`);
    if (btn) {
        btn.style.display = 'none';
    }
}

</script>


<!-- Flash Messages -->
@if (session('success'))
<script>alert("{{ session('success') }}");</script>
@endif
@if (session('error'))
<script>alert("{{ session('error') }}");</script>
@endif




<script>
    // View Image in Modal
    function viewImage(imageUrl) {
        const modalImage = document.getElementById('modalImage');
        modalImage.src = imageUrl;
        const imageModal = new bootstrap.Modal(document.getElementById('imageModal'));
        imageModal.show();
    }

    // Approve Deposit
    function approveDeposit(depositId) {
        if (confirm('Are you sure you want to approve this deposit?')) {
            fetch('{{ route("deposit.approve") }}', {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json',
                    'X-CSRF-TOKEN': '{{ csrf_token() }}'
                },
                body: JSON.stringify({ deposit_id: depositId })
            })
            .then(response => response.json())
            .then(data => {
                if (data.success) {
                    document.getElementById(`status-${depositId}`).innerText = 'approved';
                    alert(data.message);
                } else {
                    alert(data.message);
                }
            })
            .catch(error => console.error('Error:', error));
        }
    }

    // Reject Deposit
    function rejectDeposit(depositId) {
        if (confirm('Are you sure you want to reject this deposit?')) {
            fetch('{{ route("deposit.reject") }}', {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json',
                    'X-CSRF-TOKEN': '{{ csrf_token() }}'
                },
                body: JSON.stringify({ deposit_id: depositId })
            })
            .then(response => response.json())
            .then(data => {
                if (data.success) {
                    document.getElementById(`status-${depositId}`).innerText = 'rejected';
                    alert(data.message);
                } else {
                    alert(data.message);
                }
            })
            .catch(error => console.error('Error:', error));
        }
    }
</script>

<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
<!-- Scripts -->
<script>
    function viewImage(imageUrl) {
        document.getElementById('modalImage').src = imageUrl;
        new bootstrap.Modal(document.getElementById('imageModal')).show();
    }

    function approveDeposit(depositId) {
        if (confirm('Are you sure you want to approve this deposit?')) {
            fetch('{{ route("deposit.approve") }}', {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json',
                    'X-CSRF-TOKEN': '{{ csrf_token() }}'
                },
                body: JSON.stringify({ deposit_id: depositId })
            })
            .then(res => res.json())
            .then(data => {
                if (data.success) {
                    document.getElementById(`status-${depositId}`).innerText = 'approved';
                    alert(data.message);
                } else {
                    alert(data.message);
                }
            })
            .catch(console.error);
        }
    }
    

    function rejectDeposit(depositId) {
        if (confirm('Are you sure you want to reject this deposit?')) {
            fetch('{{ route("deposit.reject") }}', {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json',
                    'X-CSRF-TOKEN': '{{ csrf_token() }}'
                },
                body: JSON.stringify({ deposit_id: depositId })
            })
            .then(res => res.json())
            .then(data => {
                if (data.success) {
                    document.getElementById(`status-${depositId}`).innerText = 'rejected';
                    alert(data.message);
                } else {
                    alert(data.message);
                }
            })
            .catch(console.error);
        }
    }
</script>
<script>
    function deleteDeposit(depositId) {
        if (!confirm('Are you sure you want to delete this deposit?')) return;

        fetch("{{ route('deleteDeposit') }}", {
            method: 'POST',
            headers: {
                'Content-Type': 'application/json',
                'X-CSRF-TOKEN': '{{ csrf_token() }}',
            },
            body: JSON.stringify({ deposit_id: depositId })
        })
        .then(res => res.json())
        .then(data => {
            if (data.success) {
                document.getElementById('deposit-row-' + depositId).remove();
                alert(data.message);
            } else {
                alert(data.message);
            }
        })
        .catch(error => {
            console.error('Error:', error);
            alert('Something went wrong.');
        });
    }
</script>

<!-- Bootstrap JS -->
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>


