@extends('layouts.admins')

@section('content')

<div class="container mt-5 d-flex justify-content-center">
    <div class="card shadow-lg p-4" style="width: 100%; max-width: 600px; background-color: #f9f9fb; border-radius: 12px;">
        <h3 class="text-center text-primary mb-4">🔐 Reset User Password</h3>

        @if(session('success'))
            <div class="alert alert-success text-center">{{ session('success') }}</div>
        @elseif(session('error'))
            <div class="alert alert-danger text-center">{{ session('error') }}</div>
        @endif

        <form method="POST" action="{{ route('admin.reset.password') }}">
            @csrf

            <div class="mb-3">
                <label for="identifier" class="form-label fw-semibold">Username or Phone</label>
                <input type="text" name="identifier" class="form-control" placeholder="Enter username or phone number" required>
            </div>

            <div class="mb-3">
                <label class="form-label fw-semibold">New Password</label>
                <input type="password" name="password" class="form-control" placeholder="Enter new password" required>
            </div>

            <div class="mb-4">
                <label class="form-label fw-semibold">Confirm New Password</label>
                <input type="password" name="password_confirmation" class="form-control" placeholder="Confirm new password" required>
            </div>

            <div class="d-flex justify-content-between">
                <button type="submit" class="btn btn-success px-4">Reset</button>
                <a href="{{ route('admin.index') }}" class="btn btn-outline-secondary">Back</a>
            </div>
        </form>
    </div>
</div>

@endsection
