@extends('layouts.main')

@section('content')

  <div class="inner-frame">
<div class="container">
    <h1>Create a New Post</h1>

    <!-- Form to create a new post -->
   <form action="{{ route('admin.posts.store') }}" method="POST" enctype="multipart/form-data">
           @csrf
        <div class="form-group">
            <label for="content">Post Content</label>
            <textarea name="content" id="content" class="form-control" rows="4" required></textarea>
        </div>

        <div class="form-group">
            <label for="image">Upload Image (Optional)</label>
            <input type="file" name="image" id="image" class="form-control-file">
        </div>

        <button type="submit" class="btn btn-primary">Create Post</button>
    </form>

    <!-- List of existing posts -->
    <h2 class="mt-5">Existing Posts</h2>

    @foreach($posts as $post)
        <div class="card mt-3">
            <div class="card-body">
                <h5 class="card-title">{{ $post->user->name }}</h5>
                <p class="card-text">{{ $post->content }}</p>
                @if($post->image)
                    <img src="{{ asset('storage/' . $post->image) }}" class="img-fluid" alt="Post Image">
                @endif
            </div>
        </div>
    @endforeach
</div>
</div>
@endsection
