@extends('layouts.main')

@section('content')
    <h1>Manage Withdrawals</h1>
    <table class="table">
        <thead>
            <tr>
                <th>ID</th>
                <th>User</th>
                <th>Amount</th>
                <th>Status</th>
                <th>Actions</th>
            </tr>
        </thead>
        <tbody>
            @foreach($withdrawals as $withdrawal)
                <tr>
                    <td>{{ $withdrawal->id }}</td>
                    <td>{{ $withdrawal->user->name }}</td>
                    <td>{{ $withdrawal->amount }}</td>
                    <td>{{ ucfirst($withdrawal->status) }}</td>
                    <td>
                        @if($withdrawal->status == 'pending')
                            <form action="{{ route('admin.approveWithdrawal', $withdrawal->id) }}" method="POST">
                                @csrf
                                <button type="submit" class="btn btn-success">Approve</button>
                            </form>
                        @endif
                    </td>
                </tr>
            @endforeach
        </tbody>
    </table>
@endsection
