@extends('layouts.main')
@section('content')
<div class="container mt-5 my-0 py-0">
    <div class="card my-0 py-0">
        <div class="my-0 py-0 card-header bg-primary text-white">
            <h5 class="mb-0">Investment History</h5>
        </div>
        <div class="card-body my-0 p-1">
            @php
                use Illuminate\Support\Facades\DB;
                use Carbon\Carbon;

                // Fetch investments directly using DB::query()
                $investments = DB::table('invest')
                    ->where('user_id', auth()->id())
                    ->orderBy('created_at', 'desc')
                    ->get();
            @endphp

            @if($investments->isEmpty())
                <p class="text-muted">No investments found.</p>
            @else
                <div class="table-responsive">
                    <table class="table table-sm table-striped table-bordered">
                        <thead class="thead-dark table-sm">
                            <tr>
                            
                                <th>Status</th>
                               
                                <th>Capital</th>
                                <th>Returns</th>
                               
                                <th>Days Paid</th>
                                <th>Start Date</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($investments as $investment)
                                <tr>
                                   
                                    <td>{{ $investment->status ? 'Active' : 'Inactive' }}</td>
                                  
                                    <td>{{ number_format($investment->capital, 2) }}</td>
                                    <td>{{ number_format($investment->returns, 2) }}</td>
                                 
                                  
                                    <td>{{ $investment->days_paid }}/20</td>
                                    <td>{{ Carbon::parse($investment->date)->addHours(3)->format('Y-m-d H:i:s') }}</td>
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
            @endif
        </div>
    </div>
</div>
@endsection
