@extends('layouts.app')

@section('content')
<span style="display:block; text-align:center; font-size:18px; font-weight:bold; text-decoration:underline;">Login Into Your Account</span>


<div class="flex mb-6 border-b">
    <span class="w-1/2 py-2 text-sm font-medium text-blue-500 border-b-2 border-primary-white text-center">
        <i class="fas fa-sign-in-alt mr-2"></i>Mobile Login
    </span>
    <a href="{{ route('register') }}" class="w-1/2 py-2 text-sm text-gray-500 hover:text-blue-500 border-b-2 border-transparent text-center">
        <i class="fas fa-user-plus mr-2"></i>Register Account
    </a>
</div>
  
@if ($errors->has('login'))
    <div class="mb-4 p-3 bg-red-100 border-l-4 border-red-500 text-red-700">
        <i class="fas fa-exclamation-circle mr-2"></i>{{ $errors->first('login') }}
    </div>
@endif

<form method="POST" action="{{ route('login') }}" class="space-y-4">
    @csrf
   <span>Enter phone Number</span>
    <div class="relative">
        
        <i class="fas fa-phone absolute left-3 top-1/2 transform -translate-y-1/2 text-blue-500"></i>

        <input type="text" name="email" value="{{ old('login') }}" placeholder="Phone Login" required 
               class="w-full pl-10 p-3 border border-gray-300 rounded focus:outline-none focus:ring-2 focus:ring-primary-green focus:border-transparent text-gray-800" />
    </div>
   <span>Enter Your Password</span>
    <div class="relative">
         
        <i class="fas fa-lock absolute left-3 top-1/2 transform -translate-y-1/2 text-blue-500"></i>
        <input type="password" name="password" placeholder="Enter password" required 
               class="w-full pl-10 p-3 border border-gray-300 rounded focus:outline-none focus:ring-2 focus:ring-primary-green focus:border-transparent text-gray-800" />
    </div>
    
    <button type="submit" class="w-full p-3 bg-black hover:bg-dark text-white font-medium rounded transition duration-300" style="border:1px solid white;">
        <i class="fas fa-check-circle mr-2"></i>Confirm
    </button>
    
    <div class="text-center text-sm text-blue-500 mt-4">
        <a href="#" class="text-blue-500 hover:underline">
            <i class="fas fa-question-circle mr-1"></i>Forgot password?
        </a>
    </div>
</form>
@endsection