@extends('layouts.app')

@section('content')
<div class="container" style="max-width: 500px; margin: auto; padding: 20px; border: 1px solid #ddd; border-radius: 10px; box-shadow: 2px 2px 10px rgba(0, 0, 0, 0.1); background: #fff;">
    <h2 style="text-align: center; margin-bottom: 20px; color: #333;">Reset Password</h2>

    <!-- Success Message -->
    @if(session('success'))
        <div style="background: #d4edda; color: #155724; padding: 10px; border-radius: 5px; margin-bottom: 15px;">
            {{ session('success') }}
        </div>
    @endif
    
    @php
    
    $user = DB::table('users')->where('id', request()->query('id'))->first();
    @endphp

    <!-- Errors -->
    @if($errors->any())
        <div style="background: #f8d7da; color: #721c24; padding: 10px; border-radius: 5px; margin-bottom: 15px;">
            <ul style="margin: 0; padding-left: 20px;">
                @foreach ($errors->all() as $error)
                    <li>{{ $error }}</li>
                @endforeach
            </ul>
        </div>
    @endif

    <form action="{{ route('password.sendCode') }}" method="POST">
        @csrf
        <div style="margin-bottom: 15px;">
            <label for="identifier" style="font-weight: bold;">Enter Phone or Username</label>
            <input type="text" @if($user) value="{{$user->phone}}" @endif name="identifier" id="identifier" required 
                style="width: 100%; padding: 10px; border: 1px solid #ccc; border-radius: 5px; margin-top: 5px;">
        </div>
        <button type="submit" 
            style="width: 100%; padding: 10px; background: #007bff; color: white; border: none; border-radius: 5px; cursor: pointer;">
            Send Reset Code
        </button>
    </form>

    @if(session('reset_code'))
    <form action="{{ route('password.verify') }}" method="POST" style="margin-top: 20px;">
        @csrf
        <input type="hidden" value="{{request()->query('id')}}" name="id">
        <div style="margin-bottom: 15px;">
            <label for="reset_code" style="font-weight: bold;">Enter Reset Code</label>
            <input type="text" name="reset_code" id="reset_code" required 
                style="width: 100%; padding: 10px; border: 1px solid #ccc; border-radius: 5px; margin-top: 5px;">
        </div>
        <button type="submit" 
            style="width: 100%; padding: 10px; background: #28a745; color: white; border: none; border-radius: 5px; cursor: pointer;">
            Verify Code
        </button>
    </form>
    @endif
</div>
@endsection
