@extends('layouts.app')

@section('content')
<div class="container" style="max-width: 500px; margin: auto; padding: 20px; border: 1px solid #ddd; border-radius: 10px; box-shadow: 2px 2px 10px rgba(0, 0, 0, 0.1); background: #fff;">
    <h2 style="text-align: center; margin-bottom: 20px; color: #333;">Reset Password</h2>

    <!-- Success Message -->
    @if(session('success'))
        <div style="background: #d4edda; color: #155724; padding: 10px; border-radius: 5px; margin-bottom: 15px;">
            {{ session('success') }}
        </div>
    @endif

    <!-- Errors -->
    @if($errors->any())
        <div style="background: #f8d7da; color: #721c24; padding: 10px; border-radius: 5px; margin-bottom: 15px;">
            <ul style="margin: 0; padding-left: 20px;">
                @foreach ($errors->all() as $error)
                    <li>{{ $error }}</li>
                @endforeach
            </ul>
        </div>
    @endif

   <form action="{{ route('updatePassword') }}" method="POST" class="mt-4">
        @csrf
        <input type="hidden" name="identifier" value="{{ session('identifier') }}">
        <input type="hidden" name="id" value="{{ request()->query('id') }}">
        <div style="margin-top: 20px; margin-bottom: 15px;">
            <label for="password" style="font-weight: bold;">New Password</label>
            <input type="password" name="password" id="password" required 
                style="width: 100%; padding: 10px; border: 1px solid #ccc; border-radius: 5px; margin-top: 5px;">
        </div>

        <div style="margin-bottom: 15px;">
            <label for="password_confirmation" style="font-weight: bold;">Confirm Password</label>
            <input type="password" name="password_confirmation" id="password_confirmation" required 
                style="width: 100%; padding: 10px; border: 1px solid #ccc; border-radius: 5px; margin-top: 5px;">
        </div>

        <button type="submit" 
            style="width: 100%; padding: 10px; background: #dc3545; color: white; border: none; border-radius: 5px; cursor: pointer;">
            Reset Password
        </button>
    </form>


</div>
@endsection
