@extends('layouts.main')

@section('content')
<?php
    $user = Auth::user();
    $country = strtolower(trim($user->country));
    
    // Currency conversion data
    $currencyData = [
        'kenya' => ['currency' => 'KES', 'exchange' => 1, 'symbol' => 'KSh'],
        'tanzania' => ['currency' => 'TZS', 'exchange' => 20, 'symbol' => 'TSh'],
        'uganda' => ['currency' => 'UGX', 'exchange' => 32, 'symbol' => 'USh'],
        'rwanda' => ['currency' => 'RWF', 'exchange' => 9.8, 'symbol' => 'RF'],
        'south sudan' => ['currency' => 'SSP', 'exchange' => 10, 'symbol' => '£'],
        'ghana' => ['currency' => 'GHS', 'exchange' => 0.089, 'symbol' => 'GH₵'],
        'zambia' => ['currency' => 'ZMW', 'exchange' => 0.19, 'symbol' => 'ZK'],
        'nigeria' => ['currency' => 'NGN', 'exchange' => 5.6, 'symbol' => '₦'],
        'usa' => ['currency' => 'USD', 'exchange' => 0.00769, 'symbol' => '$'],
        'united states' => ['currency' => 'USD', 'exchange' => 0.00769, 'symbol' => '$']
    ];
    
    $currencyInfo = $currencyData[strtolower($country)] ?? $currencyData['kenya'];
    $cashouts = DB::table('cashouts')->where('username', $user->username)->orderBy('created_at', 'desc')->get();
?>
<style>
    :root {
        --primary: #4361ee;
        --primary-light: #eef2ff;
        --secondary: #3a0ca3;
        --success: #4cc9f0;
        --danger: #f72585;
        --warning: #f8961e;
        --dark: #212529;
        --light: #f8f9fa;
        --gray: #6c757d;
    }
    
    .history-container {
        width: 100%;
        padding: 15px;
        margin: 0 auto;
        max-width: 100%;
        box-sizing: border-box;
    }
    
    .history-header {
        text-align: center;
        margin-bottom: 20px;
        padding: 0 10px;
    }
    
    .history-header h2 {
        color: var(--primary);
        font-weight: 700;
        margin-bottom: 5px;
        font-size: 1.5rem;
    }
    
    .history-header p {
        color: var(--gray);
        font-size: 0.9rem;
        margin: 0;
    }
    
    .history-card {
        background: white;
        border-radius: 10px;
        box-shadow: 0 2px 10px rgba(0,0,0,0.05);
        overflow-x: auto;
        -webkit-overflow-scrolling: touch;
    }
    
    .history-table {
        width: 100%;
        min-width: 600px;
        border-collapse: collapse;
    }
    
    .history-table thead {
        background-color: var(--primary-light);
    }
    
    .history-table th {
        padding: 12px 15px;
        text-align: left;
        color: var(--primary);
        font-weight: 600;
        font-size: 0.85rem;
        border-bottom: 2px solid var(--primary);
    }
    
    .history-table td {
        padding: 12px 15px;
        border-bottom: 1px solid #f0f0f0;
        font-size: 0.85rem;
    }
    
    .history-table tr:last-child td {
        border-bottom: none;
    }
    
    .history-table tr:hover {
        background-color: #f9f9f9;
    }
    
    .status-badge {
        display: inline-block;
        padding: 4px 10px;
        border-radius: 20px;
        font-size: 0.75rem;
        font-weight: 600;
        text-transform: capitalize;
    }
    
    .status-pending {
        background-color: #fff3cd;
        color: #856404;
    }
    
    .status-approved {
        background-color: #d4edda;
        color: #155724;
    }
    
    .status-rejected {
        background-color: #f8d7da;
        color: #721c24;
    }
    
    .amount-cell {
        font-weight: 600;
        color: var(--dark);
    }
    
    .empty-state {
        text-align: center;
        padding: 30px 15px;
        color: var(--gray);
    }
    
    .empty-state i {
        font-size: 2.5rem;
        color: #dee2e6;
        margin-bottom: 10px;
    }
    
    .empty-state h4 {
        font-size: 1.1rem;
        margin-bottom: 5px;
    }
    
    .empty-state p {
        font-size: 0.9rem;
        margin: 0;
    }
    
    .method-badge {
        display: inline-block;
        padding: 3px 8px;
        background-color: #e9ecef;
        border-radius: 4px;
        font-size: 0.75rem;
        color: var(--dark);
    }
    
    .date-cell {
        color: var(--gray);
        font-size: 0.8rem;
    }
    
    @media (min-width: 768px) {
        .history-container {
            padding: 20px;
            max-width: 800px;
        }
        
        .history-header h2 {
            font-size: 1.8rem;
        }
        
        .history-header p {
            font-size: 1rem;
        }
        
        .history-card {
            border-radius: 12px;
            box-shadow: 0 4px 20px rgba(0,0,0,0.08);
            overflow-x: visible;
        }
        
        .history-table {
            min-width: auto;
            width: 100%;
        }
        
        .history-table th {
            padding: 15px 20px;
            font-size: 0.9rem;
        }
        
        .history-table td {
            padding: 15px 20px;
            font-size: 0.9rem;
        }
        
        .status-badge {
            padding: 5px 12px;
            font-size: 0.8rem;
        }
        
        .method-badge {
            padding: 4px 10px;
            font-size: 0.8rem;
        }
    }
</style>

<div class="history-container">
    <div class="history-header">
        <h2>Withdrawal History</h2>
        <p>View all your past withdrawal requests</p>
    </div>
    
    <div class="history-card">
        @if($cashouts->count())
            <div style="overflow-x: auto;">
                <table class="history-table">
                    <thead>
                        <tr>
                            <th>Transaction</th>
                            <th>Amount</th>
                            <th>Method</th>
                            <th>Date</th>
                            <th>Status</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach($cashouts as $cashout)
                        <tr>
                            <td>#{{ $cashout->id }}</td>
                            <td class="amount-cell">
                                {{ $currencyInfo['symbol'] }}{{ number_format($cashout->amount * 0.9 * $currencyInfo['exchange'], 2) }}
                                <div class="text-muted" style="font-size:0.75rem;">
                                    {{ number_format($cashout->amount, 2) }} USDT
                                </div>
                            </td>
                            <td>
                                <span class="method-badge">
                                    {{ $cashout->method ?? 'M-PESA' }}
                                </span>
                            </td>
                            <td class="date-cell">
                                {{ \Carbon\Carbon::parse($cashout->created_at)->format('M d, Y H:i') }}
                            </td>
                            <td>
                                <span class="status-badge status-{{ strtolower($cashout->status) }}">
                                    {{ ucfirst($cashout->status) }}
                                </span>
                            </td>
                        </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
        @else
            <div class="empty-state">
                <i class="bi bi-wallet2"></i>
                <h4>No Withdrawals Yet</h4>
                <p>You haven't made any withdrawal requests yet</p>
            </div>
        @endif
    </div>
</div>

<link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.5/font/bootstrap-icons.css" rel="stylesheet">
@endsection