@extends('layouts.main')

@section('content')
<div class="container py-5">
    <div class="text-center mb-5">
        <h2 class="fw-bold">📘 Daily Quiz Tasks</h2>
        <p class="text-info" style="font-size:12px;">Answer questions based on your active investment packages to earn rewards instantly!</p>
    </div>

    @if(session('success'))
        <div class="alert alert-success text-center">{{ session('success') }}</div>
    @endif
    @if(session('error'))
        <div class="alert alert-danger text-center">{{ session('error') }}</div>
    @endif

<form method="POST" action="{{ route('questions.submit') }}">
        @csrf

        @foreach($questionsByPackage as $investmentId => $data)
            <div class="card shadow mb-5 border-0">
                <div class="card-header bg-primary text-white fw-semibold">
                    Package ID: {{ $data['package_id'] }} — Capital: ₦{{ number_format($data['capital'], 2) }}
                </div>
                <div class="card-body">
                    @foreach($data['questions'] as $index => $question)
                        <div class="mb-4">
                            <h5 class="mb-3">Q{{ $index + 1 }}: {{ $question->question_text }}</h5>

                            {{-- Hidden inputs --}}
                            <input type="hidden" name="answers[{{$investmentId}}{{$index}}][package_id]" value="{{ $data['package_id'] }}">
                            <input type="hidden" name="answers[{{$investmentId}}{{$index}}][capital]" value="{{ $data['capital'] }}">
                            <input type="hidden" name="answers[{{$investmentId}}{{$index}}][question_id]" value="{{ $question->id }}">

                            @foreach(['option_a', 'option_b', 'option_c', 'option_d'] as $option)
                                <div class="form-check mb-2">
                                    <input
                                        class="form-check-input"
                                        type="radio"
                                        name="answers[{{$investmentId}}{{$index}}][selected_answer]"
                                        id="q{{ $question->id }}_{{ $option }}"
                                        value="{{ $option }}"
                                        required
                                    >
                                    <label class="form-check-label" for="q{{ $question->id }}_{{ $option }}">
                                        {{ strtoupper(str_replace('option_', '', $option)) }}. {{ $question->$option }}
                                    </label>
                                </div>
                            @endforeach
                        </div>
                        <hr>
                    @endforeach
                </div>
            </div>
        @endforeach

        <div class="text-center">
            <button type="submit" class="btn btn-lg btn-success px-5">
                ✅ Submit Answers & Earn
            </button>
        </div>
    </form>
</div>
@endsection
