@extends('layouts.main')

@section('content')
<?php
$packages = DB::table('packages')->get();
$timezone = config('app.timezone'); // Will return 'Africa/Nairobi' from your .env
$currentTime = now()->setTimezone($timezone)->format('g:i A');
?>
<?php
    $country = Auth::user()->country ?? 'Unknown';

    $countryFlags = [
        'Algeria' => 'dz',
        'Angola' => 'ao',
        'Benin' => 'bj',
        'Botswana' => 'bw',
        'Burkina Faso' => 'bf',
        'Burundi' => 'bi',
        'Cabo Verde' => 'cv',
        'Cameroon' => 'cm',
        'Central African Republic' => 'cf',
        'Chad' => 'td',
        'Comoros' => 'km',
        'Congo (Brazzaville)' => 'cg',
        'Congo (Kinshasa)' => 'cd',
        'Côte d’Ivoire' => 'ci',
        'Djibouti' => 'dj',
        'Egypt' => 'eg',
        'Equatorial Guinea' => 'gq',
        'Eritrea' => 'er',
        'Eswatini' => 'sz',
        'Ethiopia' => 'et',
        'Gabon' => 'ga',
        'Gambia' => 'gm',
        'Ghana' => 'gh',
        'Guinea' => 'gn',
        'Guinea-Bissau' => 'gw',
        'Kenya' => 'ke',
        'Lesotho' => 'ls',
        'Liberia' => 'lr',
        'Libya' => 'ly',
        'Madagascar' => 'mg',
        'Malawi' => 'mw',
        'Mali' => 'ml',
        'Mauritania' => 'mr',
        'Mauritius' => 'mu',
        'Morocco' => 'ma',
        'Mozambique' => 'mz',
        'Namibia' => 'na',
        'Niger' => 'ne',
        'Nigeria' => 'ng',
        'Rwanda' => 'rw',
        'São Tomé and Príncipe' => 'st',
        'Senegal' => 'sn',
        'Seychelles' => 'sc',
        'Sierra Leone' => 'sl',
        'Somalia' => 'so',
        'South Africa' => 'za',
        'South Sudan' => 'ss',
        'Sudan' => 'sd',
        'Tanzania' => 'tz',
        'Togo' => 'tg',
        'Tunisia' => 'tn',
        'Uganda' => 'ug',
        'Zambia' => 'zm',
        'Zimbabwe' => 'zw',
        'Unknown' => 'xx'
    ];

    $code = $countryFlags[$country] ?? 'xx';
?>
<?php
$user = Auth::user();
$country = strtolower(trim($user->country));

// Base currency: KES
$currency = 'KES';
$exchange = 1;
$payTo = '3725674';
$method = 'M-PESA BUY GOODS';
$to = 'BRIAN KIARIE';

// Convert from KES → Local Currency
switch ($country) {
    case 'tanzania':
        $currency = 'TZS';
        $exchange = 20; // 1 KES = 20 TZS
        $payTo = '+255612345678';
        $method = 'Tigo Pesa Tanzania';
        $to = 'TOGO';
        break;

    case 'uganda':
        $currency = 'UGX';
        $exchange = 32; // 1 KES = 32 UGX
        $payTo = '+256772345678';
        $method = 'MTN Uganda';
        $to = '';
        break;

    case 'rwanda':
        $currency = 'RWF';
        $exchange = 9.8;
        $payTo = '+250782334455';
        $method = 'MTN Rwanda';
        $to = 'MTN';
        break;

    case 'botswana':
        $currency = 'BWP';
        $exchange = 0.13;
        $payTo = '+26771234567';
        $method = 'Orange Money Botswana';
        $to = 'ORANGE';
        break;

    case 'south sudan':
        $currency = 'SSP';
        $exchange = 10;
        $payTo = '809856';
        $method = 'Agent ID';
        $to = 'Agent';
        break;

    case 'cameroon':
        $currency = 'XAF';
        $exchange = 4.8;
        $payTo = '+237612345678';
        $method = 'MTN Cameroon';
        $to = 'MTN';
        break;

    case 'west africa':
    case 'cote d’ivoire':
    case 'ivory coast':
        $currency = 'XOF';
        $exchange = 4.7;
        $payTo = '+2250123456789';
        $method = 'Orange Money West Africa';
        $to = 'Orange';
        break;

    case 'ghana':
        $currency = 'GHS';
        $exchange = 0.089;
        $payTo = '+233501234567';
        $method = 'MTN Ghana';
        $to = 'MTN';
        break;

    case 'malawi':
        $currency = 'MWK';
        $exchange = 12.5;
        $payTo = '+265991234567';
        $method = 'Airtel Money Malawi';
        $to = 'Airtel';
        break;

    case 'zambia':
        $currency = 'ZMW';
        $exchange = 0.19;
        $payTo = '+260971234567';
        $method = 'MTN Zambia';
        $to = 'MTN';
        break;

    case 'nigeria':
        $currency = 'NGN';
        $exchange = 5.6;
        $payTo = '+2347012345678';
        $method = 'Bank Transfer Nigeria';
        $to = 'Bank';
        break;

    case 'usa':
    case 'united states':
        $currency = 'USD';
        $exchange = 0.00769; // 1 KES = 0.00769 USD
        $payTo = 'TViTtvuJo2DkABCexampleWallet9876';
        $method = 'USDT (TRC20)';
        $to = 'Binance';
        break;

    // Fallback for unsupported or missing countries
    default:
        $currency = 'KES';
        $exchange = 1;
        $payTo = '3725674';
        $method = 'M-PESA BUY GOODS';
        $to = 'BRIAN KIARIE';
        break;
}

$convertedAmount = number_format(5 * $exchange, 2); // 5 KES converted
?>
<div style="font-family: 'Segoe UI', Roboto, sans-serif; background-color: #1e1e2d; color: #ffffff; height: 105vh; overflow: hidden; position: relative;">

    <!-- Fixed Header -->
    <div style="position: fixed; top: 0; left: 0; right: 0; background-color: #1e1e2d; z-index: 10; border-bottom: 1px solid #2d2d3a; padding: 15px;">
        <div style="max-width: 500px; margin: 0 auto; display: flex; justify-content: space-between; align-items: center;">
            <div style="display: flex; align-items: center;">
                <span style="font-size: 20px; margin-right: 8px;">💰</span>
                <h2 style="margin: 0; font-size: 18px; font-weight: 600; color: #f0f0f0;">{{$currency}} Investment</h2>
            </div>
                <img src="https://flagcdn.com/20x15/{{ $code }}.png" alt="{{ $country }}" width="20" height="13" class="ms-2">
            <span style="font-size: 14px; color: #a0a0a0;">{{ $currentTime }}</span>
        </div>
    </div>

    <!-- Scrollable Content -->
    <div style="position: absolute; top: 66px; bottom: 120px; left: 0; right: 0; overflow-y: auto; padding: 15px;">
        <div style="max-width: 500px; margin: 0 auto;">
@if($errors->any())
    <div class="alert alert-danger alert-message m-2" style="background-color: #f8d7da; border: 1px solid #f5c6cb; color: #721c24; padding: 15px; border-radius: 4px; margin-bottom: 20px; display: flex; align-items: center;">
        <span style="margin-right: 10px; font-size: 20px;">⚠️</span>
        <h4 style="margin: 0; font-size: 16px; font-weight: 600;">{{ $errors->first() }}</h4>
    </div>
@endif

@if (session('success'))
    <div class="alert alert-success alert-message m-2" style="background-color: #d4edda; border: 1px solid #c3e6cb; color: #155724; padding: 15px; border-radius: 4px; margin-bottom: 20px; display: flex; align-items: center;">
        <span style="margin-right: 10px; font-size: 20px;">✅</span>
        <h4 style="margin: 0; font-size: 16px; font-weight: 600;">{!! session('success') !!}</h4>
    </div>
@endif

@if (session('error'))
    <div class="alert alert-danger alert-message m-2" style="background-color: #f8d7da; border: 1px solid #f5c6cb; color: #721c24; padding: 15px; border-radius: 4px; margin-bottom: 20px; display: flex; align-items: center;">
        <span style="margin-right: 10px; font-size: 20px;">⚠️</span>
        <h4 style="margin: 0; font-size: 16px; font-weight: 600;">{!! session('error') !!}</h4>
    </div>
@endif

<script>
    // Auto-hide alert messages after 3 seconds
    setTimeout(() => {
        const alerts = document.querySelectorAll('.alert-message');
        alerts.forEach(alert => {
            alert.style.transition = 'opacity 0.5s ease';
            alert.style.opacity = '0';
            setTimeout(() => alert.remove(), 500); // remove after fade
        });
    }, 3000);
</script>
@foreach($packages as $index => $invest)
@php
    // Define 6 distinct colors for your packages
    $packageColors = [
        ['border' => '#4caf50', 'icon' => '⭐', 'icon_color' => '#4caf50'], // Green
        ['border' => '#2196f3', 'icon' => '🌙', 'icon_color' => '#2196f3'], // Blue
        ['border' => '#ff9800', 'icon' => '🔥', 'icon_color' => '#ff9800'], // Orange
        ['border' => '#9c27b0', 'icon' => '💎', 'icon_color' => '#9c27b0'], // Purple
        ['border' => '#e91e63', 'icon' => '🚀', 'icon_color' => '#e91e63'], // Pink
        ['border' => '#00bcd4', 'icon' => '🌊', 'icon_color' => '#00bcd4']  // Cyan
    ];
    
    // Get color based on index (cycling through the 6 colors)
    $color = $packageColors[$index % count($packageColors)];
    
    $remainingPercentage = 100 - (($invest->days_elapsed ?? 0) / $invest->days * 100);
    $remainingPercentage = max(0, min(100, $remainingPercentage));
    $isTaken = false;
    $recommendedColor = $isTaken ? '#4caf50' : '#ffeb3b';
@endphp

<div class="package-container"
    style=" background: linear-gradient(to left, purple 0%,  #000 100%); border-radius: 10px; padding: 20px; margin-bottom: 15px; border-left: 4px solid {{ $color['border'] }}; position: relative; cursor: pointer;"
    onclick="selectPackage({{ $invest->id }})">

    @if($index === 0)
    <div style="position: absolute; top: -8px; right: 12px; background-color: {{ $recommendedColor }}; color: {{ $isTaken ? 'white' : 'black' }}; font-size: 10px; padding: 2px 8px; border-radius: 10px; font-weight: 600;">
        RECOMMENDED
    </div>
    @endif

    <div style="display: flex; justify-content: space-between; margin-bottom: 8px;">
        <h3 style="margin: 0; font-size: 16px; font-weight: 600; color: #ffffff;">{{ $invest->vip }}</h3>
        <span style="font-size: 14px; color: {{ $color['icon_color'] }};">{{ $color['icon'] }}</span>
    </div>
    <div style="margin-bottom: 8px; display: flex; align-items: center;">
        <span style="font-size: 14px; color: #a0a0a0; margin-right: 6px;">🕒</span>
        <span style="font-size: 14px; color: #a0a0a0;">Period:</span>
        <span style="font-size: 14px; color: #ffffff; font-weight: 500; margin-left: 4px;">{{ $invest->days }} days</span>
    </div>
    <div style="margin-bottom: 8px; display: flex; align-items: center;">
        <span style="font-size: 14px; color: #a0a0a0; margin-right: 6px;">📈</span>
        <span style="font-size: 14px; color: #a0a0a0;">{{ $invest->rates }}% Expected Daily Rate</span>
    </div>
    <div style="margin-bottom: 8px; display: flex; align-items: center;">
        <span style="font-size: 14px; color: #a0a0a0; margin-right: 6px;">💵</span>
        <span style="font-size: 14px; color: #a0a0a0;">Minimum Investment</span>
        <span style="font-size: 14px; color: #ffffff; font-weight: 500; margin-left: 8px;">{{ $invest->price * $exchange }} {{$currency}}</span>
    </div>
    <div style="display: flex; align-items: center;">
        <span style="font-size: 14px; color: #a0a0a0; margin-right: 6px;">📊</span>
        <span style="font-size: 14px; color: #a0a0a0;">Remaining Quota</span>
        <div style="flex-grow: 1; margin-left: 8px;">
            <div style="background-color: #1e1e2d; height: 8px; border-radius: 4px; margin-top: 4px; overflow: hidden;">
                <div style="background-color: {{ $color['border'] }}; width: {{ $remainingPercentage }}%; height: 100%;"></div>
            </div>
        </div>
        <span style="font-size: 12px; color: {{ $color['border'] }}; font-weight: 600; margin-left: 8px; min-width: 30px; text-align: right;">
            {{ round($remainingPercentage) }}%
        </span>
    </div>
</div>
@endforeach

        </div>
    </div>

    <!-- Fixed Confirm Button -->
    <form action="{{ url('package') }}" method="GET" style="width: 100%;">
        <input type="hidden" name="p" id="selectedPackageInput">
        <div style="position: fixed; bottom: 60px; left: 0; right: 0; background-color: #1e1e2d; z-index: 10; border-top: 1px solid #2d2d3a;">
            <div style="padding: 12px 15px;">
                <div style="max-width: 500px; margin: 0 auto;">
                    <button id="confirmButton"
                        style="background-color: #cccccc; color: #666666; border: none; border-radius: 6px; padding: 10px 0; width: 100%; font-size: 16px; font-weight: 600; display: flex; align-items: center; justify-content: center;"
                        disabled>
                        <span style="margin-right: 8px;">✅</span>
                        Confirm
                    </button>
                </div>
            </div>
        </div>
    </form>
</div>

<script>
    let selectedPackageId = null;

    function selectPackage(packageId) {
        document.querySelectorAll('.package-container').forEach(container => {
            container.style.boxShadow = 'none';
        });

        event.currentTarget.style.boxShadow = '0 0 0 2px #4caf50';

        const confirmButton = document.getElementById('confirmButton');
        confirmButton.style.backgroundColor = '#4caf50';
        confirmButton.style.color = 'white';
        confirmButton.style.cursor = 'pointer';
        confirmButton.disabled = false;

        selectedPackageId = packageId;
        document.getElementById('selectedPackageInput').value = packageId;
    }

    document.getElementById('confirmButton').addEventListener('click', function() {
        if (selectedPackageId) {
            // Form will be submitted automatically
        }
    });
</script>
@endsection