<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>{{ env('APP_NAME') }} - Earn by doing simple task  </title>
    
    <!-- Favicon -->
    <link rel="icon" type="image/png" href="{{ asset('public/asset/WhatsApp Image 2025-07-18 at 12.10.58 PM.jpeg') }}">
    
    <!-- Tailwind CSS -->
    <script src="https://cdn.tailwindcss.com"></script>
    
    <!-- Font Awesome for icons -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
</head>
 <script>
        tailwind.config = {
            theme: {
                extend: {
                    colors: {
                        'primary-green': '#4CAF50',
                        'dark-green': '#388E3C',
                        'light-green': '#81C784',
                    }
                }
            }
        }
    </script>
    
<style>

  
  
    
    body {
  margin: 0;
  font-family: 'Arial', sans-serif;
 background: linear-gradient(to left, purple 0%,  #000 100%);

  color: white;
}

.app-container {
  max-width: 400px;
  margin: auto;
  padding-bottom: 100px;
}

.header {
  display: flex;
  align-items: center;
  justify-content: space-between;
  background: #00cc66;
  padding: 10px 15px;
  border-radius: 15px;
  font-size: 18px;
}

.avatar {
  border-radius: 50%;
  width: 40px;
  height: 40px;
}

.translate-btn {
  background-color: #002200;
  color: white;
  border: none;
  padding: 6px 12px;
  border-radius: 10px;
  cursor: pointer;
  font-size: 14px;
}

.banner img {
  width: 100%;
  border-radius: 15px;
  margin: 15px 0;
}

.buttons-row {
  display: flex;
  justify-content: space-around;
  margin-bottom: 20px;
}

.buttons-row button {
  background-color: transparent;
  border: none;
  padding: 10px;
  font-size: 13px;
  border-radius: 12px;
  border:1px solid green;
  color: white;
  font-weight: bold;
  cursor: pointer;
  display: flex;
  flex-direction: column;
  align-items: center;
}

.buttons-row i {
  font-size: 18px;
  margin-bottom: 3px;
}

.bot-card {
  background-color: #003300;
  border-radius: 15px;
  padding: 15px;
  margin: 5px 0;
  box-shadow: 0 0 10px #00ff99;
}

.bot-info {
  display: flex;
  align-items: center;
  gap: 15px;
}

.bot-info img {
  width: 60px;
  height: 60px;
  border-radius: 50%;
}

.invest-btn {
  width: 100%;
  margin-top: 5px;
  background-color: #00ffcc;
  color: black;
  border: none;
  padding: 5px;
  font-weight: bold;
  border-radius: 10px;
  font-size: 12px;
  cursor: pointer;
}

    .bottom-nav {
  display: flex;
  justify-content: space-around;
  align-items: center;
  background-color: #001f00;
 padding: 10px 15px;
  position: fixed;
  bottom: 0;
  width: 100%;
  /*max-width: 400px;*/
  border-top: 1px solid #00ff99;
}

.bottom-nav button {
  background: none;
  border: none;
  color: white;
  font-size: 12px;
  text-align: center;
  cursor: pointer;
}

.bottom-nav i {
  font-size: 20px;
  margin-bottom: 3px;
}

/* Green Icon Styling */
.green-icon {
  color: #00ff99;
  font-size: 20px;
  margin-bottom: 4px;
}

</style>

</style>
<body class="bg-green-50 min-h-screen flex items-center justify-center">
    <div class="w-full max-w-md p-6  rounded-xl shadow-lg" style="background: linear-gradient(to left, purple 0%,  #000 100%);">
        <div class="flex items-center justify-center mb-6 user-header text-white mb-4 p-3 rounded-4" >
          
         <img src="{{ asset('public/assets/WhatsApp Image 2025-08-02 at 16.05.37.jpeg') }}" alt="Avatar" class="avatar me-3 ">
            <div class="text-3xl font-bold text-primary-white">{{env('APP_NAME')}}</div>
        </div>

        <!-- Content from child pages -->
        @yield('content')
    </div>
</body>
</html>