<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>{{env('APP_NAME')}}</title>
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css" rel="stylesheet">
    
    <!-- ✅ Bootstrap 5 CDN -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">

    <!-- ✅ Font Awesome CDN -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    
    <!-- CSS -->
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet" integrity="sha384-QWTKZyjpPEjISv5WaRU9OFeRpok6YctnYmDr5pNlyT2bRjXh0JMhjY6hW+ALEwIH" crossorigin="anonymous">



    <!-- ✅ Custom CSS -->
    <link rel="stylesheet" href="public/assets/css/style.css">
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
            font-family: -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, Oxygen, Ubuntu, Cantarell, 'Open Sans', 'Helvetica Neue', sans-serif;
        }
        
        body {
            background-color: #121212; /* Dark background */
            color: #e0e0e0; /* Light text */
            height: 100vh;
            display: flex;
            flex-direction: column;
        }
        
        .header {
            background-color: #1e1e1e; /* Dark header */
            color: #ffffff;
            padding: 16px 20px;
            text-align: left;
            border-bottom: 1px solid #333;
            display: flex;
            justify-content: space-between;
            align-items: center;
        }
        
        .header-title {
            font-size: 18px;
            font-weight: 600;
            letter-spacing: 0.5px;
        }
        
        .header-icon {
            color: #a0a0a0;
            font-size: 20px;
        }
        
        .university-banner {
            background-color: #8C1515;
            color: white;
            padding: 10px 20px;
            font-size: 16px;
            text-align: center;
            font-weight: bold;
            letter-spacing: 1px;
        }
        
        .subheader-decoration {
            background: linear-gradient(to right, #8C1515, #B1040E);
            height: 4px;
            width: 100%;
        }
        
        .subheader {
            background-color: #1e1e1e;
            color: #e0e0e0;
            padding: 14px 20px;
            font-size: 15px;
            text-align: left;
            font-weight: 500;
            border-bottom: 1px solid #333;
        }
        
        .content {
            flex: 1;
            overflow-y: auto;
            padding: 16px;
            background-color: #121212;
        }
        
        .brand-section {
            margin-bottom: 18px;
            padding-bottom: 12px;
            border-bottom: 1px solid #333;
        }
        
        .brand-name {
            font-weight: 600;
            font-size: 17px;
            margin-bottom: 4px;
            color: #ffffff;
        }
        
        .volume {
            color: #a0a0a0;
            font-size: 13px;
            letter-spacing: 0.3px;
        }
        
        .asset-grid {
            display: grid;
            grid-template-columns: repeat(2, 1fr);
            gap: 14px;
            margin-bottom: 20px;
        }
        
        .asset-card {
            background-color: #1e1e1e;
            border-radius: 10px;
            padding: 16px;
            border: 1px solid #333;
            box-shadow: 0 1px 3px rgba(0,0,0,0.3);
        }
        
        .asset-header {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-bottom: 10px;
        }
        
        .asset-name {
            font-weight: 600;
            font-size: 16px;
            display: flex;
            align-items: center;
            gap: 8px;
            color: #ffffff;
        }
        
        .asset-icon {
            width: 26px;
            height: 26px;
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            color: white;
            font-size: 12px;
            font-weight: bold;
        }
        
        .doge-icon {
            background-color: #cb9800;
            border: 1px solid #b38600;
        }
        
        .eth-icon {
            background-color: #627eea;
            border: 1px solid #4d6bd6;
        }
        
        .xrp-icon {
            background-color: #27a2db;
            border: 1px solid #1d8fc7;
        }
        
        .btc-icon {
            background-color: #f7931a;
            border: 1px solid #e5820d;
        }
        
        .usdc-icon {
            background-color: #2775ca;
            border: 1px solid #1d62b0;
        }
        
        .bnb-icon {
            background-color: #f3ba2f;
            border: 1px solid #e0a91a;
        }
        
        .asset-pair {
            color: #a0a0a0;
            font-size: 14px;
            margin-left: 34px;
            margin-top: -4px;
        }
        
        .asset-price {
            font-size: 17px;
            font-weight: 600;
            margin-bottom: 5px;
            color: #ffffff;
        }
        
        .asset-change {
            color: #34c759;
            font-size: 14px;
            font-weight: 500;
        }
        
        .asset-change.negative {
            color: #ff453a;
        }
        
.footer {
    background-color: #1e1e1e;
    border-top: 1px solid #333;
    display: flex;
    justify-content: space-around;
    padding: 14px 0 2px;
    position: fixed; /* ✅ Change from sticky to fixed */
    bottom: 0;
    left: 0;
    right: 0;
    margin: 0;
    z-index: 1000; /* Ensures it stays above content */
}

        
.footer-item {
    text-align: center;
    font-size: 12px;
    color: #888;
    display: flex;
    flex-direction: column;
    align-items: center;
    gap: 6px;
    transition: color 0.3s ease;
    cursor: pointer;
}

.footer-item i {
    font-size: 22px;
}

.footer-item.active {
    color: #8C1515;
}

.footer-item.active i {
    color: #8C1515;
}

    </style>
    
</head>

<body>
        @yield('content')
<!-- ✅ Footer -->
<div class="footer" id="footer-nav">
    <div class="footer-item" data-href="{{ url('/home') }}">
        <i class="fas fa-home"></i>
        <div>Home</div>
    </div>
    <div class="footer-item" data-href="{{ url('/ordervip') }}">
        <i class="fas fa-chart-pie"></i>
        <div>VIP'S</div>
    </div>
    <div class="footer-item" data-href="{{ url('/video-task') }}">
        <i class="fas fa-exchange-alt"></i>
        <div>Task</div>
    </div>
    <div class="footer-item" data-href="{{ url('/mine') }}">
        <i class="fas fa-user"></i>
        <div>Accounts</div>
    </div>
</div>


<script>
    const bgAudio = document.getElementById('bg-audio');
    const footerItems = document.querySelectorAll('.footer-item');

    footerItems.forEach(item => {
        item.addEventListener('click', () => {
            // Mute audio
            if (bgAudio) bgAudio.muted = true;

            // Remove active from all
            footerItems.forEach(i => i.classList.remove('active'));

            // Add active to clicked
            item.classList.add('active');

            // Navigate
            const url = item.getAttribute('data-href');
            setTimeout(() => {
                window.location.href = url;
            }, 150); // slight delay for effect
        });
    });

    // Unmute audio after load
    window.addEventListener('DOMContentLoaded', () => {
        if (bgAudio) {
            bgAudio.muted = false;
            bgAudio.play().catch(e => console.log("Audio autoplay blocked:", e));
        }

        // Auto-highlight current page
        const currentPath = window.location.pathname;
        footerItems.forEach(item => {
            if (item.getAttribute('data-href') === currentPath) {
                item.classList.add('active');
            } else {
                item.classList.remove('active');
            }
        });
    });
</script>

    
<!-- JS Bundle (includes Popper) -->
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js" integrity="sha384-jl6f8Pv69q5an4+OxXo69y+R7K7DJWw2u3e0gM2xKiU9FxF2vYFVRQql9nbPFSJ0" crossorigin="anonymous"></script>
</body>
</html>