@extends('layouts.main')

@section('content')
<style>
    :root {
        --primary: #4361ee;
        --primary-light: #eef2ff;
        --secondary: #3a0ca3;
        --success: #4cc9f0;
        --danger: #f72585;
        --warning: #f8961e;
        --dark: #212529;
        --light: #f8f9fa;
        --gray: #6c757d;
    }
    
    .password-reset-container {
        max-width: 500px;
        margin: 0 auto;
        padding: 20px;
    }
    
    .password-reset-card {
        background: white;
        border-radius: 12px;
        box-shadow: 0 4px 20px rgba(0,0,0,0.08);
        padding: 30px;
    }
    
    .password-reset-header {
        text-align: center;
        margin-bottom: 30px;
    }
    
    .password-reset-header h2 {
        color: var(--primary);
        font-weight: 700;
        margin-bottom: 10px;
    }
    
    .password-reset-header p {
        color: var(--gray);
        font-size: 0.95rem;
    }
    
    .form-group {
        margin-bottom: 20px;
    }
    
    .form-label {
        display: block;
        margin-bottom: 8px;
        font-weight: 600;
        color: var(--dark);
    }
    
    .form-control {
        width: 100%;
        padding: 12px 15px;
        border: 1px solid #e0e0e0;
        border-radius: 8px;
        font-size: 0.95rem;
        transition: all 0.3s;
    }
    
    .form-control:focus {
        border-color: var(--primary);
        box-shadow: 0 0 0 0.2rem rgba(67, 97, 238, 0.25);
    }
    
    .btn-submit {
        width: 100%;
        padding: 12px;
        background-color: var(--primary);
        color: white;
        border: none;
        border-radius: 8px;
        font-weight: 600;
        font-size: 1rem;
        cursor: pointer;
        transition: all 0.3s;
    }
    
    .btn-submit:hover {
        background-color: var(--secondary);
    }
    
    .alert {
        padding: 15px;
        border-radius: 8px;
        margin-bottom: 20px;
        border-left: 4px solid;
    }
    
    .alert-success {
        background-color: rgba(76, 201, 240, 0.15);
        border-color: var(--success);
        color: #0c5460;
    }
    
    .alert-danger {
        background-color: rgba(247, 37, 133, 0.15);
        border-color: var(--danger);
        color: #721c24;
    }
    
    .password-toggle {
        position: relative;
    }
    
    .password-toggle-icon {
        position: absolute;
        right: 15px;
        top: 50%;
        transform: translateY(-50%);
        cursor: pointer;
        color: var(--gray);
    }
    
    @media (max-width: 576px) {
        .password-reset-container {
            padding: 15px;
        }
        
        .password-reset-card {
            padding: 20px;
        }
    }
</style>

<div class="password-reset-container">
    <div class="password-reset-card">
        <div class="password-reset-header">
            <h2>Reset Password</h2>
            <p>Create a new secure password for your account</p>
        </div>
        
        @if(session('success'))
            <div class="alert alert-success">
                <i class="bi bi-check-circle-fill me-2"></i> {{ session('success') }}
            </div>
        @endif
        
        @if($errors->any())
            <div class="alert alert-danger">
                <i class="bi bi-exclamation-triangle-fill me-2"></i>
                @foreach($errors->all() as $error)
                    <div>{{ $error }}</div>
                @endforeach
            </div>
        @endif
        
        <form method="POST" action="{{ route('password.update') }}">
            @csrf
            
            <div class="form-group">
                <label for="current_password" class="form-label">Current Password</label>
                <div class="password-toggle">
                    <input type="password" id="current_password" name="current_password" class="form-control" required>
                    <i class="bi bi-eye-slash password-toggle-icon" id="toggleCurrentPassword"></i>
                </div>
            </div>
            
            <div class="form-group">
                <label for="new_password" class="form-label">New Password</label>
                <div class="password-toggle">
                    <input type="password" id="new_password" name="new_password" class="form-control" required>
                    <i class="bi bi-eye-slash password-toggle-icon" id="toggleNewPassword"></i>
                </div>
                <small class="text-muted">Minimum 8 characters with at least one number and special character</small>
            </div>
            
            <div class="form-group">
                <label for="new_password_confirmation" class="form-label">Confirm New Password</label>
                <div class="password-toggle">
                    <input type="password" id="new_password_confirmation" name="new_password_confirmation" class="form-control" required>
                    <i class="bi bi-eye-slash password-toggle-icon" id="toggleConfirmPassword"></i>
                </div>
            </div>
            
            <button type="submit" class="btn-submit">
                Update Password
            </button>
        </form>
    </div>
</div>

<script>
    // Toggle password visibility
    document.getElementById('toggleCurrentPassword').addEventListener('click', function() {
        togglePasswordVisibility('current_password', this);
    });
    
    document.getElementById('toggleNewPassword').addEventListener('click', function() {
        togglePasswordVisibility('new_password', this);
    });
    
    document.getElementById('toggleConfirmPassword').addEventListener('click', function() {
        togglePasswordVisibility('new_password_confirmation', this);
    });
    
    function togglePasswordVisibility(inputId, icon) {
        const input = document.getElementById(inputId);
        if (input.type === 'password') {
            input.type = 'text';
            icon.classList.remove('bi-eye-slash');
            icon.classList.add('bi-eye');
        } else {
            input.type = 'password';
            icon.classList.remove('bi-eye');
            icon.classList.add('bi-eye-slash');
        }
    }
</script>

<link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.5/font/bootstrap-icons.css" rel="stylesheet">
@endsection