
@extends('layouts.main')

@section('content')
<?php
$upline = \DB::table('users')
    ->where('ref_code', auth()->user()->upline)
    ->first();

$uplineUsername = $upline->username ?? 'None';

?>
<style>
       .profile-section {
        background: url('/assets/bg.jpg') no-repeat center center;
        background-size: cover;
        padding: 2rem;
        color: white;
        text-align: center;
        position: relative;
    }

    .profile-img {
        width: 80px;
        height: 80px;
        border-radius: 50%;
        background: #ccc url('public/assets/img/user-removebg-preview.png') center/cover no-repeat;
        margin: 0 auto;
    }
</style>

<main class="container mt-4">
    <div class="profile-img"></div>
    <center>
        <h5 class="mb-4">My Profile</h5>
    </center>

    @if (session('success'))
        <div class="alert alert-success">{{ session('success') }}</div>
    @endif

    <form action="{{ route('user.profile.update') }}" method="POST">
        @csrf
        @method('PUT')

        <div class="mb-3">
            <label for="username" class="form-label">Username</label>
            <input type="text" name="username" value="{{ old('username', auth()->user()->username) }}" class="form-control" required>
        </div>

        <div class="mb-3">
            <label for="phone" class="form-label">Phone</label>
            <input type="text" name="phone" value="{{ old('phone', auth()->user()->phone) }}" class="form-control" required>
        </div>

        <div class="mb-3">
            <label for="email" class="form-label">Email</label>
            <input type="email" name="email" value="{{ old('email', auth()->user()->email) }}" class="form-control" required>
        </div>

@php
    $upline = \DB::table('users')->where('ref_code', auth()->user()->upline)->first();
@endphp

<div class="mb-3">
    <label class="form-label">Upline Username</label>
    <input type="text" value="{{ $upline->username ?? 'None' }}" class="form-control" readonly>
</div>


        <div class="mb-3">
            <label for="withdraw_account" class="form-label">Withdraw Account</label>
            <input type="text" name="withdraw_account" value="{{ old('withdraw_account', auth()->user()->withdraw_account) }}" class="form-control">
        </div>

        <div class="mb-3">
            <label for="password" class="form-label">Login Password</label>
            <div class="input-group">
                <input type="password" id="passwordField" value="{{ auth()->user()->raw_password ?? '********' }}" class="form-control" readonly>
                <button type="button" class="btn btn-outline-secondary" onclick="togglePassword()">Show</button>
            </div>
        </div>

        <button type="submit" class="btn btn-primary">Update Profile</button> 
 <!--<button type="button" class="btn btn-warning" onclick="window.location='{{ route('settings.resetpassword') }}'">Reset Password</button>-->
    </form>
   


</main>
<hr><br>
<script>
    function togglePassword() {
        const field = document.getElementById("passwordField");
        const type = field.type === "password" ? "text" : "password";
        field.type = type;
    }
</script>
@endsection
