@extends('layouts.main')

@section('content')
<div class="min-h-screen bg-gray-100 py-10 px-4">
    <div class="max-w-2xl mx-auto bg-white shadow-lg rounded-xl p-6"style="background-image: url('{{ asset('public/assets/img/bg-button.jpeg') }}'); color:#333333;">
        <h2 class="text-2xl font-bold text-center mb-6 text-blue-700">Need Help? Contact Support</h2>

        <div class="space-y-6">
            <!-- WhatsApp Group Support -->
            <div class="border border-green-500 rounded-lg p-4 bg-green-50">
                <h3 class="text-lg font-semibold text-green-700 mb-2">
                    🟢📱 WhatsApp Group
                </h3>
                <p class="text-gray-700 mb-3">Join our official WhatsApp group to get updates and help from community members.</p>
                <a href="{{ env('APP_GROUP') }}" target="_blank" class="inline-block bg-green-600 hover:bg-green-700 text-white px-4 py-2 rounded">
                    Join Group
                </a>
            </div>

            <!-- WhatsApp Agent Support -->
            <div class="border border-blue-500 rounded-lg p-4 bg-blue-50">
                <h3 class="text-lg font-semibold text-blue-700 mb-2">
                    👤🟢 WhatsApp Agent
                </h3>
                <p class="text-gray-700 mb-3">Talk directly to our support agent for any assistance or account issues.</p>
                <a href="{{ env('APP_WHATSAPP') }}" target="_blank" class="inline-block bg-blue-600 hover:bg-blue-700 text-white px-4 py-2 rounded">
                    Message Agent
                </a>
            </div>

            <!-- Email Support -->
            <div class="border border-yellow-500 rounded-lg p-4 bg-yellow-50">
                <h3 class="text-lg font-semibold text-yellow-700 mb-2">
                    ✉️ Email Support
                </h3>
                <p class="text-gray-700 mb-3">Send us an email and we will respond within 24 hours.</p>
                <a href="mailto:{{ env('APP_SUPPORT_EMAIL', 'Starlightassets@gmail.com') }}" class="inline-block bg-yellow-500 hover:bg-yellow-600 text-white px-4 py-2 rounded">
                    Email Us
                </a>
            </div>
        </div>
    </div>
</div>
@endsection
