@extends('layouts.main')
@section('content')
        <!-- Header ends -->
        @php 
        
        // In your controller or wherever you need this query
         $transactions = \DB::table('deposits')
                        ->select('deposits.created_at as date', 'deposits.amount','deposits.status',  \DB::raw("'deposit' as type"))
                        ->where('deposits.username', '=', Auth::user()->id)
                        ->union(
                            \DB::table('cashouts')
                                ->select('cashouts.created_at as date', 'cashouts.amount','cashouts.status', \DB::raw("'cashout' as type"))
                                ->where('cashouts.username', '=', Auth::user()->username)
                        )
                        ->orderBy('date', 'desc') // Order by the 'date' column in descending order
                        ->limit(10045)       // 
                        ->get();

        
        @endphp
        <!-- main page content -->
        <div class="mt-3 container">
            @if($transactions->count() > 0)
                <div class="row mb-3">
                    <div class="col">
                        <h6 class="title">Transactions<br><small class="fw-normal text-muted">Today, {{date("Y-m-d")}}</small></h6>
                    </div>
                    <div class="col-auto align-self-center">
                        <a href="deposit" class="small">Recharge</a>
                    </div>
                </div>
                
                <div class="row mb-4">
                    <div class="col-12">
                        <div class="card">
                            <div class="card-body p-0">
                                <ul class="list-group list-group-flush bg-none">
                                    @foreach($transactions as $trx)
                                        <li class="list-group-item rounded my-1">
                                            <div class="row align-items-center">
                                                <!-- Add a rounded image -->
                                                <div class="col-auto">
                                                    <img src="public/mpesa.png" alt="avatar" class="rounded-circle" width="40" height="40">
                                                </div>
                                                
                                                <div class="col ps-0">
                                                    <p class="text-secondary size-10 mb-0">{{$trx->type}}</p>
                                                    <p>MPESA</p>
                                                </div>
                                                
                                                <div class="col text-end">
                                                    <p class="text-secondary text-muted size-10 mb-0">{{\Carbon\Carbon::parse($trx->date)->addHours(3)->toDayDateTimeString()}}</p>
                                                    <p>
                                                        @if($trx->type == "cashout") 
                                                            <b>-</b> 
                                                        @else
                                                            <b>+</b> 
                                                        @endif
                                                        {{$trx->amount}}
                                                    </p>
                                                    <code><b>{{$trx->status}}</b></code>
                                                </div>
                                            </div>
                                        </li>
                                    @endforeach
                                </ul>
                            </div>
                        </div>
                    </div>
                </div>
                
            @else
                <center>
                    <p>No Transactions yet</p>
                </center>
            @endif
        </div>

        <!-- main page content ends -->
        
      

@endsection