@extends('layouts.main')

@section('content')
<?php
use Carbon\Carbon;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Auth;

$userId = Auth::id();

$deposits = DB::table('deposits')
    ->where('username', $userId)
    ->orderByDesc('created_at')
    ->get();

$cashouts = DB::table('cashouts')
    ->where('phone', $userId)
    ->orderByDesc('created_at')
    ->get();

$invests = DB::table('invest')
    ->where('user_id', $userId)
    ->orderByDesc('created_at')
    ->get();

$user = Auth::user();
$countryCode = $user->country ?? '';

if ($countryCode == 'Kenya') {
    $conversionRate = 130;
    $currency = 'KES';
} elseif ($countryCode == 'Zambia') {
    $conversionRate = 25;
    $currency = 'ZMW';
} elseif ($countryCode == 'Tanzania') {
    $conversionRate = 2575;
    $currency = 'TZS';
} elseif ($countryCode == 'Ghana') {
    $conversionRate = 11;
    $currency = 'GHS';
} elseif ($countryCode == 'Uganda') {
    $conversionRate = 3560;
    $currency = 'UGX';
} elseif ($countryCode == 'South Sudan') {
    $conversionRate = 4512;
    $currency = 'SSP';
} else {
    $conversionRate = 1;
    $currency = 'USD';
}

$convertedBalance = $user->balance / $conversionRate;
$min = 1 * $conversionRate;
?>

<?php
$user = Auth::user();
$country = strtolower(trim($user->country));

// Base currency: KES
$currency = 'KES';
$exchange = 1;
$payTo = '3725674';
$method = 'M-PESA BUY GOODS';
$to = 'BRIAN KIARIE';

// Convert from KES → Local Currency
switch ($country) {
    case 'tanzania':
        $currency = 'TZS';
        $exchange = 20; // 1 KES = 20 TZS
        $payTo = '+255612345678';
        $method = 'Tigo Pesa Tanzania';
        $to = 'TOGO';
        break;

    case 'uganda':
        $currency = 'UGX';
        $exchange = 32; // 1 KES = 32 UGX
        $payTo = '+256772345678';
        $method = 'MTN Uganda';
        $to = '';
        break;

    case 'rwanda':
        $currency = 'RWF';
        $exchange = 9.8;
        $payTo = '+250782334455';
        $method = 'MTN Rwanda';
        $to = 'MTN';
        break;

    case 'botswana':
        $currency = 'BWP';
        $exchange = 0.13;
        $payTo = '+26771234567';
        $method = 'Orange Money Botswana';
        $to = 'ORANGE';
        break;

    case 'south sudan':
        $currency = 'SSP';
        $exchange = 10;
        $payTo = '809856';
        $method = 'Agent ID';
        $to = 'Agent';
        break;

    case 'cameroon':
        $currency = 'XAF';
        $exchange = 4.8;
        $payTo = '+237612345678';
        $method = 'MTN Cameroon';
        $to = 'MTN';
        break;

    case 'west africa':
    case 'cote d’ivoire':
    case 'ivory coast':
        $currency = 'XOF';
        $exchange = 4.7;
        $payTo = '+2250123456789';
        $method = 'Orange Money West Africa';
        $to = 'Orange';
        break;

    case 'ghana':
        $currency = 'GHS';
        $exchange = 0.089;
        $payTo = '+233501234567';
        $method = 'MTN Ghana';
        $to = 'MTN';
        break;

    case 'malawi':
        $currency = 'MWK';
        $exchange = 12.5;
        $payTo = '+265991234567';
        $method = 'Airtel Money Malawi';
        $to = 'Airtel';
        break;

    case 'zambia':
        $currency = 'ZMW';
        $exchange = 0.19;
        $payTo = '+260971234567';
        $method = 'MTN Zambia';
        $to = 'MTN';
        break;

    case 'nigeria':
        $currency = 'NGN';
        $exchange = 5.6;
        $payTo = '+2347012345678';
        $method = 'Bank Transfer Nigeria';
        $to = 'Bank';
        break;

    case 'usa':
    case 'united states':
        $currency = 'USD';
        $exchange = 0.00769; // 1 KES = 0.00769 USD
        $payTo = 'TViTtvuJo2DkABCexampleWallet9876';
        $method = 'USDT (TRC20)';
        $to = 'Binance';
        break;

    // Fallback for unsupported or missing countries
    default:
        $currency = 'KES';
        $exchange = 1;
        $payTo = '3725674';
        $method = 'M-PESA BUY GOODS';
        $to = 'BRIAN KIARIE';
        break;
}

$convertedAmount = number_format(5 * $exchange, 2); // 5 KES converted
?>

<style>
    .section-title {
        font-weight: bold;
        font-size: 1.2rem;
        margin: 1rem 0 0.5rem;
        background-color: #00ffcc;
        color: #333;
        border-left: 4px solid #0f9d58;
        padding-left: 0.5rem;
    }

    .transaction-container {
        border: 1px solid #e1e1e1;
        border-radius: 8px;
        margin-bottom: 2rem;
        background-color: #fff;
        box-shadow: 0 0 10px #00ff99;
        padding: 10px;
    }

    .transaction-row {
        display: grid;
        grid-template-columns: repeat(6, minmax(80px, 1fr));
        font-size: 0.85rem;
        padding: 8px;
        border-bottom: 1px solid #f0f0f0;
        align-items: center;
        color: #fff;
    }

    .transaction-header {
        font-weight: 600;
        background-color: #f8f8f8;
        color: #222;
    }

    .no-record {
        text-align: center;
        padding: 10px;
        color: #999;
        font-size: 0.9rem;
    }

    @media (max-width: 576px) {
        .transaction-row {
            font-size: 0.72rem;
            grid-template-columns: repeat(6, minmax(70px, 1fr));
        }
    }
</style>
<style>
    .card {background-color: #002b2b; border:1px solid #00ff99; border-radius:12px;}
    table {width:100%; border-collapse:collapse; color:white;}
    th, td {padding:10px; border-bottom:1px solid #006655;}
    th {background:#fff; color:black;}
    tr:nth-child(even) {background:#003333;}
    .status {padding:5px 10px; border-radius:8px; font-weight:bold;}
    .pending {background:red; color:white;}
    .successful {background:green; color:white;}
</style>
<main class="container mt-4">

       

        @php
        $deposits = DB::table('deposits')
            ->where('phone', Auth::user()->phone)
            ->orderBy('created_at', 'desc')
            ->get();
        @endphp
        
        
        
        <div class="container p-2">
            <div class="card p-0">
                <div class="section-title">Deposit History</div>
                
                @if($deposits->count())
                <table>
                    <thead>
                        <tr>
                            <th>ID</th>
                            <th>Amount</th>
                            <th>Date</th>
                            <th>Status</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach($deposits as $deposit)
                        <tr>
                            <td>{{ $deposit->id }}</td>
                            <td>{{ number_format($deposit->amount * $exchange, 2) }}</td>
                            <td style="font-size:14px;">{{ \Carbon\Carbon::parse($deposit->created_at)->format('Y-m-d H:i') }}</td>
                            <td><span class="status {{ strtolower($deposit->status) }}"style="font-size:14px;">{{ ucfirst($deposit->status) }}</span></td>
                        </tr>
                        @endforeach
                    </tbody>
                </table>
                @else
                <div class="text-center text-white py-3">No deposit records found.</div>
                @endif
            </div>
        </div>
  

      
<div class="container p-2">
    <div class="card p-0">
         <div class="section-title">Withdrawal History</div>
        <?php
        
           $cashouts = DB::table('cashouts')->where('username', Auth::user()->username)->get();
        ?>
        @if($cashouts->count())
        <table>
            <thead>
                <tr>
                    <th>ID</th>
                    <th>Amount</th>
                    <th>Date</th>
                    <th>Status</th>
                </tr>
            </thead>
            <tbody>
                 @foreach ($cashouts as $index => $c)
                <tr>
                    <td>{{ $c->id }}</td>
                    <td>{{ number_format($c->amount * $exchange, 2) }}</td>
                    <td style="font-size:14px;">{{ \Carbon\Carbon::parse($c->created_at)->format('Y-m-d H:i') }}</td>
                    <td><span class="status {{ strtolower($c->status) }}"style="font-size:14px;">{{ ucfirst($c->status) }}</span></td>
                </tr>
                @endforeach
            </tbody>
        </table>
        @else
        <div class="text-center text-white py-3">No Cashout records found.</div>
        @endif
    </div>
</div>
   

    <div class="container p-2">
        <div class="card p-0">
        <div class="section-title">Investment History</div>
        <div class="transaction-row transaction-header">
            <div>Period</div>
            <div>Capital</div>
            <div>Returns</div>
            <div>Next Pay</div>
        </div>
        @forelse ($invests as $i)
            <div class="transaction-row">
                <div>{{ $i->period }} days</div>
                <div>{{ $currency }} {{ number_format($i->capital  *$exchange, 0) }}</div>
                <div>{{ $currency }} {{ number_format($i->returns *$exchange, 0) }}</div>
                @php
                    $now = Carbon::now();
                    $next = Carbon::parse($i->next_payment);
                    $remainingSeconds = $now->diffInSeconds($next, false);
                @endphp
                <div>
                    <span class="countdown" data-seconds="{{ max(0, $remainingSeconds) }}">
                        Loading...
                    </span>
                </div>
            </div>
        @empty
            <div class="no-record">No investments found.</div>
        @endforelse
    </div>
</div>
    <hr>
</main>

<script>
    document.addEventListener("DOMContentLoaded", function () {
        const countdowns = document.querySelectorAll(".countdown");

        countdowns.forEach(el => {
            let secondsLeft = parseInt(el.dataset.seconds);

            function updateCountdown() {
                if (secondsLeft <= 0) {
                    el.innerHTML = "Processing...";
                    return;
                }

                const hours = Math.floor(secondsLeft / 3600);
                const minutes = Math.floor((secondsLeft % 3600) / 60);
                const seconds = secondsLeft % 60;

                el.innerHTML = `${hours.toString().padStart(2, '0')}h ${minutes.toString().padStart(2, '0')}m ${seconds.toString().padStart(2, '0')}s`;

                secondsLeft--;
                setTimeout(updateCountdown, 1000);
            }

            updateCountdown();
        });
    });
</script>
@endsection
