@extends('layouts.admins')

@section('content')
<?php
$user = Auth::user();
$country = strtolower(trim($user->country));

// Base currency: KES
$currency = 'KES';
$exchange = 1;
$payTo = '3725674';
$method = 'M-PESA BUY GOODS';
$to = 'BRIAN KIARIE';

// Convert from KES → Local Currency
switch ($country) {
    case 'tanzania':
        $currency = 'TZS';
        $exchange = 20; // 1 KES = 20 TZS
        $payTo = '+255612345678';
        $method = 'Tigo Pesa Tanzania';
        $to = 'TOGO';
        break;

    case 'uganda':
        $currency = 'UGX';
        $exchange = 32; // 1 KES = 32 UGX
        $payTo = '+256772345678';
        $method = 'MTN Uganda';
        $to = '';
        break;

    case 'rwanda':
        $currency = 'RWF';
        $exchange = 9.8;
        $payTo = '+250782334455';
        $method = 'MTN Rwanda';
        $to = 'MTN';
        break;

    case 'botswana':
        $currency = 'BWP';
        $exchange = 0.13;
        $payTo = '+26771234567';
        $method = 'Orange Money Botswana';
        $to = 'ORANGE';
        break;

    case 'south sudan':
        $currency = 'SSP';
        $exchange = 10;
        $payTo = '809856';
        $method = 'Agent ID';
        $to = 'Agent';
        break;

    case 'cameroon':
        $currency = 'XAF';
        $exchange = 4.8;
        $payTo = '+237612345678';
        $method = 'MTN Cameroon';
        $to = 'MTN';
        break;

    case 'west africa':
    case 'cote d’ivoire':
    case 'ivory coast':
        $currency = 'XOF';
        $exchange = 4.7;
        $payTo = '+2250123456789';
        $method = 'Orange Money West Africa';
        $to = 'Orange';
        break;

    case 'ghana':
        $currency = 'GHS';
        $exchange = 0.089;
        $payTo = '+233501234567';
        $method = 'MTN Ghana';
        $to = 'MTN';
        break;

    case 'malawi':
        $currency = 'MWK';
        $exchange = 12.5;
        $payTo = '+265991234567';
        $method = 'Airtel Money Malawi';
        $to = 'Airtel';
        break;

    case 'zambia':
        $currency = 'ZMW';
        $exchange = 0.19;
        $payTo = '+260971234567';
        $method = 'MTN Zambia';
        $to = 'MTN';
        break;

    case 'nigeria':
        $currency = 'NGN';
        $exchange = 5.6;
        $payTo = '+2347012345678';
        $method = 'Bank Transfer Nigeria';
        $to = 'Bank';
        break;

    case 'usa':
    case 'united states':
        $currency = 'USD';
        $exchange = 0.00769; // 1 KES = 0.00769 USD
        $payTo = 'TViTtvuJo2DkABCexampleWallet9876';
        $method = 'USDT (TRC20)';
        $to = 'Binance';
        break;

    // Fallback for unsupported or missing countries
    default:
        $currency = 'KES';
        $exchange = 1;
        $payTo = '3725674';
        $method = 'M-PESA BUY GOODS';
        $to = 'BRIAN KIARIE';
        break;
}

$convertedAmount = number_format(5 * $exchange, 2); // 5 KES converted
?>

<center><b>All Deposits</b></center>
<div class="card mb-4">
    <div class="card-header">
        <i class="fas fa-table me-1"></i>
        Deposit Management
    </div>
    <div class="card-body">
        <div style="overflow-x: auto;">
            <table id="datatablesSimple" class="table table-striped table-bordered">
                <thead>
                    <tr>
                        <th>ID</th>
                        <th>Phone</th>
                        <th>Method</th>
                        <th>Image</th>
                        <th>Email</th>
                        <th>Amount</th>
                        <th>Status</th>
                        <th>Transaction</th>
                        <th>Time</th>
                        <th>Actions</th>
                    </tr>
                </thead>
                <tbody>
                    
                                     
                   @foreach (DB::table('deposits')->where('status', 'Unpaid')->paginate(10) as $deposit)
 
                    <tr id="deposit-row-{{ $deposit->id }}">
                        <td>{{ $deposit->id }}</td>
                        <td>{{ $deposit->phone }}</td>
                        <td>{{ $deposit->method }}</td>
                        <td>
                            @if ($deposit->images)
                         <a href="javascript:void(0)" onclick="viewImage('{{ asset('public/deposit_screenshots/' . $deposit->images) }}')">
                                <img src="{{ asset('public/deposit_screenshots/' . $deposit->images) }}" 
                                     alt="Deposit Image" 
                                     style="width: 50px; height: 50px; cursor: pointer;">
                            </a>


                            @else
                            N/A
                            @endif
                        </td>
                        <td>{{ $deposit->email }}</td>
                        <td>{{ $deposit->amount *$exchange}}</td>
                        <td id="status-{{ $deposit->id }}">{{ $deposit->status }}</td>
                        <td>{{ $deposit->transaction }}</td>
                        <td>{{ $deposit->created_at }}</td>
                        <td>
                            <button onclick="approveDeposit({{ $deposit->id }})" class="btn btn-success" id="approve-btn-{{ $deposit->id }}">Approve</button>
                            <button onclick="rejectDeposit({{ $deposit->id }})" class="btn btn-danger" id="reject-btn-{{ $deposit->id }}">Reject</button>
                        </td>
                    </tr>
                    @endforeach
                </tbody>
            </table>
        </div>

        <!-- Pagination Links -->
        <div class="mt-3">
            {{ DB::table('deposits')->paginate(10)->links('pagination::bootstrap-5') }}
        </div>
    </div>
</div>

<!-- Image Modal -->
<div class="modal fade" id="imageModal" tabindex="-1" aria-labelledby="imageModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="imageModalLabel">View Image</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body text-center">
                <img id="modalImage" src="" alt="Deposit Image" style="max-width: 100%; height: auto;">
            </div>
        </div>
    </div>
</div>

<script>
    // View Image in Modal
    function viewImage(imageUrl) {
        const modalImage = document.getElementById('modalImage');
        modalImage.src = imageUrl;
        const imageModal = new bootstrap.Modal(document.getElementById('imageModal'));
        imageModal.show();
    }

    // Approve Deposit
    function approveDeposit(depositId) {
        if (confirm('Are you sure you want to approve this deposit?')) {
            fetch('{{ route("deposit.approve") }}', {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json',
                    'X-CSRF-TOKEN': '{{ csrf_token() }}'
                },
                body: JSON.stringify({ deposit_id: depositId })
            })
            .then(response => response.json())
            .then(data => {
                if (data.success) {
                    document.getElementById(`status-${depositId}`).innerText = 'approved';
                    alert(data.message);
                } else {
                    alert(data.message);
                }
            })
            .catch(error => console.error('Error:', error));
        }
    }

    // Reject Deposit
    function rejectDeposit(depositId) {
        if (confirm('Are you sure you want to reject this deposit?')) {
            fetch('{{ route("deposit.reject") }}', {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json',
                    'X-CSRF-TOKEN': '{{ csrf_token() }}'
                },
                body: JSON.stringify({ deposit_id: depositId })
            })
            .then(response => response.json())
            .then(data => {
                if (data.success) {
                    document.getElementById(`status-${depositId}`).innerText = 'rejected';
                    alert(data.message);
                } else {
                    alert(data.message);
                }
            })
            .catch(error => console.error('Error:', error));
        }
    }
</script>

<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
@endsection
