@extends('layouts.main')

@section('content')



<?php

// Fetch and count Level 1 downlines (direct referrals)
$firstLevelDownlines = DB::table('users')
    ->where('upline', Auth::user()->ref_code)
    ->get();
$firstLevelCount = $firstLevelDownlines->count();

// Collect IDs and referral codes of Level 1 downlines
$firstLevelIds = $firstLevelDownlines->pluck('id');
$firstLevelRefCodes = $firstLevelDownlines->pluck('ref_code');

// Initialize arrays for counts and bonuses
$secondLevelCounts = [];
$thirdLevelCounts = [];
$levelBonuses = [];

// Process Level 1 downlines
$secondLevelDownlines = DB::table('users')
    ->whereIn('upline', $firstLevelRefCodes)
    ->get();
$secondLevelCount = $secondLevelDownlines->count();

$secondLevelIds = $secondLevelDownlines->pluck('id');
$secondLevelRefCodes = $secondLevelDownlines->pluck('ref_code');

// Process Level 2 downlines
$thirdLevelDownlines = DB::table('users')
    ->whereIn('upline', $secondLevelRefCodes)
    ->get();
$thirdLevelCount = $thirdLevelDownlines->count();

$thirdLevelIds = $thirdLevelDownlines->pluck('id');

// Calculate bonuses for Level 2 and Level 3
$totalBonusLevel2 = DB::table('invest')
    ->whereIn('user_id', $secondLevelIds)
    ->sum('upline_bonus');

$totalBonusLevel3 = DB::table('invest')
    ->whereIn('user_id', $thirdLevelIds)
    ->sum('upline_bonus');

// Fetch total upline bonuses for Level 1
$totalUplineBonus = DB::table('invest')
    ->whereIn('user_id', $firstLevelIds)
    ->sum('upline_bonus');

$countDownline =$firstLevelCount + $secondLevelCount + $thirdLevelCount;
$totaDownlinesBonuses = $totalUplineBonus + $totalBonusLevel2 + $totalBonusLevel3;

// Fetch investments for Level 1
$totalInvestLevel1 = DB::table('invest')
    ->whereIn('user_id', $firstLevelIds)
    ->sum('capital');

// Fetch investments for Level 2
$totalInvestLevel2 = DB::table('invest')
    ->whereIn('user_id', $secondLevelIds)
    ->sum('capital');

// Fetch investments for Level 3
$totalInvestLevel3 = DB::table('invest')
    ->whereIn('user_id', $thirdLevelIds)
    ->sum('capital');

// Fetch withdrawals for Level 1
$totalWithdrawalsLevel1 = DB::table('cashouts')
    ->whereIn('phone', $firstLevelIds)
    ->sum('amount'); // Adjust 'amount' if the column name is different

// Fetch withdrawals for Level 2
$totalWithdrawalsLevel2 = DB::table('cashouts')
    ->whereIn('phone', $secondLevelIds)
    ->sum('amount'); // Adjust 'amount' if the column name is different

// Fetch withdrawals for Level 3
$totalWithdrawalsLevel3 = DB::table('cashouts')
    ->whereIn('phone', $thirdLevelIds)
    ->sum('amount'); // Adjust 'amount' if the column name is different

?>

    <style>
        /* Base dark theme styles */
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
            font-family: -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, Oxygen, Ubuntu, Cantarell, 'Open Sans', 'Helvetica Neue', sans-serif;
        }
        
        body {
            background-color: #121212;
            color: #e0e0e0;
            height: 100vh;
            display: flex;
            flex-direction: column;
        }
        
        .header {
            background-color: #1e1e1e;
            color: #ffffff;
            padding: 16px 20px;
            text-align: left;
            border-bottom: 1px solid #333;
        }
        
        .content {
            flex: 1;
            overflow-y: auto;
            padding: 16px;
            background-color: #121212;
        }
        
        h1 {
            font-size: 22px;
            margin-bottom: 10px;
            color: #ffffff;
        }
        
        h2 {
            font-size: 18px;
            margin: 15px 0 10px;
            color: #e0e0e0;
        }
        
        .section {
            background-color: #1e1e1e;
            border-radius: 10px;
            padding: 15px;
            margin-bottom: 15px;
            border: 1px solid #333;
        }
        
        .stats-grid {
            display: grid;
            grid-template-columns: 1fr 1fr;
            gap: 15px;
            margin-bottom: 15px;
        }
        
        .stat-item {
            text-align: center;
        }
        
        .stat-value {
            font-size: 20px;
            font-weight: 600;
            color: #ffffff;
            margin-bottom: 5px;
        }
        
        .stat-label {
            color: #a0a0a0;
            font-size: 14px;
        }
        
        .generation-title {
            font-weight: 600;
            margin-bottom: 10px;
            color: #ffffff;
        }
        
        table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 10px;
        }
        
        th, td {
            padding: 10px;
            text-align: left;
            border-bottom: 1px solid #333;
            font-size: 14px;
        }
        
        th {
            color: #a0a0a0;
            font-weight: normal;
        }
        
        td {
            color: #ffffff;
        }
        
        .footer {
            background-color: #1e1e1e;
            border-top: 1px solid #333;
            display: flex;
            justify-content: space-around;
            padding: 14px 0 10px;
        }
        
        .footer-item {
            text-align: center;
            font-size: 12px;
            color: #a0a0a0;
            display: flex;
            flex-direction: column;
            align-items: center;
            gap: 6px;
        }
        
        .footer-item i {
            font-size: 22px;
        }
        
        .footer-item.active {
            color: #8C1515;
        }
        
        .footer-item.active i {
            color: #8C1515;
        }
    </style>

    <div class="header">
        <h1>Community team</h1>
    </div>
    
    <div class="content">
        <h2>Full revenue</h2>
        <div class="section">
            <div class="stats-grid">
                <div class="stat-item">
                    <div class="stat-value">0</div>
                    <div class="stat-label">Number of users</div>
                </div>
                <div class="stat-item">
                    <div class="stat-value">$0</div>
                    <div class="stat-label">Cumulative NFT Invest</div>
                </div>
                <div class="stat-item">
                    <div class="stat-value">$0</div>
                    <div class="stat-label">Cumulative earnings</div>
                </div>
                <div class="stat-item">
                    <div class="stat-value">$0</div>
                    <div class="stat-label">Cumulative NFT withdrawal</div>
                </div>
            </div>
        </div>
        
        <div class="section">
            <div class="generation-title">Added people: 0</div>
            <div class="stat-item" style="text-align: left;">
                <div class="stat-label">Added income</div>
                <div class="stat-value">$0</div>
            </div>
        </div>
        
        <div class="section">
            <div class="generation-title">Three generations data</div>
            <table>
                <tr>
                    <th>First generation data</th>
                    <th>Number of users</th>
                    <th>Cumulative recharge</th>
                    <th>Cumulative withdrawal</th>
                    <th>Cumulative earnings</th>
                </tr>
                <tr>
                    <td>0/0</td>
                    <td>$0</td>
                    <td>$0</td>
                    <td>$0</td>
                </tr>
            </table>
        </div>
        
        <div class="section">
            <div class="generation-title">Second generation data</div>
            <table>
                <tr>
                    <th>Number of users</th>
                    <th>Cumulative recharge</th>
                    <th>Cumulative withdrawal</th>
                    <th>Cumulative earnings</th>
                </tr>
                <tr>
                    <td>0/0</td>
                    <td>$0</td>
                    <td>$0</td>
                    <td>$0</td>
                </tr>
            </table>
        </div>
        
        <div class="section">
            <div class="generation-title">Third generation data</div>
            <table>
                <tr>
                    <th>Number of users</th>
                    <th>Cumulative recharge</th>
                    <th>Cumulative withdrawal</th>
                    <th>Cumulative earnings</th>
                </tr>
                <tr>
                    <td>0/0</td>
                    <td>$0</td>
                    <td>$0</td>
                    <td>$0</td>
                </tr>
            </table>
        </div>
    </div>
    
    
  

<!-- Copy to Clipboard Script -->
<script>
    function copyToClipboard() {
        var copyText = document.getElementById("inviteLink");
        copyText.select();
        copyText.setSelectionRange(0, 99999);
        document.execCommand("copy");
        alert("Copied: " + copyText.value);
    }
</script>
@endsection
