@extends('layouts.admins')
@section('content')
<?php
$user = Auth::user();
$country = strtolower(trim($user->country));

// Base currency: KES
$currency = 'KES';
$exchange = 1;
$payTo = '3725674';
$method = 'M-PESA BUY GOODS';
$to = 'BRIAN KIARIE';

// Convert from KES → Local Currency
switch ($country) {
    case 'tanzania':
        $currency = 'TZS';
        $exchange = 20; // 1 KES = 20 TZS
        $payTo = '+255612345678';
        $method = 'Tigo Pesa Tanzania';
        $to = 'TOGO';
        break;

    case 'uganda':
        $currency = 'UGX';
        $exchange = 32; // 1 KES = 32 UGX
        $payTo = '+256772345678';
        $method = 'MTN Uganda';
        $to = '';
        break;

    case 'rwanda':
        $currency = 'RWF';
        $exchange = 9.8;
        $payTo = '+250782334455';
        $method = 'MTN Rwanda';
        $to = 'MTN';
        break;

    case 'botswana':
        $currency = 'BWP';
        $exchange = 0.13;
        $payTo = '+26771234567';
        $method = 'Orange Money Botswana';
        $to = 'ORANGE';
        break;

    case 'south sudan':
        $currency = 'SSP';
        $exchange = 10;
        $payTo = '809856';
        $method = 'Agent ID';
        $to = 'Agent';
        break;

    case 'cameroon':
        $currency = 'XAF';
        $exchange = 4.8;
        $payTo = '+237612345678';
        $method = 'MTN Cameroon';
        $to = 'MTN';
        break;

    case 'west africa':
    case 'cote d’ivoire':
    case 'ivory coast':
        $currency = 'XOF';
        $exchange = 4.7;
        $payTo = '+2250123456789';
        $method = 'Orange Money West Africa';
        $to = 'Orange';
        break;

    case 'ghana':
        $currency = 'GHS';
        $exchange = 0.089;
        $payTo = '+233501234567';
        $method = 'MTN Ghana';
        $to = 'MTN';
        break;

    case 'malawi':
        $currency = 'MWK';
        $exchange = 12.5;
        $payTo = '+265991234567';
        $method = 'Airtel Money Malawi';
        $to = 'Airtel';
        break;

    case 'zambia':
        $currency = 'ZMW';
        $exchange = 0.19;
        $payTo = '+260971234567';
        $method = 'MTN Zambia';
        $to = 'MTN';
        break;

    case 'nigeria':
        $currency = 'NGN';
        $exchange = 5.6;
        $payTo = '+2347012345678';
        $method = 'Bank Transfer Nigeria';
        $to = 'Bank';
        break;

    case 'usa':
    case 'united states':
        $currency = 'USD';
        $exchange = 0.00769; // 1 KES = 0.00769 USD
        $payTo = 'TViTtvuJo2DkABCexampleWallet9876';
        $method = 'USDT (TRC20)';
        $to = 'Binance';
        break;

    // Fallback for unsupported or missing countries
    default:
        $currency = 'KES';
        $exchange = 1;
        $payTo = '3725674';
        $method = 'M-PESA BUY GOODS';
        $to = 'BRIAN KIARIE';
        break;
}

$convertedAmount = number_format(5 * $exchange, 2); // 5 KES converted
?>
<center><b>Active Users</b></center>

<div class="card mb-4">
    <div class="card-header">
        <i class="fas fa-table me-1"></i>
        DataTable Example
    </div>

    <div class="card-body">
        <table id="datatablesSimple">
            <thead>
                <tr>
                    <th>Id</th>
                    <th>Name</th>
                    <th>Phone</th>
                    <th>Balance</th>
                    <th>Invest</th>
                    <th>CashOut</th>
                    <th>Edit</th>
                </tr>
            </thead>
         
            <tbody>
                <?php
                
           $totalmembers = DB::table('users')->where('investments', '=<', 0)->paginate(10);
                ?>
                @foreach ($totalmembers as $user)
                <tr>
                    <td>{{ $user->id }}</td>
                    <td>{{ $user->email }}</td>
                    <td>{{ $user->phone }}</td>
                    <td>{{ $user->balance * $exchange}}</td>
                    <td>{{ $user->investments * $exchange}}</td> 
                    <td>{{ $user->cashouts * $exchange}}</td>
                    <td>
                        <button class="btn btn-primary btn-sm" data-bs-toggle="modal" data-bs-target="#editUserModal{{ $user->id }}">Edit</button>
                    </td>
                </tr>

                <!-- Edit User Modal -->
                <div class="modal fade" id="editUserModal{{ $user->id }}" tabindex="-1" aria-labelledby="editUserModalLabel" aria-hidden="true">
                    <div class="modal-dialog">
                        <div class="modal-content">
                            <form action="{{ route('admin.updateUser', $user->id) }}" method="POST">
                                @csrf
                                <div class="modal-header">
                                    <h5 class="modal-title" id="editUserModalLabel">Edit User</h5>
                                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                </div>
                                <div class="modal-body">
                                    <div class="mb-3">
                                        <label for="Email" class="form-label">Email</label>
                                        <input type="text" class="form-control" id="email" name="email" value="{{ $user->email }}">
                                    </div>
                                    <div class="mb-3">
                                        <label for="phone" class="form-label">Phone</label>
                                        <input type="text" class="form-control" id="phone" name="phone" value="{{ $user->phone }}">
                                    </div>
                                    <div class="mb-3">
                                        <label for="balance" class="form-label">Balance</label>
                                        <input type="text" class="form-control" id="balance" name="balance" value="{{ $user->balance * $exchange }}">
                                    </div>
                                </div>
                                <div class="modal-footer">
                                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                                    <button type="submit" class="btn btn-primary">Save changes</button>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
                @endforeach
            </tbody>
        </table>

        <!-- Pagination Links -->
        <div class="mt-3">
            {{ $totalmembers->links() }}
        </div>
    </div>
</div>

@endsection
