@extends('layouts.main')

@section('content')

@php
$jobs = DB::table('invest')->where('user_id', Auth::user()->id)->get();
@endphp
<br />

<div class="card">
  <div class="card-header">
      <h2 class="text-center">Job Levels Subscribed</h2>
  </div>
  <div class="table-responsive px-0">
    <table class="table table-bordered table-striped" >
        <thead class="table-dark">
            <tr>
        
                <th>Amount</th>
                
                 <th>Daily Income (Salary)</th>
                <th>Days Paid</th>
               
                <th>Status</th>
                <th>Start Date</th>
            </tr>
        </thead>
        <tbody>
            @foreach($jobs as $job)
            
            @php
                $package = DB::table('packages')->where('price', $job->capital)->first();
            @endphp
                <tr>
                    <td>{{$package->vip ?? 40}}</td>
                    <td>{{ number_format($job->returns, 2) }}</td>
                    <td>{{ $job->days_paid }}/ {{$package->days ?? 40}}</td>
                    <td>
                        @if ($job->status == 1)
                            <span class="badge bg-success">Active</span>
                        @elseif ($job->status == 2)
                            <span class="badge bg-danger">Expired</span>
                        @else
                            <span class="badge bg-secondary">Unknown</span>
                        @endif
                    </td>
                    <td>
                        {{\Carbon\Carbon::parse($job->created_at)->addHours(3)}}
                    </td>
                </tr>
            @endforeach
        </tbody>
    </table>
</div>
    
</div>
@endsection
