@extends('layouts.main')

@section('content')
<div class="container py-5">
    
    @if (session('success'))
        <div class="alert alert-success alert-dismissible fade show" role="alert">
            <strong>Success!</strong> {{ session('success') }}
            <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                <span aria-hidden="true">&times;</span>
            </button>
        </div>
    @endif
    
    @if (session('error'))
        <div class="alert alert-danger alert-dismissible fade show" role="alert">
            <strong>Error!</strong> {{ session('error') }}
            <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                <span aria-hidden="true">&times;</span>
            </button>
        </div>
    @endif

<script>
    // Check if there is a success or error message in the session
    @if (session('success') || session('error'))
        setTimeout(function() {
            // Find the message element and fade it out after 3 seconds
            let message = document.querySelector('.alert');
            if (message) {
                message.style.transition = "opacity 0.5s ease-out";
                message.style.opacity = 0;
                setTimeout(function() {
                    message.style.display = "none";
                }, 500);  // Hide message after fading out
            }
        }, 3000);  // Wait for 3 seconds before hiding
    @endif
</script>


    @php
        $funds = DB::table('funds')->get(); // Fetch all records from the funds table
    @endphp

    @foreach ($funds as $fund)
        <div class="card shadow-sm mb-4">
            <div class="card-body p-4  position-relative">
                <div class="d-flex align-items-center">
                    <!-- Image Section -->
                    <div class="flex-shrink-0 me-4 text-center">
                        <img src="public/fund{{$fund->id}}.png" 
                             alt="Fund Image"  
                             style="width: 80px; height: 80px;" />
                    </div>
                    
                    <!-- Fund Details Section -->
                    <div class="flex-grow-1">
                        <h5 class="mb-1 text-primary"><strong>{{ $fund->vip }}</strong></h5>
                        <p class="mb-1 text-muted small">Price: <strong> {{ $settings->currency }} {{ number_format($fund->price  * $settings->rate, 2) }}</strong></p>
                        <p class="mb-1 text-muted small">Daily Income: <strong> {{ $settings->currency }} {{ number_format($fund->daily_income  * $settings->rate, 2) }}</strong></p>
                        
                        <!-- Badge for Days -->
                        <span class="badge bg-primary position-absolute top-0 end-0 m-2 p-2 rounded-pill">
                            {{ $fund->days }} Days
                        </span>
                    </div>
                </div>
                
                <!-- Action Button -->
                <div class="text-start mt-3">
                    <form action="{{ route('wealthfund.store') }}" method="POST">
                        @csrf
                        <input type="hidden" name="fund_id" value="{{ $fund->id }}">
                        <button type="submit" class="btn btn-sm outline-button rounded-pill px-4 mt-2">
                            Invest Now
                        </button>
                    </form>
                </div>
            </div>
        </div>
    @endforeach
</div>

<style>
    .outline-button {
    display: inline-block;
    padding: 5px 10px;
    font-size: 16px;
    font-weight: bold;
    color: #007bff; /* Text color */
    background-color: transparent; /* Transparent background */
    border: 2px solid #007bff; /* Solid border */
    border-radius: 5px; /* Rounded edges */
    cursor: pointer; /* Pointer cursor on hover */
    transition: all 0.3s ease; /* Smooth transition */
}

.outline-button:hover {
    background-color: #007bff; /* Background changes on hover */
    color: #fff; /* Text color changes on hover */
    border-color: #0056b3; /* Darker border on hover */
}

</style>
@endsection

