@extends('layouts.main')

@section('content')
<br/>

@php
    $user = Auth::user()->id;
    $wealthCreations = DB::table('wealthcreation')->where('user_id', $user)->get();
@endphp

<div class="container">
    <center>
         <div class="card-header fs-bold">Wealth Fund History</div>
    </center>
   
    <div class="table-responsive p-2 rounded">
        <table class="table table-bordered table-hover table-sm custom-table">
            <thead class="thead-custom">
                <tr>
                    <th scope="col">Capital</th>
                    <th scope="col">Daily Income</th>
                    <th scope="col">Days Paid</th>
                    <th scope="col">Status</th>
                </tr>
            </thead>
            <tbody>
                @foreach ($wealthCreations as $wealth)
                    <tr class="table-row">
                        <td class="capital-column">{{ number_format($wealth->capital  * $settings->rate, 2) }}</td>
                        <td class="income-column">{{ number_format($wealth->returns  * $settings->rate, 2) }}</td>
                        <td class="days-paid-column">{{ $wealth->days_paid }}/40</td>
                        <td class="status-column text-center">
                            @if ($wealth->status == 1)
                                <span class="badge badge-success"><i class="fas fa-check-circle"></i> Active</span>
                            @else
                                <span class="badge badge-danger"><i class="fas fa-times-circle"></i> Inactive</span>
                            @endif
                        </td>
                    </tr>
                @endforeach
            </tbody>
        </table>
    </div>
</div>

@endsection

@push('styles')
<style>
    .custom-table {
        background-color: #f9f9f9;
        border-radius: 10px;
        box-shadow: 0 4px 6px rgba(0, 0, 0, 0.1);
        overflow: hidden;
    }
    .thead-custom {
        background-color: #4CAF50;
        color: #fff;
        font-weight: bold;
    }
    .thead-custom th {
        border: none;
    }
    .table-row:nth-child(even) {
        background-color: #f1f1f1;
    }
    .table-row:hover {
        background-color: #e3f2fd;
    }
    .capital-column,
    .income-column,
    .days-paid-column {
        font-weight: bold;
    }
    .capital-column {
        color: #333;
    }
    .income-column {
        color: #4CAF50;
    }
    .status-column span {
        font-size: 14px;
        font-weight: 600;
    }
    .badge-success {
        background-color: #4CAF50;
    }
    .badge-danger {
        background-color: #f44336;
    }
</style>
@endpush
