@extends('layouts.main')
@section('content')
 <div class="container mt-5">
        <div class="card">
            @if(Auth::user()->survey == 'pending')
            <div class="card-header">
                <h4 class="card-text font-bold fs-bold">{{ $survey->title }}</h4>
                <p class="card-text">{{ $survey->description }}</p>
            </div>
            <div class="card-body">
                
                <form action="/survey/submit" method="POST">
                    @csrf

                    @foreach ($questions as $question)
                        <div class="mb-4">
                            <label for="question-{{ $question->id }}" class="form-label">
                                <strong>{{ $loop->iteration }}. {{ $question->question_text }}</strong>
                            </label>

                            @if ($question->question_type == 'multiple-choice')
                                <div class="form-check">
                                    @foreach ($question->answers as $answer)
                                        <div class="form-check">
                                            <input class="form-check-input" type="radio" name="questions[{{ $question->id }}]" value="{{ $answer->id }}" id="answer-{{ $answer->id }}">
                                            <label class="form-check-label" for="answer-{{ $answer->id }}">
                                                {{ $answer->answer_text }}
                                            </label>
                                        </div>
                                    @endforeach
                                </div>
                            @elseif ($question->question_type == 'text')
                                <textarea class="form-control" id="question-{{ $question->id }}" name="questions[{{ $question->id }}]" rows="4" placeholder="Your response"></textarea>
                            @endif
                        </div>
                    @endforeach
                    
                    <button type="submit" class="btn btn-primary">Submit Survey</button>
                </form>
               
            </div>
             @else
              <div class="card-footer">
                  <p>No survey Available Till Next Week</p>
              </div>
                @endif
        </div>
    </div>
    
@endsection