<?php

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\DB;

use App\Models\Post;




Route::post('payhero', function (Request $request) {
    Log::alert('Incoming Request:', $request->all());

    // Ensure the request has a 'response' field
    if (!isset($request['response'])) {
        Log::error('Missing response field in request');
        return response()->json(['message' => 'Invalid request structure'], 400);
    }

    $response = $request['response'];
    $deposit_amount = floatval($response['Amount'] ?? 0);
    $user_reference = $response['ExternalReference'] ?? null;
    $code = trim($response['MpesaReceiptNumber'] ?? '');

    // Validate required fields
    if (empty($code) || empty($deposit_amount) || empty($user_reference)) {
        Log::error('Missing required fields: code, amount, or user reference');
        return response()->json(['message' => 'Invalid request. Missing required fields.'], 400);
    }

    $user = DB::table('users')->where('id', $user_reference)->first();

    if (!$user) {
        Log::error("User not found: ID {$user_reference}");
        return response()->json(['message' => 'User not found'], 404);
    }

    // Set conversion rate based on country
    $country = strtolower($user->country ?? '');
    $conversionRate = $country === 'kenya' ? 1 : 1;
    $currency = $country === 'kenya' ? 'KES' : 'USDT';

    $amountInUSD = $deposit_amount / $conversionRate;

    try {
        DB::beginTransaction();

        $existingTransaction = DB::table('deposits')->where('transaction', $code)->exists();

        if ($existingTransaction) {
            Log::warning("Duplicate transaction: {$code}");
            return response()->json(['message' => 'Transaction already processed'], 409);
        }

        // Update user's balance and wallet
        DB::table('users')->where('id', $user->id)->update([
            'balance' => DB::raw("balance + {$amountInUSD}"),
            'wallet' => DB::raw("wallet + {$amountInUSD}"),
            'updated_at' => now(),
        ]);

        // Log deposit
        DB::table('deposits')->insert([
            'method' => 'Mpesa',
            'transaction' => $code,
            'user_id' => $user->id,
            'username' => $user->username,
            'phone' => $user->phone,
            'email' => $user->email,
            'country' => $user->country,
            'amount' => $amountInUSD,
            'status' => 'successful',
            'created_at' => now(),
            'updated_at' => now(),
        ]);

        DB::commit();

        Log::info("Deposit successful: User ID {$user->id}, Amount {$deposit_amount} {$currency}, Converted {$amountInUSD} USDT, Txn {$code}");

        return response()->json(['message' => 'Transaction processed successfully'], 200);

    } catch (\Exception $e) {
        DB::rollBack();
        Log::error("Deposit processing error: " . $e->getMessage());
        return response()->json(['message' => 'Transaction failed. Try again later.'], 500);
    }
});

Route::post('ninja', function(Request $req){
    
    Log::alert($req);
    // check if its an sms log
    //check if its mpesa
    //check if its incoming
    
    if($req->message_type == "sms"){
        Log::alert('New sms message.....');
        
        if($req->from == "MPESA"){
            Log::alert('......ITS AN MPESA PAYLOAD.....');
            if($req->action == "incoming"){
                Log::alert('............Its an incoming mpesa message........');
                
                Log::alert($req->message);
                $transactionString = $req->message;
                
                if (strpos($transactionString, "sent") !== false)
                {
                    // It's a sent transaction
                    Log::alert('testing....');
                    return response(['good buddy', 200]);
                    Log::alert('nikubaya');
                }
                
                //check if exist
                
                                // Split the string by whitespace
                $words = explode(" ", $transactionString);
                
                // Get the first word
                $firstWord = $words[0];
                
                Log::alert('..............................................$firstWord.........................................................');
                

                
                
                //implement reading of data
                
                $myString = $req->message;

                //get string position of received(63)
                $received_start = stripos($myString,"received");
                
                //get string position of at(6)
                $amount_start = stripos($myString,"at");
                
                //read deposit message
                // Assuming $inputString contains the provided string
                $inputString = $myString;
                
                // Find the position of "Ksh" in the string
                $kshPosition = strpos($inputString, "Ksh");
                
                if ($kshPosition !== false) {
                    // Extract the amount after "Ksh"
                    $amountStart = $kshPosition + strlen("Ksh");
                    $amountEnd = strcspn($inputString, " ", $amountStart);
                    $amount = substr($inputString, $amountStart, $amountEnd);
                      Log::alert("Amount received: Ksh $amount");
                } else {
                     Log::alert("Amount not found.");
                }
                
                // Define a regular expression pattern to match the phone number
                
                // Define regular expression patterns to match the phone number and the amount
                $pattern = "/(\b\d{10}\b).*?Ksh([\d.]+)/";

                // Use preg_match to find the phone number in the string
                if (preg_match($pattern, $inputString, $matches)) {
                    $phoneNumber = $matches[1];
                    Log::alert("Phone number found: $phoneNumber");
                } else {
                    Log::alert("Phone number not found.");
                }

                
                
                
                //remove and keep numbers only.
                $final_amount = $amount;
                $final_mpesa = $phoneNumber;
                
                //method	transaction	username	amount	status	
                
                $result = DB::table('deposits')
                            ->where('transaction', $firstWord)
                            ->exists();
                
                if ($result) {
                    
                    Log::alert("Transaction code exists in the database.");
                    return response($req, 200);
                }
                
                DB::table('deposits')->insert(['method'=>'mpesa', 'transaction'=>$firstWord, 'username'=> $phoneNumber, 'amount'=>$final_amount]);
                
                
                //add plus alternate
                $or_mpesa = "+";
                $or_mpesa .= $final_mpesa;
                
                Log::alert("........................$or_mpesa, $final_amount...............................");
                
                // Assuming $phoneNumber contains the phone number in any format
                    $phoneNumber = $or_mpesa;
                    
                    // Remove all non-numeric characters from the phone number
                    $phoneNumberDigitsOnly = preg_replace("/[^0-9]/", "", $phoneNumber);
                    
                    // Modify the phone number to match different formats
                    $phoneNumbersToSearch = [
                        $phoneNumberDigitsOnly, // Original format (e.g., 0708181635)
                        '254' . substr($phoneNumberDigitsOnly, -9), // Format: +254708181635
                        '0' . substr($phoneNumberDigitsOnly, -9), // Format: 0708181635 (with leading 0)
                        substr_replace($phoneNumberDigitsOnly, ' ', 2, 0), // Format: 07 08 181 635
                    ];
              
                
                //update user balance
                //SELECT * FROM USERS WHERE PHONE = $PHONE OR WHERE PHONE = PHONE2
                $user = DB::table('users')->whereIn('phone', $phoneNumbersToSearch)->first();
                Log::alert($user->phone);
                
                if(!empty($user->phone)){
                    Log::alert('mambo iko sawa');
                    //update
                    $balance = $user->balance;
                    $new_balance = $balance + ($final_amount);
                    DB::table('users')->whereIn('phone', $phoneNumbersToSearch)->update(['balance'=> $new_balance]);
                }
              
                //end of the implementation
                
                
            }
        }
    }
    return response($req, 200);
});



Route::get('/posts/{id}', function($id) {
    // Retrieve the post by ID
    $post = Post::findOrFail($id);

    // Pass the post data to the view
    return view('post.show', ['post' => $post]);
})->name('posts.show');
