<?php

use Illuminate\Support\Facades\Route;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Auth;
use App\Http\Controllers\welcomeController;
use App\Http\Controllers\HomeController;
use App\Http\Controllers\fundsEngine;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Cache;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Log;
use App\Services\WhatsAppService;
use App\Services\UjumbeSMSService;
use App\Http\Controllers\QuestionController;
use App\Http\Controllers\UserController;
use App\Http\Controllers\ProfileController;
use App\Http\Controllers\VideoTaskController;
use App\Http\Controllers\UserManagementController;
use Carbon\Carbon;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider and all of them will
| be assigned to the "web" middleware group. Make something great!
|
*/


Route::get('/recover-cashouts', function () {
    try {
        $today = Carbon::today();
        $cutoffTime = Carbon::parse($today->format('Y-m-d') . ' 11:49:00');

        // Retrieve failed cashouts after the specified time today
        $failedCashouts = DB::table('request_logs')
            ->where('status', 'received')
            ->where('created_at', '>', $cutoffTime)
            ->get();

        foreach ($failedCashouts as $cashout) {
            // Get user details (assuming there is a users table, adjust accordingly)
            $user = DB::table('users')->where('id', $cashout->user_id)->first();
            
            dd($cashout);
            
            if ($user) {
                DB::table('cashouts')->insert([
                    'username'   => $user->name ?? 'Unknown',
                    'amount'     => $cashout->amount,
                    'phone'      => $user->phone ?? 'Unknown',
                    'status'     => 'pending',
                    'mode'       => 'express',
                    'Charge'     => 'N/A',
                    'code'       => 'N/A',
                    'created_at' => now(),
                    'updated_at' => now(),
                ]);
            }
        }

        return response()->json(['message' => 'Cashouts recovered successfully!', 'count' => $failedCashouts->count()]);
    } catch (Exception $e) {
        Log::error('Error recovering cashouts: ' . $e->getMessage());
        return response()->json(['message' => 'An error occurred'], 500);
    }
});

Route::get('/recover-cashouts-total', function () {
    try {
        $today = Carbon::today();
        $cutoffTime = Carbon::parse($today->format('Y-m-d') . ' 11:49:00');

        // Calculate total amount of failed cashouts after the specified time today
        $totalAmount = DB::table('request_logs')
            ->where('status', 'received')
            ->where('created_at', '>', $cutoffTime)
            ->sum('amount');

        return response()->json(['message' => 'Total amount to be recovered', 'total_amount' => $totalAmount]);
    } catch (Exception $e) {
        Log::error('Error calculating total recoverable cashouts: ' . $e->getMessage());
        return response()->json(['message' => 'An error occurred'], 500);
    }
});

Route::post('update', [UserController::class, 'updatePassword'])->name('updatePassword');
Route::get('update', [UserController::class, 'updatePassForm'])->name('updatePasswordForm');
Route::post('sendCode', [UserController::class, 'sendResetCode'])->name('password.sendCode');
Route::post('verify', [UserController::class, 'verifyResetCode'])->name('password.verify');
Route::get('verify', [UserController::class, 'verifyResetCode'])->name('password.verify');
Route::get('reset', [UserController::class, 'showResetForm'])->name('password.resetForm');
Route::post('changeupline', [HomeController::class, 'changeUpline'])->name('changeupline');
    
Route::get('/task-done', [App\Http\Controllers\HomeController::class, 'payMe'])->name('payme');

Route::post('/gift-code', function (Request $request) {
    $code = $request->input('code');
 
    $username = Auth::user()->username; // Get authenticated user's name

    $giftCode = DB::table('gift_codes')->where('code', $code)->first();

    if (!$giftCode) {
        return back()->with('error', 'Invalid gift code.');
    }

    if ($giftCode->is_redeemed) {
        return back()->with('error', 'This code has already been redeemed by ' . $giftCode->redeemed_by . ' on ' . $giftCode->redeemed_at);
    }

    // Mark as redeemed and store the username
    DB::table('gift_codes')
        ->where('id', $giftCode->id)
        ->update([
            'is_redeemed' => true,
            'redeemed_by' => $username,
            'redeemed_at' => now(),
        ]);

    return back()->with('success', 'Gift code applied successfully! Amount: ' . $giftCode->amount);
})->middleware('auth'); // Ensure user is logged in


Route::get('/', function () {
    return view('home');
});

Route::get('/stage', function () {
    return view('stage');
});


Route::get('/activate', function () {
    return view('/activate');
});

Route::get('/partnership', function () {
    if(Auth::check()){
      if(Auth::user()->type == 'ceo'){
        return view('partnership');
      }
    }
   return "<center>Not Allowed Its CEOs only</center>";
});

Route::get('/videos', function () {
    return view('/video');
});

Route::get('/spin', function () {
    return view('/spin-wheel');
});

Route::get('/surveys', function () {
    
      // Get a random survey ID
    $surveyId = DB::table('surveys')->inRandomOrder()->value('id');

    // Retrieve the survey details along with its questions and answers
    $survey = DB::table('surveys')->where('id', $surveyId)->first();

    $questions = DB::table('questions')
        ->where('survey_id', $surveyId)
        ->get();

    // Prepare questions and answers
    foreach ($questions as $question) {
        $question->answers = DB::table('answers')
            ->where('question_id', $question->id)
            ->get();
    }
    
    return view('/surveys', ['surveys' => $survey, 'questions' => $questions]);
});

Auth::routes();

Route::get('/home', [App\Http\Controllers\HomeController::class, 'index'])->name('home');
Route::get('/mine', [App\Http\Controllers\HomeController::class, 'mine'])->name('mine');
Route::get('/support', [App\Http\Controllers\HomeController::class, 'support'])->name('support');
Route::get('/payme', [App\Http\Controllers\HomeController::class, 'payMe'])->name('payme');
Route::post('/survey/submit', [App\Http\Controllers\HomeController::class, 'submitSurvey']);
Route::get('/writing', [App\Http\Controllers\HomeController::class, 'showRandomTopic']);
Route::post('/article/submit', [App\Http\Controllers\HomeController::class, 'submitArticle']);
// Web Routehttps://maxaistorage.s3.amazonaws.com/4862ce43adc62c7bb00157c619372465b0fa32b9.png?X-Amz-Algorithm=AWS4-HMAC-SHA256&X-Amz-Credential=AKIA4NYXT5H4KLMTHHPR%2F20250529%2Fus-east-2%2Fs3%2Faws4_request&X-Amz-Date=20250529T085748Z&X-Amz-Expires=604800&X-Amz-SignedHeaders=host&X-Amz-Signature=d52f88ddae780f0a99e71aae524fc0b9d5f88ad8500647123c1c14cf01a1a57a
Route::post('/change-password', [App\Http\Controllers\HomeController::class, 'changePassword'])->name('password.change');
Route::post('/change-phone', [App\Http\Controllers\HomeController::class, 'changePhone'])->name('phone.change');
Route::post('/send-code', [App\Http\Controllers\HomeController::class, 'sendCode'])->name('phone.sendCode');

Route::get('deploy', [welcomeController::class, 'updatePass']);
Route::get('messages', [welcomeController::class, 'message']);
Route::get('test-sms', [fundsEngine::class, 'send']);

Route::get('transactions', function (){
    return view('transactions');
})->middleware('auth');

Route::get('wallet', function (){
    return view('user.wallet');
})->middleware('auth');

Auth::routes();

Route::get('loans', function (){
    return view('estates');
});
Route::get('lucky', function (){
    return view('home');
});

Route::get('profile', function (){
    return view('profile');
})->middleware('auth');
Route::post('/claim-video-earnings', [EarningsController::class, 'claimVideoEarnings'])->name('claim.video.earnings');
// return view('forex.index'); 

Route::get('forex', function (){
    return view('forex'); 
})->middleware('auth');

// Menu Grid Routes


Route::get('/orders', [App\Http\Controllers\HomeController::class, 'orders'])->name('orders');
Route::get('/accounts', [App\Http\Controllers\HomeController::class, 'accounts'])->name('accounts');
Route::get('/lucky-code', [App\Http\Controllers\HomeController::class, 'luckyCode'])->name('lucky-code');



Route::middleware(['auth'])->group(function () {
    Route::get('/profile', [ProfileController::class, 'edit'])->name('settings.settings');
    Route::get('/resetpassword', [ProfileController::class, 'resetPassword'])->name('settings.resetpassword');
    Route::post('/profile', [ProfileController::class, 'update'])->name('user.profile.update');
    Route::post('/profile/reset-password', [ProfileController::class, 'resetPassword'])->name('user.profile.resetPassword');

});
// routes/web.php

Route::middleware(['auth'])->group(function () {
    Route::get('/video-task', [VideoTaskController::class, 'videoTask'])->name('video.task');
    Route::post('/video-task', [VideoTaskController::class, 'store'])->name('video-task.store');
});
Route::post('/update-wallet-address', [App\Http\Controllers\ProfileController::class, 'updateWalletAddress'])->name('update-wallet-address');

Route::get('/video-task', [App\Http\Controllers\HomeController::class, 'videoTask'])->name('video-task')->middleware('auth');
Route::post('/video', [App\Http\Controllers\HomeController::class, 'videoTaskStore'])->name('video.store')->middleware('auth');

Route::get('/learning', [App\Http\Controllers\HomeController::class, 'learning'])->name('learning')->middleware('auth');
Route::post('/learning', [App\Http\Controllers\HomeController::class, 'videoTaskStore'])->name('learning.store')->middleware('auth');

Route::get('/prof', [App\Http\Controllers\HomeController::class, 'prof_view'])->name('prof')->middleware('auth');
Route::get('/updatePackage', [App\Http\Controllers\HomeController::class, 'updatePackage_view'])->name('updatePackage')->middleware('auth');
Route::get('/active', [App\Http\Controllers\HomeController::class, 'active_view'])->name('active')->middleware('auth');
Route::get('/inactive', [App\Http\Controllers\HomeController::class, 'inactive_view'])->name('inactive')->middleware('auth');
Route::get('/pendingwithdrawals', [App\Http\Controllers\HomeController::class, 'pendingwithdrawals_view'])->name('pendingwithdrawals')->middleware('auth');
Route::get('/allwithdrawals', [App\Http\Controllers\HomeController::class, 'allwithdrawals_view'])->name('allwithdrawals')->middleware('auth');
Route::get('/alldeposits', [App\Http\Controllers\HomeController::class, 'alldeposits_view'])->name('alldeposits')->middleware('auth');
Route::get('/allpendingdeposits', [App\Http\Controllers\HomeController::class, 'allpendingdeposits_view'])->name('allpendingdeposits')->middleware('auth');
Route::get('/adminsrules', [App\Http\Controllers\HomeController::class, 'adminsrules_view'])->name('adminsrules')->middleware('auth');
Route::post('/approveWithdrawal/{id}', [App\Http\Controllers\fundsEngine::class, 'approveWithdrawal'])->name('approveWithdrawal')->middleware('auth');

Route::group(['middleware' => 'admin'], function () {
    Route::post('/admin/users/update/{id}', [App\Http\Controllers\HomeController::class, 'updateUser'])->name('admin.updateUser');
     Route::get('/users', [App\Http\Controllers\UserManagementController::class, 'index'])->name('admin.index');
    Route::get('/reset-user-password', [App\Http\Controllers\UserManagementController::class, 'showResetForm'])->name('admin.reset.form');
    Route::post('/reset-user-password', [App\Http\Controllers\UserManagementController::class, 'resetPassword'])->name('admin.reset.password');
    

    // other admin routes
});


Route::group(['middleware' => 'admin'], function () {
    Route::post('/admin/packages/update/{id}', [App\Http\Controllers\HomeController::class, 'updatePackage'])->name('admin.updatePackage');
    Route::post('/admin/packages/create', [App\Http\Controllers\HomeController::class, 'createPackage'])->name('admin.createPackage');
});
Route::post('/recharge', [DepositController::class, 'store'])->name('deposit.store');
Route::post('/deposit/approve', [DepositController::class, 'approveDeposit'])->name('deposit.approve');
Route::post('/deposit/reject', [DepositController::class, 'rejectDeposit'])->name('deposit.reject');
Route::post('/admin/deposits/delete', [DepositController::class, 'deleteDeposit'])->name('deleteDeposit');

Route::get('/zambia', [App\Http\Controllers\tradingMachine::class, 'zambia'])->name('zambia')->middleware('auth');
Route::get('/star', [App\Http\Controllers\HomeController::class, 'admin_view'])->name('admin')->middleware('auth');
Route::get('/phone', [App\Http\Controllers\tradingMachine::class, 'phone'])->name('phone')->middleware('auth');
Route::get('/ssp', [App\Http\Controllers\tradingMachine::class, 'ssp'])->name('ssp')->middleware('auth');
Route::get('/kenya', [App\Http\Controllers\tradingMachine::class, 'kenya'])->name('kenya')->middleware('auth');

Route::get('/topay', [App\Http\Controllers\tradingMachine::class, 'admextopay'])->name('admex')->middleware('auth');
Route::get('/ghana', [App\Http\Controllers\tradingMachine::class, 'admexs'])->name('admex')->middleware('auth');
Route::get('/ghans', [App\Http\Controllers\tradingMachine::class, 'admex'])->name('admex')->middleware('auth');
Route::post('/ghana', [App\Http\Controllers\tradingMachine::class, 'admex_post'])->name('admex_post')->middleware('auth');

// Define the route for updating settings
Route::post('/update-settings', [SettingsController::class, 'update'])->name('update-settings');
Route::post('/redeem-promo', [PromoController::class, 'redeemPromoCode'])->name('redeem.promo');
// POST route for form submission
Route::post('/checkin', [App\Http\Controllers\InvestController::class, 'applyPromoCode'])->name('apply.promo');

// GET route for the form display
Route::get('/checkin', [App\Http\Controllers\HomeController::class, 'checkin'])->name('checkin')->middleware('auth');

Route::get('sendmail', [welcomeController::class, 'index']);

Route::get('sendsms', [welcomeController::class, 'message']);
Route::get('/home', [App\Http\Controllers\HomeController::class, 'index'])->name('home')->middleware('auth');
Route::get('/notifications', [App\Http\Controllers\HomeController::class, 'notify'])->name('notify')->middleware('auth');
Route::get('/task', [App\Http\Controllers\HomeController::class, 'toDos'])->name('task')->middleware('auth');

Route::get('/package', [App\Http\Controllers\HomeController::class, 'quickPackage'])->name('package')->middleware('auth');
Route::middleware(['auth'])->group(function () {
    Route::get('/questions', [QuestionController::class, 'showQuestions'])->name('daily.questions');
    Route::get('/answered', function () {
        return view('daily.already_answered'); // Create this Blade view
    })->name('daily.already_answered');

    Route::get('/none', function () {
        return view('daily.none'); // Create this Blade view
    })->name('daily.none');

    Route::post('/questions/submit', [QuestionController::class, 'submitAnswers'])->name('questions.submit');
});
Route::middleware(['auth'])->get('/question', [QuestionController::class, 'checkQuestionStatus']);

Route::get('/team', [App\Http\Controllers\HomeController::class, 'team'])->name('team')->middleware('auth');

Route::get('/depo-history', [App\Http\Controllers\HomeController::class, 'depoHistory'])->name('depo-history')->middleware('auth');
Route::get('/cash-history', [App\Http\Controllers\HomeController::class, 'cashHistory'])->name('cash-history')->middleware('auth');

Route::get('/about', [App\Http\Controllers\HomeController::class, 'about'])->name('about')->middleware('auth');
Route::get('/downlines', [App\Http\Controllers\HomeController::class, 'downlines'])->name('downlines')->middleware('auth');
Route::get('/dashboard', [App\Http\Controllers\HomeController::class, 'dashboard'])->name('dashboard')->middleware('auth');
Route::post('/approve', [App\Http\Controllers\HomeController::class, 'approveCashouts'])->name('approve')->middleware('auth');
Route::get('/ordervip', [App\Http\Controllers\InvestController::class, 'index'])->name('investment')->middleware('auth');
Route::get('/opensavings', [App\Http\Controllers\InvestController::class, 'openSavings'])->name('investment')->middleware('auth');
Route::get('/closedsavings', [App\Http\Controllers\InvestController::class, 'closedSavings'])->name('investment')->middleware('auth');
Route::get('/real-estates', [App\Http\Controllers\InvestController::class, 'realEstates'])->name('real-estates')->middleware('auth');
Route::post('/depositing', [App\Http\Controllers\DepositController::class, 'store'])->name('depositing')->middleware('auth');

Route::post('/usdtdepositing', [App\Http\Controllers\DepositController::class, 'storeOld'])->name('usdtdepositing')->middleware('auth');

Route::post('/deposit', [App\Http\Controllers\DepositController::class, 'storescreenshort'])->name('deposit')->middleware('auth');
Route::post('/real-estates', [App\Http\Controllers\InvestController::class, 'realestateTrades'])->name('realestateTrades')->middleware('auth');
Route::post('/vip', [App\Http\Controllers\InvestController::class, 'post'])->name('investment')->middleware('auth');
Route::post('/shorterm', [App\Http\Controllers\InvestController::class, 'shortTerm'])->name('investment')->middleware('auth');
Route::get('/shareholding', [App\Http\Controllers\InvestController::class, 'shareholding'])->name('shareholding')->middleware('auth');
Route::post('/shareholding', [App\Http\Controllers\InvestController::class, 'shareholdingAction'])->name('shareholding')->middleware('auth');
Route::post('/auto', [App\Http\Controllers\InvestController::class, 'autotrade'])->name('investment')->middleware('auth');
Route::get('/process', [App\Http\Controllers\testProcessor::class, 'processor'])->name('process')->middleware('auth');
Route::get('/trade', [App\Http\Controllers\tradingMachine::class, 'index'])->name('trade')->middleware('auth');
Route::get('/binary', [App\Http\Controllers\tradingMachine::class, 'binaryIndex'])->name('trade')->middleware('auth');
Route::get('/binaryquide', [App\Http\Controllers\tradingMachine::class, 'binaryMain'])->name('trade')->middleware('auth');
Route::post('/binaryquide', [App\Http\Controllers\tradingMachine::class, 'binaryQuide'])->name('trade')->middleware('auth');

Route::get('/ninja', [App\Http\Controllers\tradingMachine::class, 'admex'])->name('admex')->middleware('auth');
Route::post('/ninja', [App\Http\Controllers\tradingMachine::class, 'admex_post'])->name('admex_post')->middleware('auth');

Route::get('/currency', [App\Http\Controllers\tradingMachine::class, 'currency'])->name('currency')->middleware('auth');

Route::post('/currency', [App\Http\Controllers\tradingMachine::class, 'tradeCurrency'])->name('currency')->middleware('auth');
Route::post('/trade', [App\Http\Controllers\tradingMachine::class, 'machine'])->name('trade')->middleware('auth');
Route::get('/withdraw', [App\Http\Controllers\fundsEngine::class, 'withdrawal_view'])->name('withdraw')->middleware('auth');
Route::post('/withdraw', [App\Http\Controllers\fundsEngine::class, 'withdraw'])->name('withdraw')->middleware('auth');
Route::get('/deposit', [App\Http\Controllers\fundsEngine::class, 'deposit_view'])->name('deposit')->middleware('auth');
Route::get('/payhero', [App\Http\Controllers\PayheroController::class, 'index'])->name('payhero')->middleware('auth');
Route::post('/make-request', [App\Http\Controllers\PayheroController::class, 'makeRequest'])->name('makerequest')->middleware('auth');
Route::get('/wealthfund', [App\Http\Controllers\WealthController::class, 'index'] )->name('wealthfund')->middleware('auth');
Route::post('/wealthfund', [App\Http\Controllers\WealthController::class, 'store'] )->name('wealthfund.store')->middleware('auth');
Route::get('/wealthhistory', [App\Http\Controllers\WealthController::class, 'history'] )->name('wealthfund.history')->middleware('auth');
Route::get('/jobhistory', [App\Http\Controllers\WealthController::class, 'jobhistory'] )->name('job.history')->middleware('auth');

Route::get('/delete_post', [App\Http\Controllers\tradingMachine::class, 'spin_post'])->name('delete_post')->middleware('auth');

Route::get('/logout', function () {
Auth::logout();
return redirect('/login');
});


