<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    
<title><?php echo e(env('APP_NAME')); ?> - Learn more about crypto and get paid </title>
<link rel="icon" type="image/png" href="<?php echo e(asset('public/asset/WhatsApp Image 2025-07-18 at 12.10.58 PM.jpeg')); ?>">

    <!-- ✅ Bootstrap 5 CDN -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">

    <!-- ✅ Font Awesome CDN -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">

    <!-- ✅ Custom CSS -->
    <link rel="stylesheet" href="public/assets/css/style.css">
</head>
<?php
$user = Auth::user();
$country = strtolower(trim($user->country));

// Base currency: KES
$currency = 'KES';
$exchange = 1;
$payTo = '3725674';
$method = 'M-PESA BUY GOODS';
$to = 'BRIAN KIARIE';

// Convert from KES → Local Currency
switch ($country) {
    case 'tanzania':
        $currency = 'TZS';
        $exchange = 20; // 1 KES = 20 TZS
        $payTo = '+255612345678';
        $method = 'Tigo Pesa Tanzania';
        $to = 'TOGO';
        break;

    case 'uganda':
        $currency = 'UGX';
        $exchange = 32; // 1 KES = 32 UGX
        $payTo = '+256772345678';
        $method = 'MTN Uganda';
        $to = '';
        break;

    case 'rwanda':
        $currency = 'RWF';
        $exchange = 9.8;
        $payTo = '+250782334455';
        $method = 'MTN Rwanda';
        $to = 'MTN';
        break;

    case 'botswana':
        $currency = 'BWP';
        $exchange = 0.13;
        $payTo = '+26771234567';
        $method = 'Orange Money Botswana';
        $to = 'ORANGE';
        break;

    case 'south sudan':
        $currency = 'SSP';
        $exchange = 10;
        $payTo = '809856';
        $method = 'Agent ID';
        $to = 'Agent';
        break;

    case 'cameroon':
        $currency = 'XAF';
        $exchange = 4.8;
        $payTo = '+237612345678';
        $method = 'MTN Cameroon';
        $to = 'MTN';
        break;

    case 'west africa':
    case 'cote d’ivoire':
    case 'ivory coast':
        $currency = 'XOF';
        $exchange = 4.7;
        $payTo = '+2250123456789';
        $method = 'Orange Money West Africa';
        $to = 'Orange';
        break;

    case 'ghana':
        $currency = 'GHS';
        $exchange = 0.089;
        $payTo = '+233501234567';
        $method = 'MTN Ghana';
        $to = 'MTN';
        break;

    case 'malawi':
        $currency = 'MWK';
        $exchange = 12.5;
        $payTo = '+265991234567';
        $method = 'Airtel Money Malawi';
        $to = 'Airtel';
        break;

    case 'zambia':
        $currency = 'ZMW';
        $exchange = 0.19;
        $payTo = '+260971234567';
        $method = 'MTN Zambia';
        $to = 'MTN';
        break;

    case 'nigeria':
        $currency = 'NGN';
        $exchange = 5.6;
        $payTo = '+2347012345678';
        $method = 'Bank Transfer Nigeria';
        $to = 'Bank';
        break;

    case 'usa':
    case 'united states':
        $currency = 'USD';
        $exchange = 0.00769; // 1 KES = 0.00769 USD
        $payTo = 'TViTtvuJo2DkABCexampleWallet9876';
        $method = 'USDT (TRC20)';
        $to = 'Binance';
        break;

    // Fallback for unsupported or missing countries
    default:
        $currency = 'KES';
        $exchange = 1;
        $payTo = '3725674';
        $method = 'M-PESA BUY GOODS';
        $to = 'BRIAN KIARIE';
        break;
}

$convertedAmount = number_format(5 * $exchange, 2); // 5 KES converted
?>

<style>

  
  
    
    body {
  margin: 0;
  font-family: 'Arial', sans-serif;
  background: linear-gradient(to bottom, #001d00, #004d00);
  color: white;
}

.app-container {
  max-width: 400px;
  margin: auto;
  padding-bottom: 100px;
}

.header {
  display: flex;
  align-items: center;
  justify-content: space-between;
  background: #00cc66;
  padding: 10px 15px;
  border-radius: 15px;
  font-size: 18px;
}

.avatar {
  border-radius: 50%;
  width: 40px;
  height: 40px;
}

.translate-btn {
  background-color: #002200;
  color: white;
  border: none;
  padding: 6px 12px;
  border-radius: 10px;
  cursor: pointer;
  font-size: 14px;
}

.banner img {
  width: 100%;
  border-radius: 15px;
  margin: 15px 0;
}

.buttons-row {
  display: flex;
  justify-content: space-around;
  margin-bottom: 20px;
}

.buttons-row button {
  background-color: transparent;
  border: none;
  padding: 10px;
  font-size: 13px;
  border-radius: 12px;
  border:1px solid green;
  color: white;
  font-weight: bold;
  cursor: pointer;
  display: flex;
  flex-direction: column;
  align-items: center;
}

.buttons-row i {
  font-size: 18px;
  margin-bottom: 3px;
}

.bot-card {
  background-color: #003300;
  border-radius: 15px;
  padding: 15px;
  margin: 5px 0;
  box-shadow: 0 0 10px #00ff99;
}

.bot-info {
  display: flex;
  align-items: center;
  gap: 15px;
}

.bot-info img {
  width: 60px;
  height: 60px;
  border-radius: 50%;
}

.invest-btn {
  width: 100%;
  margin-top: 5px;
  background-color: #00ffcc;
  color: black;
  border: none;
  padding: 5px;
  font-weight: bold;
  border-radius: 10px;
  font-size: 12px;
  cursor: pointer;
}

    .bottom-nav {
  display: flex;
  justify-content: space-around;
  align-items: center;
  background-color: #001f00;
 padding: 10px 15px;
  position: fixed;
  bottom: 0;
  width: 100%;
  /*max-width: 400px;*/
  border-top: 1px solid #00ff99;
}

.bottom-nav button {
  background: none;
  border: none;
  color: white;
  font-size: 12px;
  text-align: center;
  cursor: pointer;
}

.bottom-nav i {
  font-size: 20px;
  margin-bottom: 3px;
}

/* Green Icon Styling */
.green-icon {
  color: #00ff99;
  font-size: 20px;
  margin-bottom: 4px;
}

</style>
<body>

<div class="container py-2">

<!-- Header -->
<div class="header d-flex justify-content-between align-items-center fixed-top px-2">
    <div class="d-flex align-items-center">
        <img src="public/assets/img/ntslogo.jpeg" alt="Avatar" class="avatar me-2">
        <h5 class="mb-0 app-title"><?php echo e(env('APP_NAME')); ?></h5>
    </div>
    <button class="btn btn-sm translate-btn" onclick="window.location.href='<?php echo e(url('/deposit')); ?>'" >
        <i class="fas fa-globe"></i> <?php echo e($currency); ?>:<?php echo e(number_format(Auth::user()->balance * $exchange, 2)); ?>

    </button>
</div>

<div class="content-scrollable">
    
    
        <?php echo $__env->yieldContent('content'); ?>
</div>
<hr>
</div>

<footer class="bottom-nav d-flex justify-content-around py-2 w-100">
    <div class="nav-btn text-center" onclick="window.location.href='<?php echo e(url('/home')); ?>'" style="cursor: pointer;">
        <i class="fas fa-home green-icon"></i><br>HOME
    </div>
    <div class="nav-btn text-center" onclick="window.location.href='<?php echo e(url('/orders')); ?>'" style="cursor: pointer;">
        <i class="fas fa-dollar-sign green-icon"></i><br>ORDER
    </div>
    <div class="nav-btn text-center" onclick="window.location.href='<?php echo e(url('/downlines')); ?>'" style="cursor: pointer;">
        <i class="fas fa-share-alt green-icon"></i><br>SHARE
    </div>
    <div class="nav-btn text-center" onclick="window.location.href='<?php echo e(url('/mine')); ?>'" style="cursor: pointer;">
        <i class="fas fa-user green-icon"></i><br>MINE
    </div>
</footer>



</body>
</html>
</html><?php /**PATH /home/bfundeoz/nxts.site/resources/views/layouts/main.blade.php ENDPATH**/ ?>