<?php $__env->startSection('content'); ?>
<?php

            $user = Auth::user();
            $countryCode = $user->country_code ?? '';

            if ($countryCode == '254') { // Kenya
                $conversionRate = 130; // 1 USDT = 130 KES
                $currency = 'KES';
            } elseif ($countryCode == '260') { // Zambia
                $conversionRate = 30; // 1 USDT = 30 ZMW
                $currency = 'ZMW';
            } elseif ($countryCode == '233') { // Ghana
            
                $conversionRate = 15; // 1 USDT = 30 GHS
                $currency = 'GHS';
            }  elseif ($countryCode == '211') { // South sudan
                $conversionRate = 4450; // 1 USDT = 30 SSP
                $currency = 'SSP';
            } elseif ($countryCode == '256') { // Uganda
            
                $conversionRate = 3675; // 1 USDT = 3675 UGX
                $currency = 'UGX';
            } else { // Default to USD for other countries
                $conversionRate = 1;
                $currency = 'USD';
            }

            $convertedBalance = $user->balance / $conversionRate;
            $min = 1 * $conversionRate;



           $cashouts = DB::table('cashouts')->where('phone', Auth::user()->phone)->get();

            

?>

<main class="container mt-3">
    <h6 class="mb-3">Withdrawal History</h6>

    <?php if($cashouts->isEmpty()): ?>
        <div class="alert alert-info small">No withdrawal records found.</div>
    <?php else: ?>
        <div class="table-responsive">
            <table class="table table-bordered table-sm table-hover" style="font-size: 0.52rem;">
                <thead class="table-light">
                    <tr>
                        <th>#</th>
                        <th>Username</th>
                        <th>Amount</th>
                        <th>Phone</th>
                        <th>Status</th>
                        <th>Date</th>
                    </tr>
                </thead>
                <tbody>
                    <?php $__currentLoopData = $cashouts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $c): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr>
                            <td><?php echo e($index + 1); ?></td>
                            <td><?php echo e($c->username); ?></td>
                            <td>KES <?php echo e(number_format($c->amount, 2)); ?></td>
                            <td><?php echo e($c->phone); ?></td>
                            <td>
                                <?php if($c->status == 'pending'): ?>
                                    <span class="badge bg-warning text-dark">Pending</span>
                                <?php elseif($c->status == 'approved'): ?>
                                    <span class="badge bg-success">Approved</span>
                                <?php else: ?>
                                    <span class="badge bg-danger">Rejected</span>
                                <?php endif; ?>
                            </td>
                            <td><?php echo e(\Carbon\Carbon::parse($c->created_at)->format('d M Y, h:i A')); ?></td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
            </table>
        </div>
    <?php endif; ?>
</main>


<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/bfundeoz/asheq.top/resources/views/cashouts/cashHistory.blade.php ENDPATH**/ ?>