<?php $__env->startSection('content'); ?>
<?php
use Carbon\Carbon;
use Illuminate\Support\Facades\DB;
$totalusers = DB::table('users')->get();
$totalusersCount = $totalusers->count();

$activeusers = DB::table('users')->where('investments', '>', 0)->count();
$inactiveusers = DB::table('users')->where('investments', '=<', 0)->count();


$totaInvest = DB::table('users')->get();
$totaInvestCount = $totaInvest->sum('investments');

$totaDeposits = DB::table('deposits') ->where('amount', '>', 6)->get();
$totalDep = $totaDeposits->sum('amount');
$approvedDepositsTotal = DB::table('deposits')->whereIn('status', ['successful','approved']) ->where('amount', '>', 6)->sum('amount');
    
    
    // -----------------track today's funds-------------------------
    
    $today = Carbon::today(); // Gets today's date at 00:00:00

$todayDeposit = DB::table('deposits')->whereDate('created_at', '=', $today) ->where('amount', '>', 2)->sum('amount');
    
$todayCashouts = DB::table('cashouts')->whereDate('created_at', '=', $today)->sum('amount');
    
    
// ----------------end------------------

$todaysRevenue = $todayDeposit - $todayCashouts;

$rejectedDepositsTotal = DB::table('deposits')
    ->where('status', 'approved')
    ->sum('amount');
$ghanawiythd = DB::table('cashouts')->where('gateway_method', 'mtn')->sum('amount');

    
$DepositsTotal = DB::table('deposits')
    ->where('status', 'approved')
    ->count();
$totaCashouts = DB::table('cashouts')->get();
$totaCashoutsCount = $totaCashouts->sum('amount');

$companyRevenue = $totalDep - $totaCashoutsCount;
?>
<?php
$user = Auth::user();
$country = strtolower(trim($user->country));

// Base currency: KES
$currency = 'KES';
$exchange = 1;
$payTo = '3725674';
$method = 'M-PESA BUY GOODS';
$to = 'BRIAN KIARIE';

// Convert from KES → Local Currency
switch ($country) {
    case 'tanzania':
        $currency = 'TZS';
        $exchange = 20; // 1 KES = 20 TZS
        $payTo = '+255612345678';
        $method = 'Tigo Pesa Tanzania';
        $to = 'TOGO';
        break;

    case 'uganda':
        $currency = 'UGX';
        $exchange = 32; // 1 KES = 32 UGX
        $payTo = '+256772345678';
        $method = 'MTN Uganda';
        $to = '';
        break;

    case 'rwanda':
        $currency = 'RWF';
        $exchange = 9.8;
        $payTo = '+250782334455';
        $method = 'MTN Rwanda';
        $to = 'MTN';
        break;

    case 'botswana':
        $currency = 'BWP';
        $exchange = 0.13;
        $payTo = '+26771234567';
        $method = 'Orange Money Botswana';
        $to = 'ORANGE';
        break;

    case 'south sudan':
        $currency = 'SSP';
        $exchange = 10;
        $payTo = '809856';
        $method = 'Agent ID';
        $to = 'Agent';
        break;

    case 'cameroon':
        $currency = 'XAF';
        $exchange = 4.8;
        $payTo = '+237612345678';
        $method = 'MTN Cameroon';
        $to = 'MTN';
        break;

    case 'west africa':
    case 'cote d’ivoire':
    case 'ivory coast':
        $currency = 'XOF';
        $exchange = 4.7;
        $payTo = '+2250123456789';
        $method = 'Orange Money West Africa';
        $to = 'Orange';
        break;

    case 'ghana':
        $currency = 'GHS';
        $exchange = 0.089;
        $payTo = '+233501234567';
        $method = 'MTN Ghana';
        $to = 'MTN';
        break;

    case 'malawi':
        $currency = 'MWK';
        $exchange = 12.5;
        $payTo = '+265991234567';
        $method = 'Airtel Money Malawi';
        $to = 'Airtel';
        break;

    case 'zambia':
        $currency = 'ZMW';
        $exchange = 0.19;
        $payTo = '+260971234567';
        $method = 'MTN Zambia';
        $to = 'MTN';
        break;

    case 'nigeria':
        $currency = 'NGN';
        $exchange = 5.6;
        $payTo = '+2347012345678';
        $method = 'Bank Transfer Nigeria';
        $to = 'Bank';
        break;

    case 'usa':
    case 'united states':
        $currency = 'USD';
        $exchange = 0.00769; // 1 KES = 0.00769 USD
        $payTo = 'TViTtvuJo2DkABCexampleWallet9876';
        $method = 'USDT (TRC20)';
        $to = 'Binance';
        break;

    // Fallback for unsupported or missing countries
    default:
        $currency = 'KES';
        $exchange = 1;
        $payTo = '3725674';
        $method = 'M-PESA BUY GOODS';
        $to = 'BRIAN KIARIE';
        break;
}

$convertedAmount = number_format(5 * $exchange, 2); // 5 KES converted
?>

    

                    <div class="container-fluid px-4" style="background-color:#2121A9;">
                        <h1 class="mt-4" style="font-size:18px;color:#49FF4F;">Admin Panel Home Page</h1>
                           
                               <div class="col-xl-3 col-md-6">
                                <div class="card bg-success text-white mb-4">
                                    
                                                                         <div class="card-body">Todays Deposits</div>
                                    <div class="card-footer d-flex align-items-center justify-content-between" style="font-size:14px; background-color:#3C5586;">
                                        <a class="small text-white stretched-link" href="#"><?php echo e($currency); ?> <?php echo e(number_format($todayDeposit * $exchange,2)); ?> </a>
                                        
                                        
                                        <div class="small text-white"><i class="fas fa-angle-right"></i></div>
                                    </div>
                                      <div class="card-body">Todays Cashouts</div>
                                    <div class="card-footer d-flex align-items-center justify-content-between" style="font-size:14px;background-color:#CFD9FF;">
                                       
                                        <a class="small text-black stretched-link" href="#"><?php echo e($currency); ?> <?php echo e(number_format($todayCashouts * $exchange,2)); ?> </a>
                                        
                                        <div class="small text-black"><i class="fas fa-angle-right"></i></div>
                                    </div>
                                       <div class="card-body">Today's company Revenue</div>
                                    <div class="card-footer d-flex align-items-center justify-content-between" style="font-size:14px; background-color:#E6E6E6; color:#D30000;">
                                       
                                        <a class="small text-black stretched-link" href="#" style=" color:#D30000;"><?php echo e($currency); ?> <?php echo e(number_format($todaysRevenue * $exchange,2)); ?></a>
                                        
                                        <div class="small text-black"><i class="fas fa-angle-right"></i></div>
                                    </div>
                                </div>
                            </div>
                        <div class="row">
                            <div class="col-xl-3 col-md-6">
                                <div class="card bg-primary text-white mb-4">
                                    <div class="card-body">Total Users</div>
                                    <div class="card-footer d-flex align-items-center justify-content-between">
                                        <a class="small text-white stretched-link" href="#"><?php echo e($totalusersCount); ?> Users</a>
                                        <div class="small text-white"><i class="fas fa-angle-right"></i></div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-xl-3 col-md-6">
                                <div class="card bg-warning text-white mb-4">
                                    <div class="card-body">Active Users</div>
                                    <div class="card-footer d-flex align-items-center justify-content-between">
                                        <a class="small text-white stretched-link" href="#"><?php echo e($activeusers); ?> Active Users</a>
                                        <div class="small text-white"><i class="fas fa-angle-right"></i></div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-xl-3 col-md-6">
                                <div class="card bg-danger text-white mb-4">
                                    <div class="card-body">InActive Users</div>
                                    <div class="card-footer d-flex align-items-center justify-content-between">
                                        <a class="small text-white stretched-link" href="#"><?php echo e($inactiveusers); ?> In_Active Users</a>
                                        <div class="small text-white"><i class="fas fa-angle-right"></i></div>
                                    </div>
                                </div>
                            </div>
              
                            <div class="col-xl-3 col-md-6">
                                <div class="card bg-success text-white mb-4">
                                    <div class="card-body">Total Deposits </div>
                                    
                                    <div class="card-footer d-flex align-items-center justify-content-between" style="font-size:14px;">
                                        <a class="small text-white stretched-link" href="#"><?php echo e($currency); ?> <?php echo e(number_format($approvedDepositsTotal* $exchange,2)); ?></a>
                                        
                                        
                                        <div class="small text-white"><i class="fas fa-angle-right"></i></div>
                                    </div>
                                </div>
                            </div>
                             <div class="col-xl-3 col-md-6">
                                <div class="card bg-warning text-white mb-4">
                                    <div class="card-body">Total Investment</div>
                                    <div class="card-footer d-flex align-items-center justify-content-between" style="font-size:14px;">
                                        <a class="small text-white stretched-link" href="#"><?php echo e($currency); ?> <?php echo e(number_format($totaInvestCount* $exchange,2)); ?></a>
                                        
                                        <div class="small text-white"><i class="fas fa-angle-right"></i></div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-xl-3 col-md-6">
                                <div class="card bg-danger text-white mb-4">
                                    <div class="card-body">Total Withdrawals</div>
                                    <div class="card-footer d-flex align-items-center justify-content-between"  style="font-size:14px;">
                                        <a class="small text-white stretched-link" href="#"><?php echo e($currency); ?> <?php echo e(number_format($totaCashoutsCount* $exchange,2)); ?></a>
                                        
                                        <div class="small text-white"><i class="fas fa-angle-right"></i></div>
                                    </div>
                                </div>
                            </div>
                            
                            <div class="col-xl-3 col-md-6">
                                <div class="card bg-success text-white mb-4">
                                    <div class="card-body">Company Profits</div>
                                    <div class="card-footer d-flex align-items-center justify-content-between" style="font-size:14px;">
                                        <a class="small text-white stretched-link" href="#"><?php echo e($currency); ?> <?php echo e(number_format($companyRevenue* $exchange,2)); ?></a>
                                        
                                        <div class="small text-white"><i class="fas fa-angle-right"></i></div>
                                    </div>
                                </div>
                            </div>
                        </div>
                  <div class="card mb-4">
    <div class="card-header">
        <i class="fas fa-table me-1"></i>
        DataTable Example
    </div>
    <div class="card-body">
        <table id="datatablesSimple">
            <thead>
                <tr>
                    <th>Id</th>
                    <th>Name</th>
                    <th>Phone</th>
                    <th>Balance</th>
                    <th>Invest</th>
                    <th>CashOut</th>
                </tr>
            </thead>

            <tbody>
                <?php
                $totalmembers = DB::table('users')->paginate(10);
                ?>
                <?php $__currentLoopData = $totalmembers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <tr>
                    <td><?php echo e($user->id); ?></td>
                    <td><?php echo e($user->email); ?></td>
                    <td><?php echo e($user->phone); ?></td>
                    <td><?php echo e($user->balance * $exchange); ?></td>
                    <td><?php echo e($user->investments * $exchange); ?></td>
                    <td><?php echo e($user->cashouts * $exchange); ?></td>
                </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </tbody>
        </table>

        <!-- Pagination Links -->
        <div class="mt-3">
            <?php echo e($totalmembers->links()); ?>

        </div>
    </div>
</div>

</div>
                    
    <?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.admins', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/bfundeoz/nxts.site/resources/views/user/admin.blade.php ENDPATH**/ ?>