<?php $__env->startSection('content'); ?>
    <!-- Begin page -->
    <main class="h-100 m-1 pt-3">
        <style>
            .z-index-800 {
                z-index: 800;
                position: relative;
            }

            /* Tooltip for copy message */
            #copy-message {
                display: none;
                color: green;
                font-size: 0.875rem;
                margin-top: 5px;
            }

            .card {
                transition: transform 0.2s, box-shadow 0.2s;
            }

            .card:hover {
                transform: scale(1.05);
                box-shadow: 0 5px 15px rgba(0, 0, 0, 0.2);
            }

            .badge {
                font-size: 0.875rem;
                padding: 3px 6px;
                border-radius: 5px;
            }

            .btn-primary {
                background-color: #007bff;
                border-color: #007bff;
            }

            .btn-primary:hover {
                background-color: #0056b3;
                border-color: #0056b3;
            }

            .container h6 {
                font-weight: bold;
            }

            .card-header {
                border-radius: 0.25rem 0.25rem 0 0;
            }

            .badge-inactive {
                background-color: #f8d7da;
                color: #721c24;
            }

            .user-icon {
                width: 50px;
                height: 50px;
                border-radius: 50%;
                background-color: #f0f0f0;
                display: flex;
                justify-content: center;
                align-items: center;
                font-size: 1.25rem;
                color: #555;
                margin-right: 10px;
            }
        </style>

        <?php
            $transactions = \DB::table('users')
                ->where(function ($query) {
                        $query->where('upline', Auth::user()->username)
                              ->orWhere('upline', Auth::user()->id);
                    })
                ->get();
        ?>

        <div class="mt-4 container">
            <?php
            $people = DB::table('users')
                 ->where(function ($query) {
                        $query->where('upline', Auth::user()->username)
                              ->orWhere('upline', Auth::user()->id);
                    })
                ->latest('id')
                ->get();
            ?>
           
            
          
            <?php if($transactions->count() > 0): ?>
                <div class="d-flex justify-content-between align-items-center mb-4">
                    <div>
                        <h6 class="mb-0">Downlines Invited</h6>
                        <small class="text-muted">Up to Today, <?php echo e(date('Y-m-d')); ?></small>
                    </div>
                    <div>
                     
       
            
            <!-- Button trigger modal -->
            <button type="button" class="btn btn-primary btn-sm" data-bs-toggle="modal" data-bs-target="#addUserReferer">
             add downlines
            </button>
            
 <div id="addUserReferer" class="modal fade" tabindex="-1" role="dialog">
                                            <div class="modal-dialog" role="document">
                                                <div class="modal-content">
                                                    <div class="modal-header">
                                                        <h5 class="modal-title">
                                                            Recover Your Downline
                                                        </h5>
                                                        <button type="button" class="close" data-dismiss="modal"
                                                            aria-label="Close">
                                                            <span aria-hidden="true" class="feather icon-close"></span>
                                                        </button>
                                                    </div>
                                                    <form action="<?php echo e(route('changeupline')); ?>"
                                                        method="POST">
                                                       <?php echo csrf_field(); ?>
                                                       <input type="hidden" value="<?php echo e($user->id ?? '1'); ?>" name="userid">
                                                        <div class="modal-body">
                                                            <div class="form-row">
                                                                <div class="form-group col-md-12">
                                                                    <label>Username<span
                                                                            class="text-danger">*</span></label>
                                                                    <div class="input-group has_append">
                                                                        <input type="text" name="username"
                                                                            class="form-control"
                                                                            placeholder="Please enter a valid Username" />
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div>
                                                        <div class="modal-footer">
                                                            <button type="button" class="btn btn-dark"
                                                                data-dismiss="modal">
                                                                Close
                                                            </button>
                                                            <button type="submit" class="btn btn-success">
                                                                Send
                                                            </button>
                                                        </div>
                                                    </form>
                                                </div>
                                            </div>
                                        </div>


                    </div>
                </div>

                <div class="row">
                    <?php $__currentLoopData = $people; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $p): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="col-12 col-md-6 col-lg-4 mb-4">
                            <div class="card p-1 shadow-sm border-light">
                               
                                <div class="card-body p-3">
                                    <div class="d-flex align-items-center">
                                        <div class="user-icon">
                                            <?php echo e(substr($p->phone, -2)); ?>

                                        </div>
                                        <div class="d-flex flex-column">
                                             
                                            <h6 class="mb-2">Bonus: <br><span class="text-primary">KES <?php echo e(number_format($p->investments * 0.06, 2)); ?></span></h6>
                                            <p class="mb-0 text-muted">Phone: <?php echo e($p->phone); ?></p>
                                        </div>
                                         <span class="badge <?php echo e($p->investments > 0 ? 'badge-success' : 'badge-inactive'); ?>">
                                                    <?php echo e($p->investments > 0 ? 'Active' : 'Inactive'); ?>

                                                </span>
                                    </div>
                                </div>
                            </div>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
            <?php else: ?>
                <div class="text-center">
                    <img src="/images/empty-team.svg" alt="No team" class="mb-3" style="max-width: 200px;">
                    <p class="text-muted">No team built yet. Start inviting your downlines today!</p>
                </div>
            <?php endif; ?>
        </div>

        <!-- Copy message display -->
        <div id="copy-message" class="text-center mt-3"></div>

    </main>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/sahuapp.work/public_html/resources/views/user/downlines.blade.php ENDPATH**/ ?>