<?php $__env->startSection('content'); ?>
<div class="container mt-5 my-0 py-0">
    <div class="card my-0 py-0">
        <div class="my-0 py-0 card-header bg-primary text-white">
            <h5 class="mb-0">Investment History</h5>
        </div>
        <div class="card-body my-0 p-1">
            <?php
                use Illuminate\Support\Facades\DB;
                use Carbon\Carbon;

                // Fetch investments directly using DB::query()
                $investments = DB::table('invest')
                    ->where('user_id', auth()->id())
                    ->orderBy('created_at', 'desc')
                    ->get();
            ?>

            <?php if($investments->isEmpty()): ?>
                <p class="text-muted">No investments found.</p>
            <?php else: ?>
                <div class="table-responsive">
                    <table class="table table-sm table-striped table-bordered">
                        <thead class="thead-dark table-sm">
                            <tr>
                            
                                <th>Status</th>
                               
                                <th>Capital</th>
                                <th>Returns</th>
                               
                                <th>Days Paid</th>
                                <th>Start Date</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $__currentLoopData = $investments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $investment): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                   
                                    <td><?php echo e($investment->status ? 'Active' : 'Inactive'); ?></td>
                                  
                                    <td><?php echo e(number_format($investment->capital, 2)); ?></td>
                                    <td><?php echo e(number_format($investment->returns, 2)); ?></td>
                                 
                                  
                                    <td><?php echo e($investment->days_paid); ?>/20</td>
                                    <td><?php echo e(Carbon::parse($investment->date)->addHours(3)->format('Y-m-d H:i:s')); ?></td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                    </table>
                </div>
            <?php endif; ?>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/qubitscube.cfd/public_html/resources/views/article.blade.php ENDPATH**/ ?>