<!doctype html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <meta name="description" content="">
    <meta name="author" content="">
    <meta name="generator" content="">
    <title><?php echo e(env('APP_NAME')); ?></title>
    <!-- Google fonts-->
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link href="https://fonts.googleapis.com/css2?family=Open+Sans:wght@300;400;600;700&display=swap" rel="stylesheet">

    <!-- bootstrap icons -->
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.5.0/font/bootstrap-icons.css">

    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.css" />

    <script src="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.js"></script>
    <!--tailwind css 3-->
    <link href="<?php echo e(env('APP_RES')); ?>/bootstrap/css/bootstrap.css" rel="stylesheet">
    <link href="<?php echo e(env('APP_RES')); ?>/assets/css/style.css" rel="stylesheet">
</head>


<body class="body-scroll" data-page="addmoney">


    <?php echo $__env->make('script', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <!-- Begin page -->
    <!-- Begin page -->
    <main class="h-screen mt-10 pt-10">

        <!-- Header -->
        <header class="fixed top-0 left-0 right-0 text-white  p-4 z-10">
            <div class="flex items-center justify-between">
                <div class="">
                    <a href="home">
                        <button type="button" class="bg-gray-100 shadow rounded-lg text-gray-700 px-2 font-bold">
                            <i class="bi bi-arrow-left"></i>
                        </button>
                    </a>
                </div>

            </div>
        </header>
        <!-- Header ends -->
        <!-- Main page content -->
        <div class="container mt-20 mx-4">
            <div class="col-12">
                <div class="row my-3 py-4">
                    <div class="col-7 align-self-center">
                        <h1 class="mb-2 uppercase font-semibold">
                            <span class="fw-light text-gray-100">Hello <?php echo e(Auth::user()->username); ?>

                            </span>
                        <p class="text-muted text-xs">Phone:<?php echo e(Auth::user()->phone); ?>, user_id:<?php echo e(Auth::user()->id); ?></p>
                    </div>
                </div>
            </div>
        </div>

        <!-- location map-->
        <div class="row mb-4 mx-4">
            <div class="col-12">
                <div class="card shadow-sm">
                    <div class="card-body">
                        <figure class="w-full">
                            <img src="assets/img/map@2x.png" class="w-full" alt="">
                        </figure>
                        <div class="row">
                            <div class="col">
                                <p class="mb-1"><?php echo e(Auth::user()->username); ?></p>
                                <p class="text-secondary text-xs"><?php echo e(Auth::user()->phone); ?></p>
                            </div>
                            <div class="col-auto align-self-center">
                                <button class="btn btn-link text-color-theme btn-44">
                                    <i class="bi bi-arrow-up-right-circle fs-2"></i>
                                </button>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- People -->
        <div class="row mb-2 mx-4">
            <div class="col">
                <h6 class="text-xl font-medium ">Team Invited</h6>
            </div>
            <div class="col-auto">
                <a href="downlines" class="text-xs bg-blue-700 text-white py-2 px-10 text-center rounded-md">View
                    More</a>
            </div>
        </div>
        <div class="row mb-3">
            <div class="col-12 px-0">
                <!-- swiper users connections -->
                <div class=" ">
                    <div class="mx-2">
                        <?php
                        $people = DB::table('users')
                            ->where('upline', Auth::user()->ref_code)
                            ->latest('id')
                            ->get();
                        ?>
                        <?php if($people->count() > 0): ?>
                            <?php $__currentLoopData = $people; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $p): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <div class="card mx-3 m-2">
                                    <span class="bg-gray-300 h-12 w-full rounded pt-2 text-center ">
                                        <div class="row p-1 justify-evenly">
                                            <p class="col"><?php echo e($p->status); ?></p>
                                            <p class="col"><?php echo e($p->username); ?> </p>
                                            <p class="col"> <?php echo e($p->phone); ?> </p>
                                        </div>
                                    </span>
                                </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>
        </div>
        <!-- main page content ends -->
    </main>
    <!-- Page ends-->

    <!-- Required jquery and libraries -->
    <script src="public/assets/js/jquery-3.3.1.min.js"></script>
    <script src="public/assets/js/popper.min.js"></script>
    <script src="public/assets/vendor/bootstrap-5/js/bootstrap.bundle.min.js"></script>

    <!-- Customized jquery file  -->
    <script src="public/assets/js/main.js"></script>
    <script src="public/assets/js/color-scheme.js"></script>

    <!-- PWA app service registration and works -->
    <script src="public/assets/js/pwa-services.js"></script>

    <!-- Chart js script -->
    <script src="public/assets/vendor/chart-js-3.3.1/chart.min.js"></script>

    <!-- Progress circle js script -->
    <script src="public/assets/vendor/progressbar-js/progressbar.min.js"></script>

    <!-- swiper js script -->
    <script src="public/assets/vendor/swiperjs-6.6.2/swiper-bundle.min.js"></script>

    <!-- page level custom script -->
    <script src="public/assets/js/app.js"></script>
</body>

</html>
<?php /**PATH /home/nakamoto/Desktop/webs/etica/resources/views/profile.blade.php ENDPATH**/ ?>